/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.locale;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Locale;

@Immutable
public final class LocaleFormatter {
    private static final LocaleFormatter INSTANCE = new LocaleFormatter();

    private LocaleFormatter() {
    }

    @Nonnull
    public static String getFormatted(double d, @Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        return NumberFormat.getNumberInstance(locale).format(d);
    }

    @Nonnull
    public static String getFormatted(int n, @Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        return NumberFormat.getIntegerInstance(locale).format(n);
    }

    @Nonnull
    public static String getFormatted(long l, @Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        return NumberFormat.getIntegerInstance(locale).format(l);
    }

    @Nonnull
    public static String getFormatted(@Nonnull BigInteger bigInteger, @Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)bigInteger, (String)"Value");
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        return NumberFormat.getIntegerInstance(locale).format(bigInteger);
    }

    @Nonnull
    public static String getFormatted(@Nonnull BigDecimal bigDecimal, @Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)bigDecimal, (String)"Value");
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        return NumberFormat.getInstance(locale).format(bigDecimal);
    }

    @Nonnull
    public static String getFormatted(@Nonnull BigDecimal bigDecimal, @Nonnegative int n, @Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)bigDecimal, (String)"Value");
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        numberFormat.setMinimumFractionDigits(n);
        numberFormat.setMaximumFractionDigits(n);
        return numberFormat.format(bigDecimal);
    }

    @Nonnull
    public static String getFormattedWithAllFractionDigits(@Nonnull BigDecimal bigDecimal, @Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)bigDecimal, (String)"Value");
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        numberFormat.setMaximumFractionDigits(bigDecimal.scale());
        return numberFormat.format(bigDecimal);
    }

    @Nonnull
    public static String getFormattedPercent(double d, @Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        return NumberFormat.getPercentInstance(locale).format(d);
    }

    @Nonnull
    public static String getFormattedPercent(double d, @Nonnegative int n, @Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)locale, (String)"DisplayLocale");
        NumberFormat numberFormat = NumberFormat.getPercentInstance(locale);
        numberFormat.setMinimumFractionDigits(n);
        numberFormat.setMaximumFractionDigits(n);
        return numberFormat.format(d);
    }
}

