/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text.resourcebundle;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.text.AbstractHasText;
import com.helger.text.IHasTextWithArgs;
import com.helger.text.resourcebundle.ResourceBundleKey;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;

@Immutable
@MustImplementEqualsAndHashcode
public class ResourceBundleTextProvider
extends AbstractHasText
implements IHasTextWithArgs {
    private final ResourceBundleKey m_aResBundleKey;

    public ResourceBundleTextProvider(@Nonnull String string, @Nonnull String string2) {
        this(new ResourceBundleKey(string, string2));
    }

    public ResourceBundleTextProvider(@Nonnull ResourceBundleKey resourceBundleKey) {
        this.m_aResBundleKey = (ResourceBundleKey)ValueEnforcer.notNull((Object)resourceBundleKey, (String)"ResBundleKey");
    }

    @Override
    @Nullable
    protected String internalGetText(@Nonnull Locale locale) {
        return this.m_aResBundleKey.getString(locale);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ResourceBundleTextProvider resourceBundleTextProvider = (ResourceBundleTextProvider)object;
        return this.m_aResBundleKey.equals(resourceBundleTextProvider.m_aResBundleKey);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aResBundleKey).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("resBundleKey", (Object)this.m_aResBundleKey).getToString();
    }
}

