/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.sax;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.io.resource.IReadableResource;
import com.helger.io.resourceresolver.DefaultResourceResolver;
import com.helger.xml.sax.InputSourceFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultEntityResolver
implements EntityResolver {
    private final String m_sBaseURI;

    public DefaultEntityResolver(@Nonnull URL uRL) {
        this(uRL.toExternalForm());
    }

    public DefaultEntityResolver(@Nonnull String string) {
        this.m_sBaseURI = (String)ValueEnforcer.notNull((Object)string, (String)"BaseURI");
    }

    @Nonnull
    public final String getBaseURI() {
        return this.m_sBaseURI;
    }

    @Override
    @Nullable
    public InputSource resolveEntity(@Nullable String string, @Nullable String string2) throws SAXException, IOException {
        IReadableResource iReadableResource = DefaultResourceResolver.getResolvedResource((String)string2, (String)this.m_sBaseURI);
        return InputSourceFactory.create(iReadableResource);
    }

    @Nullable
    public static DefaultEntityResolver createOnDemand(@Nonnull IReadableResource iReadableResource) {
        URL uRL = iReadableResource.getAsURL();
        return uRL == null ? null : new DefaultEntityResolver(uRL);
    }
}

