/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.convert;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.reflection.GenericReflection;
import com.helger.base.spi.ServiceLoaderHelper;
import com.helger.collection.commons.CommonsWeakHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.typeconvert.util.ClassHierarchyCache;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.IMicroTypeConverterCallback;
import com.helger.xml.microdom.convert.IMicroTypeConverterRegistrarSPI;
import com.helger.xml.microdom.convert.IMicroTypeConverterRegistry;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MicroTypeConverterRegistry
implements IMicroTypeConverterRegistry {
    public static final boolean DEFAULT_USE_CLASS_HIERARCHY = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroTypeConverterRegistry.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final ICommonsMap<Class<?>, IMicroTypeConverter<?>> m_aMap = new CommonsWeakHashMap();
    private boolean m_bUseClassHierarchy = false;

    private MicroTypeConverterRegistry() {
        this.reinitialize();
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static MicroTypeConverterRegistry getInstance() {
        MicroTypeConverterRegistry microTypeConverterRegistry = SingletonHolder.INSTANCE;
        s_bDefaultInstantiated = true;
        return microTypeConverterRegistry;
    }

    public boolean isUseClassHierarchy() {
        return this.m_bUseClassHierarchy;
    }

    public void setUseClassHierarchy(boolean bl) {
        if (this.m_bUseClassHierarchy != bl) {
            this.m_bUseClassHierarchy = bl;
            this.reinitialize();
        }
    }

    @Override
    public <T> void registerMicroElementTypeConverter(@Nonnull Class<T> clazz, @Nonnull IMicroTypeConverter<T> iMicroTypeConverter) {
        this._registerMicroElementTypeConverter(clazz, iMicroTypeConverter);
    }

    private <T> void _registerMicroElementTypeConverter(@Nonnull Class<T> clazz, @Nonnull IMicroTypeConverter<T> iMicroTypeConverter) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        ValueEnforcer.notNull(iMicroTypeConverter, (String)"Converter");
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aMap.containsKey((Object)clazz)) {
                throw new IllegalArgumentException("A micro type converter for class " + String.valueOf(clazz) + " is already registered!");
            }
            if (this.m_bUseClassHierarchy) {
                for (WeakReference weakReference : ClassHierarchyCache.getClassHierarchyIterator((Class)clazz)) {
                    Class clazz2 = (Class)weakReference.get();
                    if (clazz2 == null || this.m_aMap.containsKey((Object)clazz2)) continue;
                    this.m_aMap.put((Object)clazz2, (Object)iMicroTypeConverter);
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Registered micro type converter for '" + clazz2.toString() + "'");
                }
            } else {
                this.m_aMap.put((Object)clazz, (Object)iMicroTypeConverter);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Registered micro type converter for '" + clazz.toString() + "'");
                }
            }
        });
    }

    @Nullable
    public <T> IMicroTypeConverter<T> getConverterToMicroElement(@Nullable Class<T> clazz) {
        return (IMicroTypeConverter)GenericReflection.uncheckedCast((Object)((IMicroTypeConverter)this.m_aRWLock.readLockedGet(() -> (IMicroTypeConverter)this.m_aMap.get((Object)clazz))));
    }

    @Nullable
    public <T> IMicroTypeConverter<T> getConverterToNative(@Nonnull Class<T> clazz) {
        ValueEnforcer.notNull(clazz, (String)"DestClass");
        IMicroTypeConverter iMicroTypeConverter = (IMicroTypeConverter)this.m_aRWLock.readLockedGet(() -> {
            IMicroTypeConverter iMicroTypeConverter;
            block3: {
                block2: {
                    iMicroTypeConverter = (IMicroTypeConverter)this.m_aMap.get((Object)clazz);
                    if (iMicroTypeConverter == null) break block2;
                    if (!LOGGER.isTraceEnabled()) break block3;
                    LOGGER.trace("Using micro type converter " + String.valueOf(iMicroTypeConverter) + " for class " + String.valueOf(clazz) + " based on direct match");
                    break block3;
                }
                if (this.m_bUseClassHierarchy) {
                    for (WeakReference weakReference : ClassHierarchyCache.getClassHierarchyIterator((Class)clazz)) {
                        Class clazz2 = (Class)weakReference.get();
                        if (clazz2 == null || (iMicroTypeConverter = (IMicroTypeConverter)this.m_aMap.get((Object)clazz2)) == null) continue;
                        if (!LOGGER.isTraceEnabled()) break;
                        LOGGER.trace("Using micro type converter " + String.valueOf(iMicroTypeConverter) + " for class " + String.valueOf(clazz) + " based on " + String.valueOf(clazz2));
                        break;
                    }
                }
            }
            return iMicroTypeConverter;
        });
        return (IMicroTypeConverter)GenericReflection.uncheckedCast((Object)iMicroTypeConverter);
    }

    public void iterateAllRegisteredMicroTypeConverters(@Nonnull IMicroTypeConverterCallback iMicroTypeConverterCallback) {
        Map.Entry entry;
        ICommonsMap iCommonsMap = (ICommonsMap)this.m_aRWLock.readLockedGet(() -> this.m_aMap.getClone());
        Iterator iterator = iCommonsMap.entrySet().iterator();
        while (iterator.hasNext() && !iMicroTypeConverterCallback.call((Class)(entry = (Map.Entry)iterator.next()).getKey(), (IMicroTypeConverter)entry.getValue()).isBreak()) {
        }
    }

    @Nonnegative
    public int getRegisteredMicroTypeConverterCount() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aMap.size());
    }

    public void reinitialize() {
        this.m_aRWLock.writeLocked(() -> {
            this.m_aMap.clear();
            for (IMicroTypeConverterRegistrarSPI iMicroTypeConverterRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(IMicroTypeConverterRegistrarSPI.class)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Calling registerMicroTypeConverter on " + iMicroTypeConverterRegistrarSPI.getClass().getName());
                }
                iMicroTypeConverterRegistrarSPI.registerMicroTypeConverter(this);
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.getRegisteredMicroTypeConverterCount() + " micro type converters registered");
        }
    }

    static final class SingletonHolder {
        private static final MicroTypeConverterRegistry INSTANCE = new MicroTypeConverterRegistry();

        SingletonHolder() {
        }
    }
}

