/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.util.statistics;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.helper.CollectionSort;
import com.helger.statistics.api.IStatisticsHandlerCache;
import com.helger.statistics.api.IStatisticsHandlerCounter;
import com.helger.statistics.api.IStatisticsHandlerKeyedCounter;
import com.helger.statistics.api.IStatisticsHandlerKeyedSize;
import com.helger.statistics.api.IStatisticsHandlerKeyedTimer;
import com.helger.statistics.api.IStatisticsHandlerSize;
import com.helger.statistics.api.IStatisticsHandlerTimer;
import com.helger.statistics.visit.IStatisticsVisitorCallback;
import com.helger.xml.microdom.IMicroElement;
import jakarta.annotation.Nonnull;
import java.util.Collection;

public class StatisticsVisitorCallbackToXML
implements IStatisticsVisitorCallback {
    private final IMicroElement m_eRoot;

    public StatisticsVisitorCallbackToXML(@Nonnull IMicroElement iMicroElement) {
        this.m_eRoot = (IMicroElement)ValueEnforcer.notNull((Object)iMicroElement, (String)"Root");
    }

    @Nonnull
    public IMicroElement getRoot() {
        return this.m_eRoot;
    }

    public void onCache(String string, IStatisticsHandlerCache iStatisticsHandlerCache) {
        if (iStatisticsHandlerCache.getInvocationCount() > 0) {
            ((IMicroElement)((IMicroElement)((IMicroElement)this.m_eRoot.addElement("cache").setAttribute("name", string)).setAttribute("invocationcount", iStatisticsHandlerCache.getInvocationCount())).setAttribute("hits", iStatisticsHandlerCache.getHits())).setAttribute("misses", iStatisticsHandlerCache.getMisses());
        }
    }

    public void onTimer(String string, IStatisticsHandlerTimer iStatisticsHandlerTimer) {
        if (iStatisticsHandlerTimer.getInvocationCount() > 0) {
            ((IMicroElement)((IMicroElement)((IMicroElement)((IMicroElement)((IMicroElement)this.m_eRoot.addElement("timer").setAttribute("name", string)).setAttribute("invocationcount", iStatisticsHandlerTimer.getInvocationCount())).setAttribute("min", iStatisticsHandlerTimer.getMin())).setAttribute("average", iStatisticsHandlerTimer.getAverage())).setAttribute("max", iStatisticsHandlerTimer.getMax())).setAttributeWithConversion("sum", iStatisticsHandlerTimer.getSum());
        }
    }

    public void onKeyedTimer(String string, IStatisticsHandlerKeyedTimer iStatisticsHandlerKeyedTimer) {
        if (iStatisticsHandlerKeyedTimer.getInvocationCount() > 0) {
            IMicroElement iMicroElement = (IMicroElement)((IMicroElement)this.m_eRoot.addElement("keyedtimer").setAttribute("name", string)).setAttribute("invocationcount", iStatisticsHandlerKeyedTimer.getInvocationCount());
            for (String string2 : CollectionSort.getSorted((Collection)iStatisticsHandlerKeyedTimer.getAllKeys())) {
                ((IMicroElement)((IMicroElement)((IMicroElement)((IMicroElement)((IMicroElement)iMicroElement.addElement("key").setAttribute("name", string2)).setAttribute("invocationcount", iStatisticsHandlerKeyedTimer.getInvocationCount(string2))).setAttribute("min", iStatisticsHandlerKeyedTimer.getMin(string2))).setAttribute("average", iStatisticsHandlerKeyedTimer.getAverage(string2))).setAttribute("max", iStatisticsHandlerKeyedTimer.getMax(string2))).setAttributeWithConversion("sum", iStatisticsHandlerKeyedTimer.getSum(string2));
            }
        }
    }

    public void onSize(String string, IStatisticsHandlerSize iStatisticsHandlerSize) {
        if (iStatisticsHandlerSize.getInvocationCount() > 0) {
            ((IMicroElement)((IMicroElement)((IMicroElement)((IMicroElement)((IMicroElement)this.m_eRoot.addElement("size").setAttribute("name", string)).setAttribute("invocationcount", iStatisticsHandlerSize.getInvocationCount())).setAttribute("min", iStatisticsHandlerSize.getMin())).setAttribute("average", iStatisticsHandlerSize.getAverage())).setAttribute("max", iStatisticsHandlerSize.getMax())).setAttributeWithConversion("sum", iStatisticsHandlerSize.getSum());
        }
    }

    public void onKeyedSize(String string, IStatisticsHandlerKeyedSize iStatisticsHandlerKeyedSize) {
        if (iStatisticsHandlerKeyedSize.getInvocationCount() > 0) {
            IMicroElement iMicroElement = (IMicroElement)((IMicroElement)this.m_eRoot.addElement("keyedsize").setAttribute("name", string)).setAttribute("invocationcount", iStatisticsHandlerKeyedSize.getInvocationCount());
            for (String string2 : CollectionSort.getSorted((Collection)iStatisticsHandlerKeyedSize.getAllKeys())) {
                ((IMicroElement)((IMicroElement)((IMicroElement)((IMicroElement)((IMicroElement)iMicroElement.addElement("key").setAttribute("name", string2)).setAttribute("invocationcount", iStatisticsHandlerKeyedSize.getInvocationCount(string2))).setAttribute("min", iStatisticsHandlerKeyedSize.getMin(string2))).setAttribute("average", iStatisticsHandlerKeyedSize.getAverage(string2))).setAttribute("max", iStatisticsHandlerKeyedSize.getMax(string2))).setAttributeWithConversion("sum", iStatisticsHandlerKeyedSize.getSum(string2));
            }
        }
    }

    public void onCounter(String string, IStatisticsHandlerCounter iStatisticsHandlerCounter) {
        if (iStatisticsHandlerCounter.getInvocationCount() > 0) {
            ((IMicroElement)((IMicroElement)this.m_eRoot.addElement("counter").setAttribute("name", string)).setAttribute("invocationcount", iStatisticsHandlerCounter.getInvocationCount())).setAttribute("count", iStatisticsHandlerCounter.getCount());
        }
    }

    public void onKeyedCounter(String string, IStatisticsHandlerKeyedCounter iStatisticsHandlerKeyedCounter) {
        if (iStatisticsHandlerKeyedCounter.getInvocationCount() > 0) {
            IMicroElement iMicroElement = (IMicroElement)((IMicroElement)this.m_eRoot.addElement("keyedcounter").setAttribute("name", string)).setAttribute("invocationcount", iStatisticsHandlerKeyedCounter.getInvocationCount());
            for (String string2 : CollectionSort.getSorted((Collection)iStatisticsHandlerKeyedCounter.getAllKeys())) {
                ((IMicroElement)((IMicroElement)iMicroElement.addElement("key").setAttribute("name", string2)).setAttribute("invocationcount", iStatisticsHandlerKeyedCounter.getInvocationCount(string2))).setAttribute("count", iStatisticsHandlerKeyedCounter.getCount(string2));
            }
        }
    }
}

