/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal;

import com.ibm.db2.cmx.runtime.internal.DataProperties;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;

public class PrivilegedActionHelper {
    public static final ClassLoader getApplicationClassloader() {
        if (DataProperties.runningUnderSecurityManager_) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public static final PrivilegedExceptionAction<FileInputStream> getFileAsFileInputStream(final File file) {
        return new PrivilegedExceptionAction<FileInputStream>(){

            @Override
            public FileInputStream run() throws FileNotFoundException {
                return new FileInputStream(file);
            }
        };
    }

    public static final PrivilegedExceptionAction<BufferedWriter> getFileAsBufferedWriter(final String string) {
        return new PrivilegedExceptionAction<BufferedWriter>(){

            @Override
            public BufferedWriter run() throws IOException {
                return new BufferedWriter(new FileWriter(string));
            }
        };
    }

    public static final PrivilegedExceptionAction<FileOutputStream> getFileAsFileOutputStream(final String string, final boolean bl2) {
        return new PrivilegedExceptionAction<FileOutputStream>(){

            @Override
            public FileOutputStream run() throws FileNotFoundException {
                return new FileOutputStream(string, bl2);
            }
        };
    }

    public static final PrivilegedAction<Boolean> canReadFile(final File file) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.canRead();
            }
        };
    }

    public static final PrivilegedAction<Boolean> canWriteFile(final File file) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.canWrite();
            }
        };
    }

    public static final PrivilegedExceptionAction<Boolean> createNewFile(final File file) {
        return new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws IOException {
                return file.createNewFile();
            }
        };
    }

    public static final PrivilegedExceptionAction<File> createTempFile(final String string, final String string2) {
        return new PrivilegedExceptionAction<File>(){

            @Override
            public File run() throws IOException {
                return File.createTempFile(string, string2);
            }
        };
    }

    public static final PrivilegedExceptionAction<File> createTempFile(final String string, final String string2, final File file) {
        return new PrivilegedExceptionAction<File>(){

            @Override
            public File run() throws IOException {
                return File.createTempFile(string, string2, file);
            }
        };
    }

    public static final PrivilegedAction<Boolean> deleteFile(final File file) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.delete();
            }
        };
    }

    public static final PrivilegedAction<Boolean> doesFileExist(final File file) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        };
    }

    public static final PrivilegedExceptionAction<String> getFileCanonicalPath(final File file) {
        return new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws IOException {
                return file.getCanonicalPath();
            }
        };
    }

    public static final PrivilegedAction<Boolean> isFileDirectory(final File file) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.isDirectory();
            }
        };
    }

    public static final PrivilegedAction<Boolean> isFile(final File file) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.isFile();
            }
        };
    }

    public static final PrivilegedAction<Boolean> isFileHidden(final File file) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.isHidden();
            }
        };
    }

    public static final PrivilegedAction<Long> getFileLastModified(final File file) {
        return new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return file.lastModified();
            }
        };
    }

    public static final PrivilegedAction<Long> getFileLength(final File file) {
        return new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return file.length();
            }
        };
    }

    public static final PrivilegedAction<String[]> getFileList(final File file) {
        return new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                return file.list();
            }
        };
    }

    public static final PrivilegedAction<String[]> getFileList(final File file, final FilenameFilter filenameFilter) {
        return new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                return file.list(filenameFilter);
            }
        };
    }

    public static final PrivilegedAction<File[]> getFileListFiles(final File file) {
        return new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return file.listFiles();
            }
        };
    }

    public static final PrivilegedAction<File[]> getFileListFiles(final File file, final FileFilter fileFilter) {
        return new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return file.listFiles(fileFilter);
            }
        };
    }

    public static final PrivilegedAction<File[]> getFileListFiles(final File file, final FilenameFilter filenameFilter) {
        return new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return file.listFiles(filenameFilter);
            }
        };
    }

    public static final PrivilegedAction<Boolean> mkdir(final File file) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.mkdir();
            }
        };
    }

    public static final PrivilegedAction<Boolean> mkdirs(final File file) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.mkdirs();
            }
        };
    }

    public static final PrivilegedAction<Boolean> renameFileTo(final File file, final File file2) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.renameTo(file2);
            }
        };
    }

    public static final PrivilegedAction<Boolean> setFileLastModified(final File file, final long l8) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.setLastModified(l8);
            }
        };
    }

    public static final PrivilegedAction<Boolean> setFileReadOnly(final File file) {
        return new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.setReadOnly();
            }
        };
    }

    public static final PrivilegedAction<Object> mkdirsForParentFileIfExists(final File file) {
        return new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                File file2 = file.getParentFile();
                if (null != file2 && !file2.exists()) {
                    file2.mkdirs();
                }
                return null;
            }
        };
    }

    public static final PrivilegedExceptionAction<RandomAccessFile> getRandomAccessFile(final String string, final String string2) {
        return new PrivilegedExceptionAction<RandomAccessFile>(){

            @Override
            public RandomAccessFile run() throws FileNotFoundException {
                return new RandomAccessFile(string, string2);
            }
        };
    }

    public static final PrivilegedExceptionAction<RandomAccessFile> getRandomAccessFile(final File file, final String string) {
        return new PrivilegedExceptionAction<RandomAccessFile>(){

            @Override
            public RandomAccessFile run() throws FileNotFoundException {
                return new RandomAccessFile(file, string);
            }
        };
    }
}

