/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess;

import com.ibm.db2.cmx.runtime.ResultIterator;
import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryDataFactory;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.CaptureData;
import com.ibm.db2.cmx.runtime.internal.repository.sql.pkg.pk1.AccessMetaData;
import com.ibm.db2.cmx.runtime.internal.repository.sql.pkg.pk2.AccessMetaDataAppl;
import com.ibm.db2.cmx.runtime.internal.repository.sql.pkg.pk2.Capturedata_t;
import com.ibm.db2.cmx.runtime.internal.repository.sql.pkg.pk3.AccessMetaDataLite;
import com.ibm.db2.cmx.runtime.internal.repository.util.SQLUtilities;
import com.ibm.db2.cmx.runtime.internal.repository.util.StreamUtils;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CaptureDataReader {
    private String schema;

    public static CaptureDataReader getInstance(String string) {
        return new CaptureDataReader(string);
    }

    public CaptureDataReader(String string) {
        this.schema = string;
    }

    public List<CaptureData> getValues(Connection connection) throws MetadataException {
        AccessMetaDataLite accessMetaDataLite = RepositoryDataFactory.getData(AccessMetaDataLite.class, connection);
        List<CaptureData> list = null;
        try {
            List<Map<String, Object>> list2 = accessMetaDataLite.getCDR();
            list = this.processResultSet(list2);
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_METADATA_INFO", new Object[0]), dataRuntimeException);
        }
        return list;
    }

    public List<CaptureData> getValues(Connection connection, String string) throws MetadataException {
        AccessMetaDataLite accessMetaDataLite = RepositoryDataFactory.getData(AccessMetaDataLite.class, connection);
        List<CaptureData> list = null;
        try {
            List<Map<String, Object>> list2 = accessMetaDataLite.getCDR(string);
            list = this.processResultSet(list2);
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_METADATA_INFO", new Object[0]), dataRuntimeException);
        }
        return list;
    }

    public CaptureData getValue(Connection connection, int n2) throws MetadataException {
        AccessMetaDataAppl accessMetaDataAppl = RepositoryDataFactory.getData(AccessMetaDataAppl.class, connection);
        CaptureData captureData = null;
        List<CaptureData> list = null;
        try {
            List<Map<String, Object>> list2 = accessMetaDataAppl.getCDR(n2);
            list = this.processResultSet(list2);
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_METADATA_INFO", new Object[0]), dataRuntimeException);
        }
        if (list != null && list.size() > 0) {
            captureData = list.get(0);
        }
        return captureData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getContentFor(Connection connection, int n2, OutputStream outputStream) throws IOException, MetadataException {
        Object object;
        AccessMetaDataLite accessMetaDataLite = RepositoryDataFactory.getData(AccessMetaDataLite.class, connection);
        boolean bl2 = false;
        Iterator<InputStream> iterator = null;
        try {
            iterator = accessMetaDataLite.getCDR2(n2);
            while (iterator.hasNext()) {
                object = iterator.next();
                bl2 = true;
                StreamUtils.copyStream((InputStream)object, outputStream);
                ((InputStream)object).close();
            }
        }
        finally {
            if (iterator != null) {
                ((ResultIterator)iterator).close();
            }
        }
        if (!bl2) {
            object = Messages.getText("ERR_INVALID_CAPTURE_DATA_KEY", n2);
            throw new MetadataException((String)object, null);
        }
    }

    public static Iterator<Capturedata_t> getDataByProject(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws MetadataException {
        AccessMetaData accessMetaData = RepositoryDataFactory.getData(AccessMetaData.class, connection);
        Iterator<Capturedata_t> iterator = null;
        try {
            iterator = accessMetaData.getCaptureDataByProject(string, string2, string3, string4, string5, string6, string7, string8, string9, string10);
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), dataRuntimeException);
        }
        return iterator;
    }

    public static Iterator<Capturedata_t> getDataByGroup(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws MetadataException {
        AccessMetaDataLite accessMetaDataLite = RepositoryDataFactory.getData(AccessMetaDataLite.class, connection);
        Iterator<Capturedata_t> iterator = null;
        try {
            iterator = accessMetaDataLite.getCaptureDataByGroup(string, string2, string3, string4, string5, string6, string7, string8, string9, string10);
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), dataRuntimeException);
        }
        return iterator;
    }

    private List<CaptureData> processResultSet(List<Map<String, Object>> list) {
        ArrayList<CaptureData> arrayList = new ArrayList<CaptureData>();
        int n2 = list.size();
        for (int i10 = 0; i10 < n2; ++i10) {
            Map<String, Object> map = list.get(i10);
            int n3 = ((Number)map.get("capturedata_key")).intValue();
            String string = (String)map.get("group_name");
            String string2 = (String)map.get("group_version");
            Timestamp timestamp = SQLUtilities.getTimestampFromObject(map.get("update_time"));
            long l8 = timestamp != null ? timestamp.getTime() : -1L;
            Number number = (Number)map.get("content_length");
            int n4 = number != null ? number.intValue() : -1;
            String string3 = (String)map.get("state");
            Timestamp timestamp2 = SQLUtilities.getTimestampFromObject(map.get("state_transition_time"));
            Long l9 = null;
            if (timestamp2 != null) {
                l9 = timestamp2.getTime();
            }
            arrayList.add(new CaptureData(n3, string, string2, n4, l8, string3, l9));
        }
        return arrayList;
    }
}

