/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models;

import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.PDQDiffReportException;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.Constants;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.IClassification;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.PDQBaseModel;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.PackageClassification;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.PackageContainer;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.PackageModel;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.StatementClassification;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.models.StatementModel;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.internal.repository.HTMLTemplateLoader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DifferenceModel {
    private Map<IClassification, Collection<PackageContainer>> pkgClassify = new LinkedHashMap<IClassification, Collection<PackageContainer>>();
    private PDQBaseModel basePdqModel = null;
    private PackageModel prevPkgModel = null;
    private PDQBaseModel.StatementSetModel effectiveStmtSetModel = null;
    private PackageContainer currPkgCntnr = null;

    public DifferenceModel(PDQBaseModel pDQBaseModel) {
        this(PackageClassification.REBIND_PACKAGES, PackageClassification.NEW_PACKAGES, PackageClassification.DELETED_PACKAGES, PackageClassification.CHANGEDMETADATA_PACKAGES, PackageClassification.UNCHANGED_PACKAGES);
        this.basePdqModel = pDQBaseModel;
    }

    private DifferenceModel(PackageClassification ... packageClassificationArray) {
        for (PackageClassification packageClassification : packageClassificationArray) {
            this.pkgClassify.put(packageClassification, new ArrayList());
        }
    }

    private PackageContainer addToCategory(PackageModel packageModel, IClassification iClassification) {
        Collection<PackageContainer> collection = this.pkgClassify.get(iClassification);
        for (PackageContainer packageContainer : collection) {
            if (!packageContainer.getPackageModel().isEquivalent(packageModel)) continue;
            return packageContainer;
        }
        PackageContainer packageContainer = new PackageContainer(packageModel, (PackageClassification)iClassification);
        collection.add(packageContainer);
        return packageContainer;
    }

    public void classifyPackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        PackageModel packageModel = null;
        if (this.prevPkgModel == null || !this.prevPkgModel.isEquivalent(string, string2, string3)) {
            this.effectiveStmtSetModel = this.basePdqModel.getStatementSetModel(string, string2, string3);
            if (this.effectiveStmtSetModel != null) {
                packageModel = this.effectiveStmtSetModel.getPackageModel();
            }
            if (packageModel == null) {
                PackageModel packageModel2 = new PackageModel(string, string2, string3, string4, string7, string8);
                this.currPkgCntnr = this.addToCategory(packageModel2, PackageClassification.NEW_PACKAGES);
                packageModel = packageModel2;
            } else {
                if (packageModel.isRequireRebind(string, string2, string3, string4)) {
                    this.currPkgCntnr = this.addToCategory(packageModel, PackageClassification.REBIND_PACKAGES);
                } else if (packageModel.isChangedMetadata(string, string2, string3, string4, string7, string8)) {
                    this.currPkgCntnr = this.addToCategory(packageModel, PackageClassification.CHANGEDMETADATA_PACKAGES);
                } else if (packageModel.isUnchanged(string, string2, string3, string4, string7, string8)) {
                    this.currPkgCntnr = this.addToCategory(packageModel, PackageClassification.UNCHANGED_PACKAGES);
                } else {
                    String string11 = Messages.getText("MSG_DIFFERENCE_REPORT_UNABLE_TO_CLASSIFY_PKG", packageModel.getPkgNameRoot());
                    throw new RuntimeException(string11);
                }
                packageModel.updateNewValues(string, string3, string4, string7, string8);
                this.effectiveStmtSetModel.setIsInUpdatePdq(true);
            }
            this.prevPkgModel = packageModel;
        } else {
            packageModel = this.prevPkgModel;
        }
        this.currPkgCntnr.classifyStatement(this.effectiveStmtSetModel, string5, string6, string9, string10);
    }

    public void computeDeletedEntities() {
        this.computeDeletedPackages();
        this.computeDeletedSqls();
    }

    private void computeDeletedPackages() {
        Collection<PDQBaseModel.StatementSetModel> collection = this.basePdqModel.getPackageModels();
        for (PDQBaseModel.StatementSetModel statementSetModel : collection) {
            if (statementSetModel.isInUpdatePdq()) continue;
            PackageModel packageModel = statementSetModel.getPackageModel();
            PackageContainer packageContainer = this.addToCategory(packageModel, PackageClassification.DELETED_PACKAGES);
            Collection<StatementModel> collection2 = statementSetModel.getStatements();
            for (StatementModel statementModel : collection2) {
                StatementModel statementModel2 = new StatementModel(statementModel.getSql(), statementModel.getLastUpdated(), statementModel.getExecutionCount(), statementModel.getSectionNumber());
                packageContainer.addToCategory(StatementClassification.INCLUDED_SQL, statementModel2);
            }
        }
    }

    private void computeDeletedSqls() {
        ArrayList<PackageContainer> arrayList = new ArrayList<PackageContainer>();
        arrayList.addAll(this.pkgClassify.get(PackageClassification.REBIND_PACKAGES));
        arrayList.addAll(this.pkgClassify.get(PackageClassification.CHANGEDMETADATA_PACKAGES));
        for (PackageContainer packageContainer : arrayList) {
            PackageModel packageModel = packageContainer.getPackageModel();
            Collection<StatementModel> collection = this.basePdqModel.getStatementModels(packageModel);
            for (StatementModel statementModel : collection) {
                String string = statementModel.getSql();
                boolean bl2 = packageContainer.isSqlInGroup(StatementClassification.CHANGEDMETADATA_SQL, string) || packageContainer.isSqlInGroup(StatementClassification.UNCHANGEDMETADATA_SQL, string);
                if (bl2) continue;
                StatementModel statementModel2 = new StatementModel(string, statementModel.getLastUpdated(), statementModel.getExecutionCount(), statementModel.getSectionNumber());
                packageContainer.addToCategory(StatementClassification.DELETED_SQL, statementModel2);
            }
        }
    }

    public void printToHTML(Writer writer, String string, HashMap<String, String> hashMap, String ... stringArray) throws Exception {
        HTMLTemplateLoader hTMLTemplateLoader = new HTMLTemplateLoader();
        StringBuilder stringBuilder = this.printHtml(hTMLTemplateLoader);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("script", hTMLTemplateLoader.load("jscript", new Hashtable<String, String>()));
        hashtable.put("style", hTMLTemplateLoader.load("cssStyle", new Hashtable<String, String>()));
        hashtable.put("backtotop_id", "BackToTop");
        hashtable.put("save", Messages.getText("MSG_DIFFERENCE_REPORT_SAVE", new Object[0]));
        hashtable.put("title", string);
        hashtable.put("runtime_groups", stringBuilder.toString());
        hashtable.put("report_summary", this.printReportSummaryHtml(hTMLTemplateLoader, hashMap, stringArray).toString());
        try {
            writer.write(hTMLTemplateLoader.load("differencereport", hashtable));
        }
        catch (Exception exception) {
            String string2 = Messages.getText("MSG_DIFFERENCE_REPORT_ERR_HTML_GENERATION", new Object[0]);
            throw new PDQDiffReportException(string2, exception);
        }
    }

    private StringBuilder printReportSummaryHtml(HTMLTemplateLoader hTMLTemplateLoader, HashMap<String, String> hashMap, String ... stringArray) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(String.format("%s:<br />", string));
            stringBuilder2.append(String.format("%s<br />", hashMap.get(string)));
        }
        Hashtable hashtable = new Hashtable();
        hashtable.put("headers1", stringBuilder.toString());
        hashtable.put("values1", stringBuilder2.toString());
        hashtable.put("div_class", "");
        hashtable.put("table_class", "");
        hashtable.put("td_class1", "sub2DescrBold");
        hashtable.put("td_class2", "sub2Descr");
        StringBuilder stringBuilder3 = new StringBuilder();
        stringBuilder3.append(hTMLTemplateLoader.load("packageSummaryTableDesc", hashtable));
        return stringBuilder3;
    }

    private StringBuilder printHtml(HTMLTemplateLoader hTMLTemplateLoader) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)this.printPackagesSummaryTable(hTMLTemplateLoader));
        stringBuilder.append((CharSequence)this.printPackagesHtml(hTMLTemplateLoader));
        return stringBuilder;
    }

    private StringBuilder printPackagesSummaryTable(HTMLTemplateLoader hTMLTemplateLoader) throws Exception {
        StringBuilder stringBuilder = this.pkgsSummaryTblHeaderRowHtml(hTMLTemplateLoader);
        StringBuilder stringBuilder2 = this.pkgsSummaryTblDataRowsHtml(hTMLTemplateLoader);
        StringBuilder stringBuilder3 = this.printTableSubsection(hTMLTemplateLoader);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("title", Messages.getText("MSG_DIFFERENCE_REPORT_SUMMARY", new Object[0]));
        hashtable.put("id", "");
        hashtable.put("name", "");
        hashtable.put("backtotop_title", "");
        hashtable.put("backtotop_id", "");
        hashtable.put("table", Constants.getTableHtml(hTMLTemplateLoader, stringBuilder, stringBuilder2).toString());
        hashtable.put("sub_sec", stringBuilder3.toString());
        hashtable.put("sub_desc", "");
        StringBuilder stringBuilder4 = new StringBuilder();
        stringBuilder4.append(hTMLTemplateLoader.load("tableLayout", hashtable));
        stringBuilder4.append("<h4>" + Messages.getText("MSG_DIFFERENCE_REPORT_PKG_CHNG_DETAILS", new Object[0]) + "</h4>");
        return stringBuilder4;
    }

    private StringBuilder printTableSubsection(HTMLTemplateLoader hTMLTemplateLoader) throws IOException {
        Integer n2;
        Integer n3;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ArrayList<PackageContainer> arrayList = new ArrayList<PackageContainer>();
        arrayList.addAll(this.pkgClassify.get(PackageClassification.REBIND_PACKAGES));
        arrayList.addAll(this.pkgClassify.get(PackageClassification.NEW_PACKAGES));
        Integer n4 = 0;
        for (PackageContainer object2 : arrayList) {
            if (!object2.isBindNeeded().equalsIgnoreCase("yes")) continue;
            n3 = n4;
            n2 = n4 = Integer.valueOf(n4 + 1);
        }
        Integer n5 = this.pkgClassify.get(PackageClassification.NEW_PACKAGES).size();
        Integer n6 = this.pkgClassify.get(PackageClassification.DELETED_PACKAGES).size();
        n3 = this.pkgClassify.get(PackageClassification.CHANGEDMETADATA_PACKAGES).size() + this.pkgClassify.get(PackageClassification.REBIND_PACKAGES).size();
        n2 = this.pkgClassify.get(PackageClassification.UNCHANGED_PACKAGES).size();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder.append(String.format("%s:<br />", Messages.getText("MSG_DIFFERENCE_REPORT_REBIND_PKG_GROUP_2", new Object[0])));
        stringBuilder2.append(String.format("%s<br />", n4.toString()));
        stringBuilder.append(String.format("%s:<br />", Messages.getText("MSG_DIFFERENCE_REPORT_NEW_PKG_GROUP", new Object[0])));
        stringBuilder2.append(String.format("%s<br />", n5.toString()));
        stringBuilder.append(String.format("%s:<br />", Messages.getText("MSG_DIFFERENCE_REPORT_CHNGDMETADATA_PKG_GROUP", new Object[0])));
        stringBuilder2.append(String.format("%s<br />", n3.toString()));
        stringBuilder.append(String.format("%s:<br />", Messages.getText("MSG_DIFFERENCE_REPORT_DELETED_PKG_GROUP", new Object[0])));
        stringBuilder2.append(String.format("%s<br />", n6.toString()));
        stringBuilder.append(String.format("%s:<br />", Messages.getText("MSG_DIFFERENCE_REPORT_UNCHNGD_PKG_GROUP", new Object[0])));
        stringBuilder2.append(String.format("%s<br />", n2.toString()));
        hashtable.put("headers1", stringBuilder.toString());
        hashtable.put("values1", stringBuilder2.toString());
        hashtable.put("headers2", "");
        hashtable.put("values2", "");
        hashtable.put("div_class", "subSection");
        hashtable.put("table_class", "subSecTable");
        hashtable.put("td_class1", "sub1DescrBold");
        hashtable.put("td_class2", "sub1Descr");
        StringBuilder stringBuilder3 = new StringBuilder();
        stringBuilder3.append(hTMLTemplateLoader.load("packageTableSubsection", hashtable));
        return stringBuilder3;
    }

    private StringBuilder pkgsSummaryTblHeaderRowHtml(HTMLTemplateLoader hTMLTemplateLoader) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        hashtable.put("width", "15");
        hashtable.put("column_data", Messages.getText("MSG_DIFFERENCE_REPORT_COLLECTION", new Object[0]));
        stringBuilder.append(hTMLTemplateLoader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "15");
        hashtable.put("column_data", Messages.getText("MSG_DIFFERENCE_REPORT_PACKAGE", new Object[0]));
        stringBuilder.append(hTMLTemplateLoader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "5");
        hashtable.put("column_data", Messages.getText("MSG_DIFFERENCE_REPORT_VERSION", new Object[0]));
        stringBuilder.append(hTMLTemplateLoader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "17");
        hashtable.put("column_data", Messages.getText("MSG_DIFFERENCE_REPORT_STATUS", new Object[0]));
        stringBuilder.append(hTMLTemplateLoader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "10");
        hashtable.put("column_data", Messages.getText("MSG_DIFFERENCE_REPORT_BIND_REQUIRED", new Object[0]));
        stringBuilder.append(hTMLTemplateLoader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "10");
        hashtable.put("column_data", Messages.getText("MSG_DIFFERENCE_REPORT_SQL_ADDED", new Object[0]));
        stringBuilder.append(hTMLTemplateLoader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "10");
        hashtable.put("column_data", Messages.getText("MSG_DIFFERENCE_REPORT_SQL_CHANGED", new Object[0]));
        stringBuilder.append(hTMLTemplateLoader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "18");
        hashtable.put("column_data", Messages.getText("MSG_DIFFERENCE_REPORT_SQL_REMOVED", new Object[0]));
        stringBuilder.append(hTMLTemplateLoader.load("tableHeaderCell", hashtable));
        hashtable.put("width", "18");
        hashtable.put("column_data", Messages.getText("MSG_DIFFERENCE_REPORT_SQL_UNCHANGED", new Object[0]));
        stringBuilder.append(hTMLTemplateLoader.load("tableHeaderCell", hashtable));
        hashtable.clear();
        hashtable.put("table_row", stringBuilder.toString());
        StringBuilder stringBuilder2 = new StringBuilder().append(hTMLTemplateLoader.load("tableRow", hashtable));
        return stringBuilder2;
    }

    private StringBuilder pkgsSummaryTblDataRowsHtml(HTMLTemplateLoader hTMLTemplateLoader) throws IOException {
        ArrayList<PackageContainer> arrayList = new ArrayList<PackageContainer>();
        for (IClassification object2 : this.pkgClassify.keySet()) {
            arrayList.addAll(this.pkgClassify.get(object2));
        }
        Collections.sort((List)arrayList, new PackageContainerComparator());
        Hashtable hashtable = new Hashtable();
        StringBuilder stringBuilder = new StringBuilder();
        for (PackageContainer packageContainer : arrayList) {
            StringBuilder stringBuilder2 = new StringBuilder();
            PackageModel packageModel = packageContainer.getPackageModel();
            String string = packageModel.getPacakgeId();
            String string2 = Constants.getRefLinkHtml(string, packageModel.getPkgNameRoot());
            hashtable.put("column_data", packageContainer.getPackageModel().getCollectionId());
            stringBuilder2.append(hTMLTemplateLoader.load("tableDataCell", hashtable));
            hashtable.put("column_data", string2);
            stringBuilder2.append(hTMLTemplateLoader.load("tableDataCell", hashtable));
            hashtable.put("column_data", packageContainer.getPackageModel().getDbPkgVersion());
            stringBuilder2.append(hTMLTemplateLoader.load("tableDataCell", hashtable));
            String string3 = packageContainer.getPackageCategory().getChangeValue();
            if (Messages.getText("MSG_DIFFERENCE_REPORT_CHANGED", new Object[0]).equals(string3)) {
                string3 = Constants.getRefLinkHtml(packageModel.getPacakgeChangeSectionId(), string3);
            }
            hashtable.put("column_data", string3);
            stringBuilder2.append(hTMLTemplateLoader.load("tableDataCell", hashtable));
            String string4 = packageContainer.isBindNeeded();
            if (packageContainer.getBindExplain() != null) {
                string4 = Constants.getRefLinkHtml(packageModel.getPacakgeDescriptionSectionId(), string4);
            }
            hashtable.put("column_data", string4);
            stringBuilder2.append(hTMLTemplateLoader.load("tableDataCell", hashtable));
            hashtable.put("column_data", packageContainer.getSqlAddedCount());
            stringBuilder2.append(hTMLTemplateLoader.load("tableNumericDataCell", hashtable));
            hashtable.put("column_data", packageContainer.getSqlChangedCount());
            stringBuilder2.append(hTMLTemplateLoader.load("tableNumericDataCell", hashtable));
            hashtable.put("column_data", packageContainer.getSqlRemovedCount().toString());
            stringBuilder2.append(hTMLTemplateLoader.load("tableNumericDataCell", hashtable));
            hashtable.put("column_data", packageContainer.getSqlUnchangedCount());
            stringBuilder2.append(hTMLTemplateLoader.load("tableNumericDataCell", hashtable));
            hashtable.clear();
            hashtable.put("table_row", stringBuilder2.toString());
            stringBuilder.append(hTMLTemplateLoader.load("tableRow", hashtable));
            hashtable.clear();
        }
        return stringBuilder;
    }

    private StringBuilder printPackagesHtml(HTMLTemplateLoader hTMLTemplateLoader) throws Exception {
        ArrayList<PackageContainer> arrayList = new ArrayList<PackageContainer>();
        for (IClassification object : this.pkgClassify.keySet()) {
            arrayList.addAll(this.pkgClassify.get(object));
        }
        Collections.sort((List)arrayList, new PackageContainerComparator());
        StringBuilder stringBuilder = new StringBuilder();
        for (PackageContainer packageContainer : arrayList) {
            stringBuilder.append((CharSequence)packageContainer.printHtml(hTMLTemplateLoader));
        }
        return stringBuilder;
    }

    private class PackageContainerComparator
    implements Comparator<PackageContainer> {
        private PackageContainerComparator() {
        }

        @Override
        public int compare(PackageContainer packageContainer, PackageContainer packageContainer2) {
            int n2 = packageContainer.getPackageModel().getCollectionId().compareToIgnoreCase(packageContainer2.getPackageModel().getCollectionId());
            if (n2 == 0 && (n2 = packageContainer.getPackageModel().getPkgNameRoot().compareToIgnoreCase(packageContainer2.getPackageModel().getPkgNameRoot())) == 0) {
                n2 = packageContainer.getPackageModel().getDbPkgVersion().compareToIgnoreCase(packageContainer2.getPackageModel().getDbPkgVersion());
            }
            return n2;
        }
    }
}

