/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.xml;

import com.ibm.db2.cmx.runtime.internal.xml.XmlExporter;
import com.ibm.db2.cmx.runtime.internal.xml.XmlTags;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class XmlBuf {
    int indent_;
    boolean elementsAdded_ = false;
    boolean tagOpen_ = false;
    boolean textAdded_ = false;
    LinkedList<String> elements_ = new LinkedList();
    StringBuilder sb_ = new StringBuilder();

    public XmlBuf(int n2) {
        this.indent_ = n2;
    }

    public void addElement(String string, String string2) {
        if (string2 == null) {
            return;
        }
        if (this.tagOpen_) {
            this.sb_.append('>');
            this.tagOpen_ = false;
        }
        this.elementsAdded_ = true;
        int n2 = this.elements_.size() * 2;
        String string3 = XmlTags.space(n2 + this.indent_);
        if (string2.length() > 0) {
            this.sb_.append(XmlTags.CRLF).append(string3).append('<').append(string).append('>').append(XmlTags.escapeElement(string2)).append("</").append(string).append('>');
        } else {
            this.sb_.append(XmlTags.CRLF).append(string3).append('<').append(string).append("/>");
        }
    }

    public void addElement(String string, Map<String, String> map, String string2) {
        if (string2 == null) {
            return;
        }
        if (this.tagOpen_) {
            this.sb_.append('>');
            this.tagOpen_ = false;
        }
        this.elementsAdded_ = true;
        int n2 = this.elements_.size() * 2;
        String string3 = XmlTags.space(n2 + this.indent_);
        if (string2.length() > 0) {
            this.sb_.append(XmlTags.CRLF).append(string3).append('<').append(string).append(this.getAttribStr(map)).append('>').append(XmlTags.escapeElement(string2)).append("</").append(string).append('>');
        } else {
            this.sb_.append(XmlTags.CRLF).append(string3).append('<').append(string).append("/>");
        }
    }

    public void addElement(String string, Integer n2) {
        if (n2 != null) {
            this.addElement(string, String.valueOf(n2));
        }
    }

    public void addElement(String string, Long l8) {
        if (l8 != null) {
            this.addElement(string, String.valueOf(l8));
        }
    }

    public void startElement(String string) {
        if (this.tagOpen_) {
            this.sb_.append('>');
            this.tagOpen_ = false;
        }
        this.tagOpen_ = true;
        this.elementsAdded_ = true;
        int n2 = this.elements_.size() * 2;
        String string2 = XmlTags.space(n2 + this.indent_);
        this.sb_.append(XmlTags.CRLF).append(string2).append('<').append(string);
        this.elements_.addFirst(string);
    }

    public void addAttrib(String string, String string2) {
        if (this.elements_.size() == 0) {
            throw new IllegalStateException("Cannot add attribute without starting an element first.");
        }
        if (this.textAdded_) {
            throw new IllegalStateException("Cannot add attribute after adding text to an element.");
        }
        if (!this.tagOpen_) {
            throw new IllegalStateException("Element tag is already closed. cannot add attributes at this point.");
        }
        if (string2 == null) {
            return;
        }
        this.sb_.append(' ').append(string).append("=\"").append(XmlTags.escapeAttrib(string2)).append("\"");
    }

    public void addAttrib(String string, Integer n2) {
        if (n2 != null) {
            this.addAttrib(string, String.valueOf(n2));
        }
    }

    public void addText(String string) {
        if (this.elements_.size() == 0) {
            throw new IllegalStateException("Cannot add text without starting an element first.");
        }
        if (this.tagOpen_) {
            this.sb_.append('>');
            this.tagOpen_ = false;
        }
        this.textAdded_ = true;
        this.sb_.append(XmlTags.escapeElement(string));
    }

    public void addText(Integer n2) {
        if (n2 != null) {
            this.addText(String.valueOf(n2));
        }
    }

    public void endElement() {
        if (this.elements_.size() == 0) {
            throw new IllegalStateException("There is no element to end.");
        }
        String string = this.elements_.removeFirst();
        if (this.elementsAdded_ && !this.tagOpen_ || this.textAdded_) {
            int n2 = this.elements_.size() * 2;
            String string2 = XmlTags.space(n2 + this.indent_);
            this.sb_.append(XmlTags.CRLF).append(string2).append("</").append(string).append('>');
        } else {
            this.sb_.append("/>");
        }
        this.elementsAdded_ = this.elements_.size() > 0;
        this.tagOpen_ = false;
        this.textAdded_ = false;
    }

    public void endElementSameLine() {
        if (this.elements_.size() == 0) {
            throw new IllegalStateException("There is no element to end.");
        }
        String string = this.elements_.removeFirst();
        if (this.elementsAdded_ && !this.tagOpen_ || this.textAdded_) {
            this.sb_.append("</").append(string).append('>');
        } else {
            this.sb_.append("/>");
        }
        this.elementsAdded_ = this.elements_.size() > 0;
        this.tagOpen_ = false;
        this.textAdded_ = false;
    }

    public void addBranch(String string) {
        if (string == null) {
            return;
        }
        if (this.tagOpen_) {
            this.sb_.append('>');
            this.tagOpen_ = false;
        }
        this.elementsAdded_ = true;
        this.sb_.append(string);
    }

    public void addBranch(XmlExporter xmlExporter) {
        if (xmlExporter == null) {
            return;
        }
        int n2 = this.elements_.size() * 2;
        String string = xmlExporter.getXml(this.indent_ + n2);
        if (this.tagOpen_) {
            this.sb_.append('>');
            this.tagOpen_ = false;
        }
        this.elementsAdded_ = true;
        this.sb_.append(string);
    }

    public String toString() {
        if (this.elements_.size() > 0 || this.elementsAdded_) {
            throw new IllegalStateException("All started elements must be closed before gettig XML as a string. Open tags are: " + this.elements_.toString());
        }
        if (this.tagOpen_) {
            throw new IllegalStateException("A new tag has been started but not ended yet.");
        }
        return this.sb_.toString();
    }

    private String getAttribStr(Map<String, String> map) {
        if (map == null) {
            return "";
        }
        Iterator<String> iterator = map.keySet().iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            String string = iterator.next();
            String string2 = map.get(string);
            stringBuilder.append(' ').append(string).append("=\"").append(XmlTags.escapeAttrib(string2)).append("\"");
        }
        return stringBuilder.toString();
    }
}

