/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.colors;

import com.itextpdf.kernel.colors.DeviceRgb;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebColors
extends HashMap<String, int[]> {
    private static final long serialVersionUID = 3542523100813372896L;
    public static final WebColors NAMES = new WebColors();
    private static final double RGB_MAX_VAL = 255.0;

    public static DeviceRgb getRGBColor(String name) {
        float[] rgbaColor = WebColors.getRGBAColor(name);
        if (rgbaColor == null) {
            return new DeviceRgb(0, 0, 0);
        }
        return new DeviceRgb(rgbaColor[0], rgbaColor[1], rgbaColor[2]);
    }

    public static float[] getRGBAColor(String name) {
        float[] color = null;
        try {
            String colorName = name.toLowerCase();
            boolean colorStrWithoutHash = WebColors.missingHashColorFormat(colorName);
            if (colorName.startsWith("#") || colorStrWithoutHash) {
                if (!colorStrWithoutHash) {
                    colorName = colorName.substring(1);
                }
                if (colorName.length() == 3) {
                    String red = colorName.substring(0, 1);
                    color = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
                    color[0] = (float)((double)Integer.parseInt(red + red, 16) / 255.0);
                    String green = colorName.substring(1, 2);
                    color[1] = (float)((double)Integer.parseInt(green + green, 16) / 255.0);
                    String blue = colorName.substring(2);
                    color[2] = (float)((double)Integer.parseInt(blue + blue, 16) / 255.0);
                } else if (colorName.length() == 6) {
                    color = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
                    color[0] = (float)((double)Integer.parseInt(colorName.substring(0, 2), 16) / 255.0);
                    color[1] = (float)((double)Integer.parseInt(colorName.substring(2, 4), 16) / 255.0);
                    color[2] = (float)((double)Integer.parseInt(colorName.substring(4), 16) / 255.0);
                } else {
                    Logger logger = LoggerFactory.getLogger(WebColors.class);
                    logger.error("Unknown color format: must be rgb or rrggbb.");
                }
            } else if (colorName.startsWith("rgb(")) {
                String delim = "rgb(), \t\r\n\f";
                StringTokenizer tok = new StringTokenizer(colorName, "rgb(), \t\r\n\f");
                color = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
                WebColors.parseRGBColors(color, tok);
            } else if (colorName.startsWith("rgba(")) {
                String delim = "rgba(), \t\r\n\f";
                StringTokenizer tok = new StringTokenizer(colorName, "rgba(), \t\r\n\f");
                color = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
                WebColors.parseRGBColors(color, tok);
                if (tok.hasMoreTokens()) {
                    color[3] = WebColors.getAlphaChannelValue(tok.nextToken());
                }
            } else if (NAMES.containsKey(colorName)) {
                int[] intColor = (int[])NAMES.get(colorName);
                color = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
                color[0] = (float)((double)intColor[0] / 255.0);
                color[1] = (float)((double)intColor[1] / 255.0);
                color[2] = (float)((double)intColor[2] / 255.0);
            }
        }
        catch (Exception exc) {
            color = null;
        }
        return color;
    }

    private static void parseRGBColors(float[] color, StringTokenizer tok) {
        for (int k = 0; k < 3; ++k) {
            if (!tok.hasMoreTokens()) continue;
            color[k] = WebColors.getRGBChannelValue(tok.nextToken());
            color[k] = Math.max(0.0f, color[k]);
            color[k] = Math.min(1.0f, color[k]);
        }
    }

    private static boolean missingHashColorFormat(String colStr) {
        int len = colStr.length();
        if (len == 3 || len == 6) {
            String match = "[0-9a-f]{" + len + "}";
            return colStr.matches(match);
        }
        return false;
    }

    private static float getRGBChannelValue(String rgbChannel) {
        if (rgbChannel.endsWith("%")) {
            return WebColors.parsePercentValue(rgbChannel);
        }
        return (float)((double)Integer.parseInt(rgbChannel) / 255.0);
    }

    private static float getAlphaChannelValue(String rgbChannel) {
        float alpha = rgbChannel.endsWith("%") ? WebColors.parsePercentValue(rgbChannel) : Float.parseFloat(rgbChannel);
        alpha = Math.max(0.0f, alpha);
        alpha = Math.min(1.0f, alpha);
        return alpha;
    }

    private static float parsePercentValue(String rgbChannel) {
        return (float)((double)Float.parseFloat(rgbChannel.substring(0, rgbChannel.length() - 1)) / 100.0);
    }

    static {
        NAMES.put("aliceblue", new int[]{240, 248, 255, 255});
        NAMES.put("antiquewhite", new int[]{250, 235, 215, 255});
        NAMES.put("aqua", new int[]{0, 255, 255, 255});
        NAMES.put("aquamarine", new int[]{127, 255, 212, 255});
        NAMES.put("azure", new int[]{240, 255, 255, 255});
        NAMES.put("beige", new int[]{245, 245, 220, 255});
        NAMES.put("bisque", new int[]{255, 228, 196, 255});
        NAMES.put("black", new int[]{0, 0, 0, 255});
        NAMES.put("blanchedalmond", new int[]{255, 235, 205, 255});
        NAMES.put("blue", new int[]{0, 0, 255, 255});
        NAMES.put("blueviolet", new int[]{138, 43, 226, 255});
        NAMES.put("brown", new int[]{165, 42, 42, 255});
        NAMES.put("burlywood", new int[]{222, 184, 135, 255});
        NAMES.put("cadetblue", new int[]{95, 158, 160, 255});
        NAMES.put("chartreuse", new int[]{127, 255, 0, 255});
        NAMES.put("chocolate", new int[]{210, 105, 30, 255});
        NAMES.put("coral", new int[]{255, 127, 80, 255});
        NAMES.put("cornflowerblue", new int[]{100, 149, 237, 255});
        NAMES.put("cornsilk", new int[]{255, 248, 220, 255});
        NAMES.put("crimson", new int[]{220, 20, 60, 255});
        NAMES.put("cyan", new int[]{0, 255, 255, 255});
        NAMES.put("darkblue", new int[]{0, 0, 139, 255});
        NAMES.put("darkcyan", new int[]{0, 139, 139, 255});
        NAMES.put("darkgoldenrod", new int[]{184, 134, 11, 255});
        NAMES.put("darkgray", new int[]{169, 169, 169, 255});
        NAMES.put("darkgrey", new int[]{169, 169, 169, 255});
        NAMES.put("darkgreen", new int[]{0, 100, 0, 255});
        NAMES.put("darkkhaki", new int[]{189, 183, 107, 255});
        NAMES.put("darkmagenta", new int[]{139, 0, 139, 255});
        NAMES.put("darkolivegreen", new int[]{85, 107, 47, 255});
        NAMES.put("darkorange", new int[]{255, 140, 0, 255});
        NAMES.put("darkorchid", new int[]{153, 50, 204, 255});
        NAMES.put("darkred", new int[]{139, 0, 0, 255});
        NAMES.put("darksalmon", new int[]{233, 150, 122, 255});
        NAMES.put("darkseagreen", new int[]{143, 188, 143, 255});
        NAMES.put("darkslateblue", new int[]{72, 61, 139, 255});
        NAMES.put("darkslategray", new int[]{47, 79, 79, 255});
        NAMES.put("darkslategrey", new int[]{47, 79, 79, 255});
        NAMES.put("darkturquoise", new int[]{0, 206, 209, 255});
        NAMES.put("darkviolet", new int[]{148, 0, 211, 255});
        NAMES.put("deeppink", new int[]{255, 20, 147, 255});
        NAMES.put("deepskyblue", new int[]{0, 191, 255, 255});
        NAMES.put("dimgray", new int[]{105, 105, 105, 255});
        NAMES.put("dimgrey", new int[]{105, 105, 105, 255});
        NAMES.put("dodgerblue", new int[]{30, 144, 255, 255});
        NAMES.put("firebrick", new int[]{178, 34, 34, 255});
        NAMES.put("floralwhite", new int[]{255, 250, 240, 255});
        NAMES.put("forestgreen", new int[]{34, 139, 34, 255});
        NAMES.put("fuchsia", new int[]{255, 0, 255, 255});
        NAMES.put("gainsboro", new int[]{220, 220, 220, 255});
        NAMES.put("ghostwhite", new int[]{248, 248, 255, 255});
        NAMES.put("gold", new int[]{255, 215, 0, 255});
        NAMES.put("goldenrod", new int[]{218, 165, 32, 255});
        NAMES.put("gray", new int[]{128, 128, 128, 255});
        NAMES.put("grey", new int[]{128, 128, 128, 255});
        NAMES.put("green", new int[]{0, 128, 0, 255});
        NAMES.put("greenyellow", new int[]{173, 255, 47, 255});
        NAMES.put("honeydew", new int[]{240, 255, 240, 255});
        NAMES.put("hotpink", new int[]{255, 105, 180, 255});
        NAMES.put("indianred", new int[]{205, 92, 92, 255});
        NAMES.put("indigo", new int[]{75, 0, 130, 255});
        NAMES.put("ivory", new int[]{255, 255, 240, 255});
        NAMES.put("khaki", new int[]{240, 230, 140, 255});
        NAMES.put("lavender", new int[]{230, 230, 250, 255});
        NAMES.put("lavenderblush", new int[]{255, 240, 245, 255});
        NAMES.put("lawngreen", new int[]{124, 252, 0, 255});
        NAMES.put("lemonchiffon", new int[]{255, 250, 205, 255});
        NAMES.put("lightblue", new int[]{173, 216, 230, 255});
        NAMES.put("lightcoral", new int[]{240, 128, 128, 255});
        NAMES.put("lightcyan", new int[]{224, 255, 255, 255});
        NAMES.put("lightgoldenrodyellow", new int[]{250, 250, 210, 255});
        NAMES.put("lightgreen", new int[]{144, 238, 144, 255});
        NAMES.put("lightgray", new int[]{211, 211, 211, 255});
        NAMES.put("lightgrey", new int[]{211, 211, 211, 255});
        NAMES.put("lightpink", new int[]{255, 182, 193, 255});
        NAMES.put("lightsalmon", new int[]{255, 160, 122, 255});
        NAMES.put("lightseagreen", new int[]{32, 178, 170, 255});
        NAMES.put("lightskyblue", new int[]{135, 206, 250, 255});
        NAMES.put("lightslategray", new int[]{119, 136, 153, 255});
        NAMES.put("lightslategrey", new int[]{119, 136, 153, 255});
        NAMES.put("lightsteelblue", new int[]{176, 196, 222, 255});
        NAMES.put("lightyellow", new int[]{255, 255, 224, 255});
        NAMES.put("lime", new int[]{0, 255, 0, 255});
        NAMES.put("limegreen", new int[]{50, 205, 50, 255});
        NAMES.put("linen", new int[]{250, 240, 230, 255});
        NAMES.put("magenta", new int[]{255, 0, 255, 255});
        NAMES.put("maroon", new int[]{128, 0, 0, 255});
        NAMES.put("mediumaquamarine", new int[]{102, 205, 170, 255});
        NAMES.put("mediumblue", new int[]{0, 0, 205, 255});
        NAMES.put("mediumorchid", new int[]{186, 85, 211, 255});
        NAMES.put("mediumpurple", new int[]{147, 112, 219, 255});
        NAMES.put("mediumseagreen", new int[]{60, 179, 113, 255});
        NAMES.put("mediumslateblue", new int[]{123, 104, 238, 255});
        NAMES.put("mediumspringgreen", new int[]{0, 250, 154, 255});
        NAMES.put("mediumturquoise", new int[]{72, 209, 204, 255});
        NAMES.put("mediumvioletred", new int[]{199, 21, 133, 255});
        NAMES.put("midnightblue", new int[]{25, 25, 112, 255});
        NAMES.put("mintcream", new int[]{245, 255, 250, 255});
        NAMES.put("mistyrose", new int[]{255, 228, 225, 255});
        NAMES.put("moccasin", new int[]{255, 228, 181, 255});
        NAMES.put("navajowhite", new int[]{255, 222, 173, 255});
        NAMES.put("navy", new int[]{0, 0, 128, 255});
        NAMES.put("oldlace", new int[]{253, 245, 230, 255});
        NAMES.put("olive", new int[]{128, 128, 0, 255});
        NAMES.put("olivedrab", new int[]{107, 142, 35, 255});
        NAMES.put("orange", new int[]{255, 165, 0, 255});
        NAMES.put("orangered", new int[]{255, 69, 0, 255});
        NAMES.put("orchid", new int[]{218, 112, 214, 255});
        NAMES.put("palegoldenrod", new int[]{238, 232, 170, 255});
        NAMES.put("palegreen", new int[]{152, 251, 152, 255});
        NAMES.put("paleturquoise", new int[]{175, 238, 238, 255});
        NAMES.put("palevioletred", new int[]{219, 112, 147, 255});
        NAMES.put("papayawhip", new int[]{255, 239, 213, 255});
        NAMES.put("peachpuff", new int[]{255, 218, 185, 255});
        NAMES.put("peru", new int[]{205, 133, 63, 255});
        NAMES.put("pink", new int[]{255, 192, 203, 255});
        NAMES.put("plum", new int[]{221, 160, 221, 255});
        NAMES.put("powderblue", new int[]{176, 224, 230, 255});
        NAMES.put("purple", new int[]{128, 0, 128, 255});
        NAMES.put("red", new int[]{255, 0, 0, 255});
        NAMES.put("rosybrown", new int[]{188, 143, 143, 255});
        NAMES.put("royalblue", new int[]{65, 105, 225, 255});
        NAMES.put("saddlebrown", new int[]{139, 69, 19, 255});
        NAMES.put("salmon", new int[]{250, 128, 114, 255});
        NAMES.put("sandybrown", new int[]{244, 164, 96, 255});
        NAMES.put("seagreen", new int[]{46, 139, 87, 255});
        NAMES.put("seashell", new int[]{255, 245, 238, 255});
        NAMES.put("sienna", new int[]{160, 82, 45, 255});
        NAMES.put("silver", new int[]{192, 192, 192, 255});
        NAMES.put("skyblue", new int[]{135, 206, 235, 255});
        NAMES.put("slateblue", new int[]{106, 90, 205, 255});
        NAMES.put("slategray", new int[]{112, 128, 144, 255});
        NAMES.put("slategrey", new int[]{112, 128, 144, 255});
        NAMES.put("snow", new int[]{255, 250, 250, 255});
        NAMES.put("springgreen", new int[]{0, 255, 127, 255});
        NAMES.put("steelblue", new int[]{70, 130, 180, 255});
        NAMES.put("tan", new int[]{210, 180, 140, 255});
        NAMES.put("teal", new int[]{0, 128, 128, 255});
        NAMES.put("thistle", new int[]{216, 191, 216, 255});
        NAMES.put("tomato", new int[]{255, 99, 71, 255});
        NAMES.put("transparent", new int[]{255, 255, 255, 0});
        NAMES.put("turquoise", new int[]{64, 224, 208, 255});
        NAMES.put("violet", new int[]{238, 130, 238, 255});
        NAMES.put("wheat", new int[]{245, 222, 179, 255});
        NAMES.put("white", new int[]{255, 255, 255, 255});
        NAMES.put("whitesmoke", new int[]{245, 245, 245, 255});
        NAMES.put("yellow", new int[]{255, 255, 0, 255});
        NAMES.put("yellowgreen", new int[]{154, 205, 50, 255});
    }
}

