/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas.wmf;

import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageType;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.canvas.wmf.InputMeta;
import com.itextpdf.kernel.pdf.canvas.wmf.MetaDo;
import com.itextpdf.kernel.pdf.canvas.wmf.WmfImageData;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class WmfImageHelper {
    public static float wmfFontCorrection = 0.86f;
    private WmfImageData wmf;
    private float plainWidth;
    private float plainHeight;

    public WmfImageHelper(ImageData wmf) {
        if (wmf.getOriginalType() != ImageType.WMF) {
            throw new IllegalArgumentException("WMF image expected");
        }
        this.wmf = (WmfImageData)wmf;
        this.processParameters();
    }

    private void processParameters() {
        InputStream is = null;
        try {
            String errorID;
            if (this.wmf.getData() == null) {
                is = this.wmf.getUrl().openStream();
                errorID = this.wmf.getUrl().toString();
            } else {
                is = new ByteArrayInputStream(this.wmf.getData());
                errorID = "Byte array";
            }
            InputMeta in = new InputMeta(is);
            if (in.readInt() != -1698247209) {
                throw new PdfException("{0} is not a valid placeable windows metafile.", errorID);
            }
            in.readWord();
            int left = in.readShort();
            int top = in.readShort();
            int right = in.readShort();
            int bottom = in.readShort();
            int inch = in.readWord();
            this.wmf.setDpi(72, 72);
            this.wmf.setHeight((float)(bottom - top) / (float)inch * 72.0f);
            this.wmf.setWidth((float)(right - left) / (float)inch * 72.0f);
        }
        catch (IOException e) {
            throw new PdfException("WMF image exception.");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public PdfXObject createFormXObject(PdfDocument document) {
        PdfFormXObject pdfForm = new PdfFormXObject(new Rectangle(0.0f, 0.0f, this.wmf.getWidth(), this.wmf.getHeight()));
        PdfCanvas canvas = new PdfCanvas(pdfForm, document);
        InputStream is = null;
        try {
            is = this.wmf.getData() == null ? this.wmf.getUrl().openStream() : new ByteArrayInputStream(this.wmf.getData());
            MetaDo meta = new MetaDo(is, canvas);
            meta.readAll();
        }
        catch (IOException e) {
            throw new PdfException("WMF image exception.", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return pdfForm;
    }
}

