/*
 * Decompiled with CFR 0.152.
 */
package com.maojianwei.maocloud.monitor.raspberry.gui;

import java.util.HashMap;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;

public class MainPageGuiController {
    private Map<String, Stage> stageMap = new HashMap<String, Stage>();
    private boolean isFullScreen = true;
    @FXML
    private TableView nodeTable;

    public void addStage(String title, Stage stage) {
        this.stageMap.put(title, stage);
    }

    public void delStage(String title) {
        this.stageMap.remove(title);
    }

    public void delStage(Stage stage) {
        this.stageMap.remove(stage.getTitle());
    }

    @FXML
    public void changeMainPageFullScreen() {
        if (this.isFullScreen) {
            this.isFullScreen = false;
            this.stageMap.get("main").setFullScreen(false);
        } else {
            this.isFullScreen = true;
            this.stageMap.get("main").setFullScreen(true);
        }
    }

    public void setTableViewDataBinding(ObservableList data) {
        ObservableList columns = this.nodeTable.getColumns();
        for (TableColumn c : columns) {
            switch (c.getText()) {
                case "Name": {
                    c.setCellValueFactory((Callback)new PropertyValueFactory("name"));
                    break;
                }
                case "IP": {
                    c.setCellValueFactory((Callback)new PropertyValueFactory("ip"));
                    break;
                }
                case "SysTime": {
                    c.setCellValueFactory((Callback)new PropertyValueFactory("sysTime"));
                    break;
                }
                case "CpuT": {
                    c.setCellValueFactory((Callback)new PropertyValueFactory("cpuTemp"));
                    break;
                }
                case "GpuT": {
                    c.setCellValueFactory((Callback)new PropertyValueFactory("gpuTemp"));
                }
            }
        }
        this.nodeTable.setItems(data);
    }

    public void cancalTableViewDataBinding() {
        this.nodeTable.setItems(null);
    }
}

