/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.proton.transport.proxy.impl;

import com.microsoft.azure.proton.transport.proxy.Proxy;
import com.microsoft.azure.proton.transport.proxy.ProxyAuthenticationType;
import com.microsoft.azure.proton.transport.proxy.ProxyChallengeProcessor;
import com.microsoft.azure.proton.transport.proxy.ProxyConfiguration;
import com.microsoft.azure.proton.transport.proxy.ProxyHandler;
import com.microsoft.azure.proton.transport.proxy.ProxyResponse;
import com.microsoft.azure.proton.transport.proxy.impl.BasicProxyChallengeProcessorImpl;
import com.microsoft.azure.proton.transport.proxy.impl.Constants;
import com.microsoft.azure.proton.transport.proxy.impl.DigestProxyChallengeProcessorImpl;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyAuthenticator;
import com.microsoft.azure.proton.transport.proxy.impl.ProxyResponseImpl;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.ByteBufferUtils;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.engine.impl.TransportInput;
import org.apache.qpid.proton.engine.impl.TransportLayer;
import org.apache.qpid.proton.engine.impl.TransportOutput;
import org.apache.qpid.proton.engine.impl.TransportWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyImpl
implements Proxy,
TransportLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyImpl.class);
    private final ByteBuffer inputBuffer;
    private final ByteBuffer outputBuffer;
    private final ProxyConfiguration proxyConfiguration;
    private boolean tailClosed = false;
    private boolean headClosed = false;
    private String host = "";
    private volatile Map<String, String> headers = null;
    private TransportImpl underlyingTransport;
    private ProxyHandler proxyHandler;
    private volatile boolean isProxyConfigured = false;
    private volatile Proxy.ProxyState proxyState;
    private volatile boolean respondToChallengeOnNewConnection = false;
    private final AtomicReference<State> fromState = new AtomicReference<Object>(null);

    public ProxyImpl() {
        this(null);
    }

    public ProxyImpl(ProxyConfiguration configuration) {
        this.inputBuffer = ByteBufferUtils.newWriteableBuffer((int)4096);
        this.outputBuffer = ByteBufferUtils.newWriteableBuffer((int)4096);
        this.proxyConfiguration = configuration;
    }

    public TransportWrapper wrap(TransportInput input, TransportOutput output) {
        return new ProxyTransportWrapper(input, output);
    }

    @Override
    public void configure(String host, Map<String, String> headers, ProxyHandler proxyHandler, Transport underlyingTransport) {
        this.host = host;
        State source = this.fromState.get();
        if (source != null) {
            this.headers = source.headers;
            this.proxyState = source.proxyState;
        } else {
            this.headers = headers;
            this.proxyState = Proxy.ProxyState.PN_PROXY_NOT_STARTED;
        }
        this.proxyHandler = proxyHandler;
        this.underlyingTransport = (TransportImpl)underlyingTransport;
        this.isProxyConfigured = true;
    }

    public Map<String, String> getProxyRequestHeaders() {
        return this.headers;
    }

    public void transferState(ProxyImpl fromProxy) {
        if (fromProxy.respondToChallengeOnNewConnection) {
            LOGGER.debug("Transferring state from proxy {} {} {}", new Object[]{this.hashCode(), System.lineSeparator(), fromProxy.headers});
            this.fromState.set(State.from(fromProxy));
        }
    }

    protected ByteBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    protected ByteBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    protected boolean getIsProxyConfigured() {
        return this.isProxyConfigured;
    }

    protected ProxyHandler getProxyHandler() {
        return this.proxyHandler;
    }

    protected Transport getUnderlyingTransport() {
        return this.underlyingTransport;
    }

    protected void writeProxyRequest() {
        this.outputBuffer.clear();
        String request = this.proxyHandler.createProxyRequest(this.host, this.headers);
        LOGGER.info("Writing proxy request:{} {}{}{}", new Object[]{this.hashCode(), "State: " + (Object)((Object)this.proxyState), System.lineSeparator(), request});
        this.outputBuffer.put(request.getBytes());
    }

    protected boolean getIsHandshakeInProgress() {
        return this.isProxyConfigured && this.proxyState != Proxy.ProxyState.PN_PROXY_CONNECTED;
    }

    protected Proxy.ProxyState getProxyState() {
        return this.proxyState;
    }

    private static final class State {
        final Map<String, String> headers;
        final Proxy.ProxyState proxyState;

        static State from(ProxyImpl fromProxy) {
            return new State(new HashMap<String, String>(fromProxy.headers), fromProxy.proxyState);
        }

        private State(Map<String, String> headers, Proxy.ProxyState proxyState) {
            this.headers = headers;
            this.proxyState = proxyState;
        }
    }

    private class ProxyTransportWrapper
    implements TransportWrapper {
        private final TransportInput underlyingInput;
        private final TransportOutput underlyingOutput;
        private final ByteBuffer head;
        private final AtomicReference<ProxyResponse> proxyResponse = new AtomicReference();

        ProxyTransportWrapper(TransportInput input, TransportOutput output) {
            this.underlyingInput = input;
            this.underlyingOutput = output;
            this.head = ProxyImpl.this.outputBuffer.asReadOnlyBuffer();
            this.head.limit(0);
        }

        public int capacity() {
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                if (ProxyImpl.this.tailClosed) {
                    return -1;
                }
                return ProxyImpl.this.inputBuffer.remaining();
            }
            return this.underlyingInput.capacity();
        }

        public int position() {
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                if (ProxyImpl.this.tailClosed) {
                    return -1;
                }
                return ProxyImpl.this.inputBuffer.position();
            }
            return this.underlyingInput.position();
        }

        public ByteBuffer tail() throws TransportException {
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                return ProxyImpl.this.inputBuffer;
            }
            return this.underlyingInput.tail();
        }

        public void process() throws TransportException {
            if (!ProxyImpl.this.getIsHandshakeInProgress()) {
                this.underlyingInput.process();
                return;
            }
            switch (ProxyImpl.this.proxyState) {
                case PN_PROXY_CONNECTING: {
                    ProxyChallengeProcessor processor;
                    ProxyImpl.this.inputBuffer.flip();
                    ProxyResponse connectResponse = this.readProxyResponse(ProxyImpl.this.inputBuffer);
                    if (connectResponse == null || connectResponse.isMissingContent()) {
                        LOGGER.info("Request is missing content. Waiting for more bytes.");
                        break;
                    }
                    this.proxyResponse.set(null);
                    boolean isSuccess = ProxyImpl.this.proxyHandler.validateProxyResponse(connectResponse);
                    if (isSuccess) {
                        if (ProxyImpl.this.proxyConfiguration == null || ProxyImpl.this.proxyConfiguration.authentication() == ProxyAuthenticationType.NONE) {
                            ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_CONNECTED;
                            break;
                        }
                        if (LOGGER.isErrorEnabled()) {
                            LOGGER.error("ProxyConfiguration mismatch. User configured: '{}', but authentication is not required", (Object)ProxyImpl.this.proxyConfiguration.authentication());
                        }
                        this.closeTailProxyError("User configuration error. Using non-matching proxy authentication.");
                        break;
                    }
                    Map<String, List<String>> headers = connectResponse.getHeaders();
                    Set<ProxyAuthenticationType> supportedTypes = this.getAuthenticationTypes(headers);
                    if (ProxyImpl.this.proxyConfiguration != null && !supportedTypes.contains((Object)ProxyImpl.this.proxyConfiguration.authentication())) {
                        if (LOGGER.isErrorEnabled()) {
                            LOGGER.error("Proxy authentication required. User configured: '{}', but supported proxy authentication methods are: {}", (Object)ProxyImpl.this.proxyConfiguration.authentication(), (Object)supportedTypes.stream().map(type -> type.toString()).collect(Collectors.joining(",")));
                        }
                        this.closeTailProxyError("User configuration error. Using non-matching proxy authentication.Proxy connect request failed with error: " + connectResponse);
                        break;
                    }
                    List challenges = headers.getOrDefault("Proxy-Authenticate", new ArrayList());
                    ProxyChallengeProcessor proxyChallengeProcessor = processor = ProxyImpl.this.proxyConfiguration != null ? this.getChallengeProcessor(ProxyImpl.this.host, (List<String>)challenges, ProxyImpl.this.proxyConfiguration.authentication()) : this.getChallengeProcessor(ProxyImpl.this.host, (List<String>)challenges, supportedTypes);
                    if (processor != null) {
                        ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_CHALLENGE;
                        ProxyImpl.this.headers = processor.getHeader();
                        if (!connectResponse.hasConnectionCloseHeader()) break;
                        ProxyImpl.this.respondToChallengeOnNewConnection = true;
                        LOGGER.info("Proxy server closed the connection, attempting challenge response on new connection.");
                        this.closeTailProxyError("Proxy server closed the connection.");
                        break;
                    }
                    LOGGER.warn("Could not get ProxyChallengeProcessor for challenges.");
                    this.closeTailProxyError("Proxy connect request failed with error: " + String.join((CharSequence)";", challenges));
                    break;
                }
                case PN_PROXY_CHALLENGE_RESPONDED: {
                    ProxyImpl.this.inputBuffer.flip();
                    ProxyResponse challengeResponse = this.readProxyResponse(ProxyImpl.this.inputBuffer);
                    if (challengeResponse == null || challengeResponse.isMissingContent()) {
                        LOGGER.warn("Request is missing content. Waiting for more bytes.");
                        break;
                    }
                    this.proxyResponse.set(null);
                    boolean result = ProxyImpl.this.proxyHandler.validateProxyResponse(challengeResponse);
                    if (result) {
                        ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_CONNECTED;
                        break;
                    }
                    this.closeTailProxyError("Proxy connect request failed with error: " + challengeResponse);
                    break;
                }
                default: {
                    this.underlyingInput.process();
                }
            }
        }

        public void close_tail() {
            ProxyImpl.this.tailClosed = true;
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                ProxyImpl.this.headClosed = true;
            }
            this.underlyingInput.close_tail();
        }

        public int pending() {
            if (!ProxyImpl.this.getIsHandshakeInProgress()) {
                return this.underlyingOutput.pending();
            }
            switch (ProxyImpl.this.proxyState) {
                case PN_PROXY_NOT_STARTED: {
                    if (ProxyImpl.this.outputBuffer.position() == 0) {
                        ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_CONNECTING;
                        ProxyImpl.this.writeProxyRequest();
                        this.head.limit(ProxyImpl.this.outputBuffer.position());
                        if (ProxyImpl.this.headClosed) {
                            ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_FAILED;
                            return -1;
                        }
                        return ProxyImpl.this.outputBuffer.position();
                    }
                    return ProxyImpl.this.outputBuffer.position();
                }
                case PN_PROXY_CHALLENGE: {
                    if (ProxyImpl.this.respondToChallengeOnNewConnection) {
                        return -1;
                    }
                    if (ProxyImpl.this.outputBuffer.position() == 0) {
                        ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_CHALLENGE_RESPONDED;
                        ProxyImpl.this.writeProxyRequest();
                        this.head.limit(ProxyImpl.this.outputBuffer.position());
                        if (ProxyImpl.this.headClosed) {
                            ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_FAILED;
                            return -1;
                        }
                        return ProxyImpl.this.outputBuffer.position();
                    }
                    return ProxyImpl.this.outputBuffer.position();
                }
                case PN_PROXY_CONNECTING: 
                case PN_PROXY_CHALLENGE_RESPONDED: {
                    if (ProxyImpl.this.respondToChallengeOnNewConnection) {
                        return -1;
                    }
                    if (ProxyImpl.this.headClosed && ProxyImpl.this.outputBuffer.position() == 0) {
                        ProxyImpl.this.proxyState = Proxy.ProxyState.PN_PROXY_FAILED;
                        return -1;
                    }
                    return ProxyImpl.this.outputBuffer.position();
                }
            }
            return -1;
        }

        public ByteBuffer head() {
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                switch (ProxyImpl.this.proxyState) {
                    case PN_PROXY_CONNECTING: 
                    case PN_PROXY_CHALLENGE_RESPONDED: {
                        return this.head;
                    }
                }
                return this.underlyingOutput.head();
            }
            return this.underlyingOutput.head();
        }

        public void pop(int bytes) {
            if (ProxyImpl.this.getIsHandshakeInProgress()) {
                switch (ProxyImpl.this.proxyState) {
                    case PN_PROXY_CONNECTING: 
                    case PN_PROXY_CHALLENGE_RESPONDED: {
                        if (ProxyImpl.this.outputBuffer.position() != 0) {
                            ProxyImpl.this.outputBuffer.flip();
                            ProxyImpl.this.outputBuffer.position(bytes);
                            ProxyImpl.this.outputBuffer.compact();
                            this.head.position(0);
                            this.head.limit(ProxyImpl.this.outputBuffer.position());
                            break;
                        }
                        this.underlyingOutput.pop(bytes);
                        break;
                    }
                    default: {
                        this.underlyingOutput.pop(bytes);
                        break;
                    }
                }
            } else {
                this.underlyingOutput.pop(bytes);
            }
        }

        public void close_head() {
            ProxyImpl.this.headClosed = true;
            this.underlyingOutput.close_head();
        }

        private ProxyChallengeProcessor getChallengeProcessor(String host, List<String> challenges, Set<ProxyAuthenticationType> authentication) {
            ProxyAuthenticationType authType;
            if (authentication.contains((Object)ProxyAuthenticationType.DIGEST)) {
                authType = ProxyAuthenticationType.DIGEST;
            } else if (authentication.contains((Object)ProxyAuthenticationType.BASIC)) {
                authType = ProxyAuthenticationType.BASIC;
            } else {
                return null;
            }
            return this.getChallengeProcessor(host, challenges, authType);
        }

        private ProxyChallengeProcessor getChallengeProcessor(String host, List<String> challenges, ProxyAuthenticationType authentication) {
            ProxyAuthenticator authenticator = ProxyImpl.this.proxyConfiguration != null ? new ProxyAuthenticator(ProxyImpl.this.proxyConfiguration) : new ProxyAuthenticator();
            switch (authentication) {
                case DIGEST: {
                    Optional<String> matching = challenges.stream().filter(challenge -> challenge.toLowerCase(Locale.ROOT).startsWith(Constants.DIGEST_LOWERCASE)).findFirst();
                    return matching.map(c -> new DigestProxyChallengeProcessorImpl(host, (String)c, authenticator)).orElse(null);
                }
                case BASIC: {
                    return new BasicProxyChallengeProcessorImpl(host, authenticator);
                }
            }
            LOGGER.warn("Authentication type does not have a challenge processor: {}", (Object)authentication);
            return null;
        }

        private Set<ProxyAuthenticationType> getAuthenticationTypes(Map<String, List<String>> headers) {
            if (!headers.containsKey("Proxy-Authenticate")) {
                return Collections.emptySet();
            }
            HashSet<ProxyAuthenticationType> supportedTypes = new HashSet<ProxyAuthenticationType>();
            List<String> authenticationTypes = headers.get("Proxy-Authenticate");
            for (String type : authenticationTypes) {
                String lowercase = type.toLowerCase(Locale.ROOT);
                if (lowercase.startsWith(Constants.BASIC_LOWERCASE)) {
                    supportedTypes.add(ProxyAuthenticationType.BASIC);
                    continue;
                }
                if (lowercase.startsWith(Constants.DIGEST_LOWERCASE)) {
                    supportedTypes.add(ProxyAuthenticationType.DIGEST);
                    continue;
                }
                LOGGER.warn("Did not understand this authentication type: {}", (Object)type);
            }
            return supportedTypes;
        }

        private void closeTailProxyError(String errorMessage) {
            ProxyImpl.this.tailClosed = true;
            ProxyImpl.this.underlyingTransport.closed(new TransportException(errorMessage));
        }

        private ProxyResponse readProxyResponse(ByteBuffer buffer) {
            int size = buffer.remaining();
            if (size <= 0) {
                LOGGER.warn("InputBuffer is empty. Not reading any contents from it. Returning current response.");
                return this.proxyResponse.get();
            }
            ProxyResponse current = this.proxyResponse.get();
            if (current == null) {
                this.proxyResponse.set(ProxyResponseImpl.create(buffer));
            } else {
                current.addContent(buffer);
            }
            buffer.compact();
            return this.proxyResponse.get();
        }
    }
}

