/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.ResultReason;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;

public class SpeechSynthesisResult
implements AutoCloseable {
    private String resultId;
    private ResultReason reason;
    private long audioLength;
    private long audioDuration;
    private byte[] audioData;
    private PropertyCollection properties;
    private SafeHandle resultHandle = null;

    protected SpeechSynthesisResult(IntRef intRef) {
        Contracts.throwIfNull(intRef, "result");
        this.resultHandle = new SafeHandle(intRef.getValue(), SafeHandleType.SynthesisResult);
        StringRef stringRef = new StringRef("");
        Contracts.throwIfFail(this.getResultId(this.resultHandle, stringRef));
        this.resultId = stringRef.getValue();
        IntRef intRef2 = new IntRef(0L);
        Contracts.throwIfFail(this.getResultReason(this.resultHandle, intRef2));
        this.reason = ResultReason.values()[(int)intRef2.getValue()];
        IntRef intRef3 = new IntRef(0L);
        IntRef intRef4 = new IntRef(0L);
        Contracts.throwIfFail(this.getAudioLength(this.resultHandle, intRef3, intRef4));
        this.audioLength = intRef3.getValue();
        this.audioDuration = intRef4.getValue() * 10000L;
        this.audioData = null;
        IntRef intRef5 = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromResult(this.resultHandle, intRef5));
        this.properties = new PropertyCollection(intRef5);
    }

    public String getResultId() {
        return this.resultId;
    }

    public ResultReason getReason() {
        return this.reason;
    }

    public long getAudioLength() {
        return this.audioLength;
    }

    public long getAudioDuration() {
        return this.audioDuration;
    }

    public byte[] getAudioData() {
        if (this.audioData == null) {
            IntRef intRef = new IntRef(0L);
            this.audioData = this.getAudio(this.resultHandle, intRef);
            Contracts.throwIfFail(intRef.getValue());
        }
        return this.audioData;
    }

    public PropertyCollection getProperties() {
        return this.properties;
    }

    @Override
    public void close() {
        if (this.resultHandle != null) {
            this.resultHandle.close();
            this.resultHandle = null;
        }
        if (this.properties != null) {
            this.properties.close();
            this.properties = null;
        }
    }

    public SafeHandle getImpl() {
        return this.resultHandle;
    }

    private final native long getResultId(SafeHandle var1, StringRef var2);

    private final native long getResultReason(SafeHandle var1, IntRef var2);

    private final native long getPropertyBagFromResult(SafeHandle var1, IntRef var2);

    private final native long getAudioLength(SafeHandle var1, IntRef var2, IntRef var3);

    private final native byte[] getAudio(SafeHandle var1, IntRef var2);
}

