/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.diagnostics.logging;

import com.microsoft.cognitiveservices.speech.Diagnostics;
import com.microsoft.cognitiveservices.speech.diagnostics.logging.Level;
import com.microsoft.cognitiveservices.speech.diagnostics.logging.Logger;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public final class MemoryLogger {
    private MemoryLogger() {
    }

    public static void start() {
        Diagnostics.startMemoryLogging();
    }

    public static void stop() {
        Diagnostics.stopMemoryLogging();
    }

    public static void setFilters(String[] stringArray) {
        Contracts.throwIfNull(stringArray, "filters");
        Logger.setMemoryLoggingFilters(stringArray);
    }

    public static void setFilters() {
        Logger.setMemoryLoggingFilters(new String[0]);
    }

    public static void setLevel(Level level) {
        Contracts.throwIfNull((Object)level, "level");
        Logger.setLevel(Logger.Type.Memory, level);
    }

    public static void dump(String string) {
        Contracts.throwIfNullOrWhitespace(string, "filePath");
        Diagnostics.dumpMemoryLog(string, "", false, false);
    }

    public static void dump(OutputStream outputStream) throws IOException {
        Contracts.throwIfNull(outputStream, "outStream");
        long l = Logger.getMemoryLogLineNumOldest();
        long l2 = Logger.getMemoryLogLineNumNewest();
        for (long i = l; i < l2; ++i) {
            outputStream.write(Logger.getMemoryLogLine(i).getBytes());
        }
    }

    public static List<String> dump() {
        ArrayList<String> arrayList = new ArrayList<String>();
        long l = Logger.getMemoryLogLineNumOldest();
        long l2 = Logger.getMemoryLogLineNumNewest();
        for (long i = l; i < l2; ++i) {
            arrayList.add(Logger.getMemoryLogLine(i));
        }
        return arrayList;
    }
}

