/*
 * Decompiled with CFR 0.152.
 */
package com.mindprogeny.wiremock.extension.scenario.admin.task;

import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.model.PathParams;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.mindprogeny.wiremock.extension.scenario.ConcurrentScenarioExtension;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import wiremock.com.fasterxml.jackson.databind.ObjectMapper;

public class DeleteScenariosWithBody
implements AdminTask {
    private ObjectMapper jsonMapper = new ObjectMapper();

    public ResponseDefinition execute(Admin admin, Request request, PathParams pathParams) {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        try {
            Map params = (Map)this.jsonMapper.readValue(request.getBodyAsString(), Map.class);
            for (Map scenario : (Collection)params.get("scenarios")) {
                String name = (String)scenario.get("name");
                Collection instances = (Collection)scenario.get("instances");
                if (instances == null) {
                    result.put(name, Boolean.valueOf(ConcurrentScenarioExtension.clearScenario(name)));
                    continue;
                }
                HashMap<String, Boolean> instancesResult = new HashMap<String, Boolean>();
                result.put(name, instancesResult);
                for (String instance : instances) {
                    instancesResult.put(instance, ConcurrentScenarioExtension.clearInstance(name, instance));
                }
            }
            return ResponseDefinitionBuilder.responseDefinition().withStatus(200).withHeader("content-type", new String[]{"application/json"}).withBody(this.jsonMapper.writeValueAsString(result)).build();
        }
        catch (IOException ioe) {
            StringWriter writer = new StringWriter();
            ioe.printStackTrace(new PrintWriter(writer));
            return ResponseDefinitionBuilder.responseDefinition().withStatus(400).withStatusMessage("Scenario Parameters in incorrect format.").withHeader("content-type", new String[]{"text/text"}).withBody("Expected format is:\n{\n  \"scenarios\": [\n    {\n      \"name\": \"<scenario name>\",\n      \"instances\": [\"<instance id>...\"]}\n  ]\n}").build();
        }
    }
}

