/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.scopes.threaddelegate;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import com.nesscomputing.scopes.threaddelegate.ScopedObject;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedContext;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedScope;
import java.lang.annotation.Annotation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestThreadDelegatedProvider {
    private ThreadDelegatedScope scope = null;
    private final Key<ScopedObject> fooTestObjectKey = Key.get(ScopedObject.class, (Annotation)Names.named((String)"foo"));

    @Before
    public void setUp() {
        Assert.assertNull((Object)this.scope);
        this.scope = new ThreadDelegatedScope();
    }

    @After
    public void tearDown() {
        Assert.assertNotNull((Object)this.scope);
        this.scope = null;
    }

    @Test
    public void testUnscopedProvider() {
        ScopedObject.TestObjectProvider unscopedProvider = new ScopedObject.TestObjectProvider();
        ScopedObject t1 = (ScopedObject)unscopedProvider.get();
        Assert.assertNotNull((Object)t1);
        ScopedObject t2 = (ScopedObject)unscopedProvider.get();
        Assert.assertNotNull((Object)t2);
        Assert.assertNotSame((Object)t1, (Object)t2);
    }

    @Test
    public void testSimpleProvider() {
        Provider scopedProvider = this.scope.scope(this.fooTestObjectKey, (Provider)new ScopedObject.TestObjectProvider());
        Assert.assertNotNull((Object)scopedProvider);
        ScopedObject t1 = (ScopedObject)scopedProvider.get();
        Assert.assertNotNull((Object)t1);
        ScopedObject t2 = (ScopedObject)scopedProvider.get();
        Assert.assertNotNull((Object)t2);
        Assert.assertSame((Object)t1, (Object)t2);
    }

    @Test
    public void testScopeChange() {
        Provider scopedProvider = this.scope.scope(this.fooTestObjectKey, (Provider)new ScopedObject.TestObjectProvider());
        Assert.assertNotNull((Object)scopedProvider);
        ScopedObject t1 = (ScopedObject)scopedProvider.get();
        Assert.assertNotNull((Object)t1);
        this.scope.changeScope(null);
        ScopedObject t2 = (ScopedObject)scopedProvider.get();
        Assert.assertNotNull((Object)t2);
        Assert.assertNotSame((Object)t1, (Object)t2);
    }

    @Test
    public void testScopeHandoff() {
        Provider scopedProvider = this.scope.scope(this.fooTestObjectKey, (Provider)new ScopedObject.TestObjectProvider());
        Assert.assertNotNull((Object)scopedProvider);
        ScopedObject t1 = (ScopedObject)scopedProvider.get();
        Assert.assertNotNull((Object)t1);
        ThreadDelegatedContext plate = this.scope.getContext();
        this.scope.changeScope(null);
        ScopedObject t2 = (ScopedObject)scopedProvider.get();
        Assert.assertNotNull((Object)t2);
        Assert.assertNotSame((Object)t1, (Object)t2);
        this.scope.changeScope(plate);
        ScopedObject t3 = (ScopedObject)scopedProvider.get();
        Assert.assertNotNull((Object)t3);
        Assert.assertSame((Object)t1, (Object)t3);
        Assert.assertNotSame((Object)t2, (Object)t3);
    }
}

