/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.scopes.threaddelegate;

import com.google.inject.Key;
import com.google.inject.name.Names;
import com.nesscomputing.scopes.threaddelegate.EventRecordingObject;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedContext;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedScope;
import java.lang.annotation.Annotation;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestThreadDelegatedScope {
    private ThreadDelegatedScope scope = null;
    private final Key<String> fooStringKey = Key.get(String.class, (Annotation)Names.named((String)"foo"));

    @Before
    public void setUp() {
        Assert.assertNull((Object)this.scope);
        this.scope = new ThreadDelegatedScope();
    }

    @After
    public void tearDown() {
        Assert.assertNotNull((Object)this.scope);
        this.scope = null;
    }

    @Test
    public void testNewPlate() {
        ThreadDelegatedContext plate = this.scope.getContext();
        Assert.assertNotNull((Object)plate);
        Assert.assertEquals((long)0L, (long)plate.size());
        ThreadDelegatedContext plate2 = this.scope.getContext();
        Assert.assertNotNull((Object)plate2);
        Assert.assertEquals((long)0L, (long)plate2.size());
        Assert.assertSame((Object)plate, (Object)plate2);
    }

    @Test
    public void testScopeLeave() {
        ThreadDelegatedContext plate = this.scope.getContext();
        Assert.assertNotNull((Object)plate);
        Assert.assertEquals((long)0L, (long)plate.size());
        this.scope.changeScope(null);
        ThreadDelegatedContext plate2 = this.scope.getContext();
        Assert.assertNotNull((Object)plate2);
        Assert.assertEquals((long)0L, (long)plate2.size());
        Assert.assertNotSame((Object)plate, (Object)plate2);
    }

    @Test
    public void testScopePromote() {
        ThreadDelegatedContext newPlate = new ThreadDelegatedContext();
        ThreadDelegatedContext plate = this.scope.getContext();
        Assert.assertNotNull((Object)plate);
        Assert.assertEquals((long)0L, (long)plate.size());
        this.scope.changeScope(newPlate);
        ThreadDelegatedContext plate2 = this.scope.getContext();
        Assert.assertNotNull((Object)plate2);
        Assert.assertEquals((long)0L, (long)plate2.size());
        Assert.assertNotSame((Object)plate, (Object)plate2);
        Assert.assertSame((Object)newPlate, (Object)plate2);
    }

    @Test
    public void testChangeScopeEvents() {
        ThreadDelegatedContext plate = this.scope.getContext();
        Assert.assertNotNull((Object)plate);
        Assert.assertEquals((long)0L, (long)plate.size());
        EventRecordingObject fooEventTest = new EventRecordingObject();
        plate.put(this.fooStringKey, (Object)fooEventTest);
        Assert.assertEquals((long)1L, (long)fooEventTest.getEventCount());
        Assert.assertEquals((Object)ThreadDelegatedContext.ScopeEvent.ENTER, (Object)fooEventTest.getLastEvent());
        this.scope.changeScope(null);
        Assert.assertEquals((long)2L, (long)fooEventTest.getEventCount());
        Assert.assertEquals((Object)ThreadDelegatedContext.ScopeEvent.LEAVE, (Object)fooEventTest.getLastEvent());
    }

    @Test
    public void testScopeEnterLeaveEvents() {
        ThreadDelegatedContext plate = new ThreadDelegatedContext();
        EventRecordingObject fooEventTest = new EventRecordingObject();
        plate.put(this.fooStringKey, (Object)fooEventTest);
        Assert.assertEquals((long)1L, (long)fooEventTest.getEventCount());
        Assert.assertEquals((Object)ThreadDelegatedContext.ScopeEvent.ENTER, (Object)fooEventTest.getLastEvent());
        this.scope.changeScope(plate);
        Assert.assertSame((Object)plate, (Object)this.scope.getContext());
        Assert.assertEquals((long)2L, (long)fooEventTest.getEventCount());
        Assert.assertEquals((Object)ThreadDelegatedContext.ScopeEvent.ENTER, (Object)fooEventTest.getLastEvent());
        this.scope.changeScope(null);
        Assert.assertNotSame((Object)plate, (Object)this.scope.getContext());
        Assert.assertEquals((long)3L, (long)fooEventTest.getEventCount());
        Assert.assertEquals((Object)ThreadDelegatedContext.ScopeEvent.LEAVE, (Object)fooEventTest.getLastEvent());
        this.scope.changeScope(plate);
        Assert.assertSame((Object)plate, (Object)this.scope.getContext());
        Assert.assertEquals((long)4L, (long)fooEventTest.getEventCount());
        Assert.assertEquals((Object)ThreadDelegatedContext.ScopeEvent.ENTER, (Object)fooEventTest.getLastEvent());
        this.scope.changeScope(new ThreadDelegatedContext());
        Assert.assertNotSame((Object)plate, (Object)this.scope.getContext());
        Assert.assertEquals((long)5L, (long)fooEventTest.getEventCount());
        Assert.assertEquals((Object)ThreadDelegatedContext.ScopeEvent.LEAVE, (Object)fooEventTest.getLastEvent());
        this.scope.changeScope(plate);
        Assert.assertSame((Object)plate, (Object)this.scope.getContext());
        Assert.assertEquals((long)6L, (long)fooEventTest.getEventCount());
        Assert.assertEquals((Object)ThreadDelegatedContext.ScopeEvent.ENTER, (Object)fooEventTest.getLastEvent());
        this.scope.changeScope(plate);
        Assert.assertSame((Object)plate, (Object)this.scope.getContext());
        Assert.assertEquals((long)6L, (long)fooEventTest.getEventCount());
        Assert.assertEquals((Object)ThreadDelegatedContext.ScopeEvent.ENTER, (Object)fooEventTest.getLastEvent());
    }
}

