/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.scopes.threaddelegate.concurrent;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scope;
import com.google.inject.Stage;
import com.google.inject.servlet.GuiceFilter;
import com.nesscomputing.scopes.threaddelegate.ScopedObject;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedScope;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedScopeModule;
import com.nesscomputing.scopes.threaddelegate.concurrent.ThreadDelegatingDecorator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestThreadDelegatedExecutor {
    @Inject
    private Injector injector = null;
    private ThreadPoolExecutor unwrappedExecutor = null;

    @Before
    public void setUp() {
        ThreadDelegatedScope.SCOPE.changeScope(null);
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ThreadDelegatedScopeModule(), new AbstractModule(){

            public void configure() {
                this.bind(ScopedObject.class).toProvider(ScopedObject.TestObjectProvider.class).in((Scope)ThreadDelegatedScope.SCOPE);
            }
        }});
        injector.injectMembers((Object)this);
        Assert.assertNotNull((Object)injector);
        this.unwrappedExecutor = new ThreadPoolExecutor(5, 5, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        Assert.assertFalse((boolean)this.unwrappedExecutor.isShutdown());
        Assert.assertFalse((boolean)this.unwrappedExecutor.isTerminated());
    }

    @After
    public void tearDown() {
        Assert.assertNotNull((Object)this.unwrappedExecutor);
        this.unwrappedExecutor.shutdown();
        this.unwrappedExecutor = null;
        Assert.assertNotNull((Object)this.injector);
        GuiceFilter filter = (GuiceFilter)this.injector.getInstance(GuiceFilter.class);
        filter.destroy();
        this.injector = null;
        ThreadDelegatedScope.SCOPE.changeScope(null);
    }

    @Test
    public void testUnwrappedExecutor() throws Exception {
        ScopedObject t1 = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        Assert.assertNotNull((Object)t1);
        CountDownLatch latch = new CountDownLatch(1);
        ScopedRunnable runnable = new ScopedRunnable(latch);
        this.unwrappedExecutor.execute(runnable);
        Assert.assertTrue((String)"Some threads got stuck!", (boolean)latch.await(1L, TimeUnit.SECONDS));
        Assert.assertNotSame((Object)t1, (Object)runnable.getTestObject());
    }

    @Test
    public void testWrappedExecutor() throws Exception {
        ScopedObject t1 = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        Assert.assertNotNull((Object)t1);
        CountDownLatch latch = new CountDownLatch(1);
        ScopedRunnable runnable = new ScopedRunnable(latch);
        ThreadDelegatingDecorator.wrapExecutor((Executor)this.unwrappedExecutor).execute(runnable);
        Assert.assertTrue((String)"Some threads got stuck!", (boolean)latch.await(1L, TimeUnit.SECONDS));
        Assert.assertSame((Object)t1, (Object)runnable.getTestObject());
    }

    @Test
    public void testMultipleUnwrappedExecutor() throws Exception {
        int i;
        ScopedObject t1 = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        Assert.assertNotNull((Object)t1);
        int testCount = 10;
        ScopedRunnable[] runnables = new ScopedRunnable[10];
        CountDownLatch latch = new CountDownLatch(10);
        for (i = 0; i < 10; ++i) {
            runnables[i] = new ScopedRunnable(latch);
            this.unwrappedExecutor.execute(runnables[i]);
        }
        Assert.assertTrue((String)"Some threads got stuck!", (boolean)latch.await(1L, TimeUnit.SECONDS));
        for (i = 0; i < 10; ++i) {
            Assert.assertNotSame((Object)t1, (Object)runnables[i].getTestObject());
        }
    }

    @Test
    public void testMultipleWrappedExecutor() throws Exception {
        int i;
        ScopedObject t1 = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        Assert.assertNotNull((Object)t1);
        int testCount = 10;
        ScopedRunnable[] runnables = new ScopedRunnable[10];
        CountDownLatch latch = new CountDownLatch(10);
        Executor wrappedExecutor = ThreadDelegatingDecorator.wrapExecutor((Executor)this.unwrappedExecutor);
        for (i = 0; i < 10; ++i) {
            runnables[i] = new ScopedRunnable(latch);
            wrappedExecutor.execute(runnables[i]);
        }
        Assert.assertTrue((String)"Some threads got stuck!", (boolean)latch.await(10000L, TimeUnit.SECONDS));
        for (i = 0; i < 10; ++i) {
            Assert.assertSame((Object)t1, (Object)runnables[i].getTestObject());
        }
    }

    public class ScopedRunnable
    implements Runnable {
        private volatile ScopedObject testObject;
        private final CountDownLatch latch;

        public ScopedRunnable(CountDownLatch latch) {
            this.latch = latch;
        }

        @Override
        public void run() {
            this.testObject = (ScopedObject)TestThreadDelegatedExecutor.this.injector.getInstance(ScopedObject.class);
            this.latch.countDown();
        }

        public ScopedObject getTestObject() {
            return this.testObject;
        }
    }
}

