/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.scopes.threaddelegate.concurrent;

import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scope;
import com.google.inject.Stage;
import com.google.inject.servlet.GuiceFilter;
import com.nesscomputing.scopes.threaddelegate.ScopedObject;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedScope;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedScopeModule;
import com.nesscomputing.scopes.threaddelegate.concurrent.ThreadDelegatingDecorator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestThreadDelegatedExecutorService {
    @Inject
    private Injector injector = null;
    private ThreadPoolExecutor unwrappedExecutor = null;

    @Before
    public void setUp() {
        ThreadDelegatedScope.SCOPE.changeScope(null);
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ThreadDelegatedScopeModule(), new AbstractModule(){

            public void configure() {
                this.bind(ScopedObject.class).toProvider(ScopedObject.TestObjectProvider.class).in((Scope)ThreadDelegatedScope.SCOPE);
            }
        }});
        injector.injectMembers((Object)this);
        Assert.assertNotNull((Object)injector);
        this.unwrappedExecutor = new ThreadPoolExecutor(5, 5, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        Assert.assertFalse((boolean)this.unwrappedExecutor.isShutdown());
        Assert.assertFalse((boolean)this.unwrappedExecutor.isTerminated());
    }

    @After
    public void tearDown() {
        Assert.assertNotNull((Object)this.unwrappedExecutor);
        this.unwrappedExecutor.shutdown();
        this.unwrappedExecutor = null;
        Assert.assertNotNull((Object)this.injector);
        GuiceFilter filter = (GuiceFilter)this.injector.getInstance(GuiceFilter.class);
        filter.destroy();
        this.injector = null;
        ThreadDelegatedScope.SCOPE.changeScope(null);
    }

    @Test
    public void testUnwrappedExecutor() throws Exception {
        ScopedObject t1 = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        Assert.assertNotNull((Object)t1);
        ScopedCallable callable = new ScopedCallable();
        Future<ScopedObject> future = this.unwrappedExecutor.submit(callable);
        Assert.assertNotSame((Object)t1, (Object)future.get());
    }

    @Test
    public void testWrappedExecutor() throws Exception {
        ScopedObject t1 = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        Assert.assertNotNull((Object)t1);
        ScopedCallable callable = new ScopedCallable();
        Future<ScopedObject> future = ThreadDelegatingDecorator.wrapExecutorService((ExecutorService)this.unwrappedExecutor).submit(callable);
        Assert.assertSame((Object)t1, (Object)future.get());
    }

    @Test
    public void testMultipleUnwrappedExecutor() throws Exception {
        int i;
        ScopedObject t1 = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        Assert.assertNotNull((Object)t1);
        int testCount = 10;
        Future[] futures = new Future[10];
        for (i = 0; i < 10; ++i) {
            futures[i] = this.unwrappedExecutor.submit(new ScopedCallable());
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertNotSame((Object)t1, futures[i].get());
        }
    }

    @Test
    public void testMultipleWrappedExecutor() throws Exception {
        int i;
        ScopedObject t1 = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        Assert.assertNotNull((Object)t1);
        int testCount = 10;
        Future[] futures = new Future[10];
        ExecutorService wrappedExecutorService = ThreadDelegatingDecorator.wrapExecutorService((ExecutorService)this.unwrappedExecutor);
        for (i = 0; i < 10; ++i) {
            futures[i] = wrappedExecutorService.submit(new ScopedCallable());
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertSame((Object)t1, futures[i].get());
        }
    }

    @Test
    public void testAllTogetherNow() throws Exception {
        ScopedObject t1 = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        Assert.assertNotNull((Object)t1);
        int testCount = 10;
        ArrayList callables = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            callables.add(new ScopedCallable());
        }
        ExecutorService wrappedExecutorService = ThreadDelegatingDecorator.wrapExecutorService((ExecutorService)this.unwrappedExecutor);
        List futures = wrappedExecutorService.invokeAll(callables);
        for (Future future : futures) {
            Assert.assertSame((Object)t1, future.get());
        }
    }

    public class ScopedCallable
    implements Callable<ScopedObject> {
        @Override
        public ScopedObject call() {
            return (ScopedObject)TestThreadDelegatedExecutorService.this.injector.getInstance(ScopedObject.class);
        }
    }
}

