/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.scopes.threaddelegate.servlet;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scope;
import com.google.inject.Stage;
import com.google.inject.servlet.GuiceFilter;
import com.nesscomputing.scopes.threaddelegate.ScopedObject;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedScope;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedScopeModule;
import com.nesscomputing.scopes.threaddelegate.servlet.ThreadDelegatingScopeFilter;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestThreadDelegatingScopeFilter {
    @Inject
    private ThreadDelegatingScopeFilter filter = null;
    @Inject
    private Injector injector = null;

    @Before
    public void setUp() {
        ThreadDelegatedScope.SCOPE.changeScope(null);
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ThreadDelegatedScopeModule(), new AbstractModule(){

            public void configure() {
                this.bind(ScopedObject.class).toProvider(ScopedObject.TestObjectProvider.class).in((Scope)ThreadDelegatedScope.SCOPE);
            }
        }});
        injector.injectMembers((Object)this);
        Assert.assertNotNull((Object)this.filter);
        Assert.assertNotNull((Object)injector);
    }

    @After
    public void tearDown() {
        Assert.assertNotNull((Object)this.filter);
        this.filter = null;
        Assert.assertNotNull((Object)this.injector);
        GuiceFilter filter = (GuiceFilter)this.injector.getInstance(GuiceFilter.class);
        filter.destroy();
        this.injector = null;
        ThreadDelegatedScope.SCOPE.changeScope(null);
    }

    @Test
    public void testSimpleFilter() throws Exception {
        ScopedObject t1 = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        Assert.assertNotNull((Object)t1);
        final AtomicReference refHolder = new AtomicReference();
        HttpServletRequest request = (HttpServletRequest)EasyMock.createNiceMock(HttpServletRequest.class);
        EasyMock.replay((Object[])new Object[]{request});
        this.filter.doFilter((ServletRequest)request, null, new FilterChain(){

            public void doFilter(ServletRequest req, ServletResponse res) {
                ScopedObject t2 = (ScopedObject)TestThreadDelegatingScopeFilter.this.injector.getInstance(ScopedObject.class);
                Assert.assertNotNull((Object)t2);
                refHolder.set(t2);
            }
        });
        ScopedObject t2 = (ScopedObject)refHolder.get();
        Assert.assertNotNull((Object)t2);
        ScopedObject t3 = (ScopedObject)this.injector.getInstance(ScopedObject.class);
        Assert.assertNotNull((Object)t3);
        Assert.assertNotSame((Object)t1, (Object)t2);
        Assert.assertNotSame((Object)t1, (Object)t3);
        Assert.assertNotSame((Object)t2, (Object)t3);
        EasyMock.verify((Object[])new Object[]{request});
    }
}

