/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.scopes.threaddelegate;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Singleton;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedContext;
import javax.annotation.Nullable;

@Singleton
public class ThreadDelegatedScope
implements Scope {
    private final ThreadLocal<ThreadDelegatedContext> threadLocal = new ThreadLocal();
    public static final ThreadDelegatedScope SCOPE = new ThreadDelegatedScope();

    ThreadDelegatedScope() {
    }

    public ThreadDelegatedContext getContext() {
        ThreadDelegatedContext context = this.threadLocal.get();
        if (context == null) {
            context = new ThreadDelegatedContext();
            this.threadLocal.set(context);
        }
        return context;
    }

    public void changeScope(@Nullable ThreadDelegatedContext context) {
        ThreadDelegatedContext oldContext = this.threadLocal.get();
        if (oldContext != null) {
            if (oldContext == context) {
                return;
            }
            oldContext.event(ThreadDelegatedContext.ScopeEvent.LEAVE);
        }
        if (context != null) {
            this.threadLocal.set(context);
            context.event(ThreadDelegatedContext.ScopeEvent.ENTER);
        } else {
            this.threadLocal.remove();
        }
    }

    public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
        return new ThreadDelegatedScopeProvider<T>(key, unscoped);
    }

    public class ThreadDelegatedScopeProvider<T>
    implements Provider<T> {
        private final Key<T> key;
        private final Provider<T> unscoped;
        private volatile String toString = null;

        public ThreadDelegatedScopeProvider(Key<T> key, Provider<T> unscoped) {
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key must not be null!");
            Preconditions.checkArgument((unscoped != null ? 1 : 0) != 0, (Object)"unscoped provider must not be null!");
            this.key = key;
            this.unscoped = unscoped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get() {
            ThreadDelegatedContext context;
            ThreadDelegatedContext threadDelegatedContext = context = ThreadDelegatedScope.this.getContext();
            synchronized (threadDelegatedContext) {
                if (context.containsKey(this.key)) {
                    return context.get(this.key);
                }
                Object value = this.unscoped.get();
                context.put(this.key, value);
                return (T)value;
            }
        }

        public synchronized String toString() {
            if (this.toString == null) {
                this.toString = String.format("ThreadDelegatedScoped provider (Key: %s) of %s", this.key.toString(), this.unscoped.toString());
            }
            return this.toString;
        }
    }
}

