/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.scopes.threaddelegate.concurrent;

import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedContext;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedScope;
import java.util.concurrent.Callable;

class DelegatingCallable<C>
implements Callable<C> {
    private final Callable<C> wrappedCallable;
    private final ThreadDelegatedContext callerContext;

    DelegatingCallable(Callable<C> wrappedCallable) {
        this.wrappedCallable = wrappedCallable;
        this.callerContext = ThreadDelegatedScope.SCOPE.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public C call() throws Exception {
        ThreadDelegatedContext originalContext = ThreadDelegatedScope.SCOPE.getContext();
        try {
            ThreadDelegatedScope.SCOPE.changeScope(this.callerContext);
            C c = this.wrappedCallable.call();
            return c;
        }
        finally {
            ThreadDelegatedScope.SCOPE.changeScope(originalContext);
        }
    }
}

