/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.scopes.threaddelegate.concurrent;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.nesscomputing.scopes.threaddelegate.concurrent.DelegatingCallable;
import com.nesscomputing.scopes.threaddelegate.concurrent.DelegatingRunnable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ThreadDelegatingExecutorService
implements ExecutorService {
    private final ExecutorService wrappedExcutorService;

    ThreadDelegatingExecutorService(ExecutorService wrappedExecutorService) {
        this.wrappedExcutorService = wrappedExecutorService;
    }

    @Override
    public void shutdown() {
        this.wrappedExcutorService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.wrappedExcutorService.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.wrappedExcutorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.wrappedExcutorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.wrappedExcutorService.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.wrappedExcutorService.execute(new DelegatingRunnable(command));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.wrappedExcutorService.submit(new DelegatingCallable<T>(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.wrappedExcutorService.submit(new DelegatingRunnable(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.wrappedExcutorService.submit(new DelegatingRunnable(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        Preconditions.checkArgument((tasks != null ? 1 : 0) != 0, (Object)"collection of tasks can not be null!");
        return this.wrappedExcutorService.invokeAll(this.meatify(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkArgument((tasks != null ? 1 : 0) != 0, (Object)"collection of tasks can not be null!");
        return this.wrappedExcutorService.invokeAll(this.meatify(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.wrappedExcutorService.invokeAny(this.meatify(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.wrappedExcutorService.invokeAny(this.meatify(tasks), timeout, unit);
    }

    private <T> Collection<Callable<T>> meatify(Collection<? extends Callable<T>> callables) {
        return Collections2.transform(callables, (Function)new Function<Callable<T>, Callable<T>>(){

            public Callable<T> apply(Callable<T> input) {
                return new DelegatingCallable(input);
            }
        });
    }
}

