/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.scopes.threaddelegate.servlet;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.nesscomputing.logging.Log;
import com.nesscomputing.scopes.threaddelegate.ThreadDelegatedScope;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

@Singleton
public class ThreadDelegatingScopeFilter
implements Filter {
    private static final Log LOG = Log.findLog();
    public static final String THREAD_DELEGATING_SCOPE_ACTIVE = ThreadDelegatingScopeFilter.class.getName() + ".active";
    private final ThreadDelegatedScope scope;

    @Inject
    ThreadDelegatingScopeFilter(ThreadDelegatedScope scope) {
        this.scope = scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.scope.changeScope(null);
            request.setAttribute(THREAD_DELEGATING_SCOPE_ACTIVE, (Object)Boolean.TRUE);
            chain.doFilter(request, response);
        }
        finally {
            this.scope.changeScope(null);
            request.removeAttribute(THREAD_DELEGATING_SCOPE_ACTIVE);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("ThreadDelegating scope now available!");
    }

    public void destroy() {
    }
}

