/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.JDBCAPI;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.HanaConnection;
import com.sap.db.jdbc.PassportListener;
import java.sql.SQLException;
import java.util.Properties;

@ThreadSafe
public class HanaConnectionFinalize
extends HanaConnection {
    protected static HanaConnection newInstance(String urlPrefix, Properties mergedInfo, ConnectionProperties connectionProperties) throws SQLException {
        HanaConnectionFinalize connection = new HanaConnectionFinalize(urlPrefix, mergedInfo, connectionProperties);
        Driver._addConnection(connection);
        return connection;
    }

    protected HanaConnectionFinalize(String urlPrefix, Properties mergedInfo, ConnectionProperties connectionProperties) throws SQLException {
        super(urlPrefix, mergedInfo, connectionProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="true")
    protected void finalize() throws Throwable {
        boolean on = this._tracer.on();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this.getPassportListener();
        try {
            if (on) {
                this._tracer.printFinalizing(this.getTraceString(true));
            }
            try {
                if (aon || pl != null) {
                    this.apiStart();
                }
                this._clean();
            }
            finally {
                if (aon || pl != null) {
                    this.apiFinish(aon, pl);
                }
            }
        }
        finally {
            super.finalize();
            if (on) {
                this._tracer.printFinalized();
            }
        }
    }
}

