/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.PublicAddress;
import com.sap.db.jdbc.SMVRRole;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SiteReplicaVolumeID;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SiteTypeReplicaRoleVolumeID;
import com.sap.db.jdbc.SystemInfo;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.trace.Tracer;
import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public class SessionPool {
    private final WeakReference<ConnectionSapDB> _connection;
    private final Tracer _tracer;
    private final Map<SiteTypeReplicaRoleVolumeID, Session> _sessions;
    private final AtomicReference<Session> _anchorSession;
    private final AtomicReference<Session> _primarySession;
    private final AtomicReference<SystemInfo> _systemInfo;
    private final AtomicReference<Session> _lastPreparedExecuteSessionForNoneOrPrimarySite;
    private final AtomicInteger _lastAnchorConnectionID;
    private final AtomicReference<String> _cookieForDisconnect;

    public SessionPool(ConnectionSapDB connection) {
        this._connection = new WeakReference<ConnectionSapDB>(connection);
        this._tracer = connection.getTracer();
        this._sessions = new ConcurrentHashMap<SiteTypeReplicaRoleVolumeID, Session>();
        this._anchorSession = new AtomicReference();
        this._primarySession = new AtomicReference();
        this._systemInfo = new AtomicReference();
        this._lastPreparedExecuteSessionForNoneOrPrimarySite = new AtomicReference();
        this._lastAnchorConnectionID = new AtomicInteger();
        this._cookieForDisconnect = new AtomicReference();
    }

    public Map<SiteTypeReplicaRoleVolumeID, Session> getSessions() {
        return Collections.unmodifiableMap(this._sessions);
    }

    public Session getSession(SiteTypeReplicaRoleVolumeID siteTypeReplicaRoleVolumeID) {
        SystemInfo systemInfo = this._systemInfo.get();
        if (systemInfo == null) {
            return null;
        }
        Session session = this._sessions.get(siteTypeReplicaRoleVolumeID);
        if (session == null) {
            int siteCount = systemInfo.getSiteCount();
            SMVRRole smvrRole = siteTypeReplicaRoleVolumeID.getSMVRRole();
            int volumeID = siteTypeReplicaRoleVolumeID.getVolumeID();
            if (siteCount == 1) {
                for (SiteTypeReplicaRoleVolumeID aSiteTypeReplicaRoleVolumeID : this._sessions.keySet()) {
                    if (aSiteTypeReplicaRoleVolumeID.getSMVRRole() != smvrRole || aSiteTypeReplicaRoleVolumeID.getVolumeID() != volumeID) continue;
                    return this._sessions.get(aSiteTypeReplicaRoleVolumeID);
                }
            }
        }
        return session;
    }

    public SiteTypeReplicaRoleVolumeID getSessionSiteTypeReplicaRoleVolumeID(Session session) {
        SystemInfo systemInfo = this._systemInfo.get();
        if (systemInfo == null) {
            return null;
        }
        for (Map.Entry<SiteTypeReplicaRoleVolumeID, Session> entry : this._sessions.entrySet()) {
            if (entry.getValue() != session) continue;
            return entry.getKey();
        }
        return null;
    }

    public SiteTypeReplicaRoleVolumeID getCorrespondingSiteTypeReplicaRoleVolumeIDForSiteID(Integer siteID) throws SQLException {
        return this.getCorrespondingSiteTypeReplicaRoleVolumeIDForSiteID(siteID, this.getPrimarySession());
    }

    public SiteTypeReplicaRoleVolumeID getCorrespondingSiteTypeReplicaRoleVolumeIDForSiteID(Integer siteID, Session session) throws SQLException {
        SystemInfo systemInfo = this._systemInfo.get();
        if (systemInfo == null) {
            return null;
        }
        SiteType siteIDType = systemInfo.getSiteType(siteID.byteValue());
        if (siteIDType == SiteType.NONE) {
            throw SQLExceptionSapDB.newInstance("error.force.route.invalidsiteid", siteID.toString());
        }
        return new SiteTypeReplicaRoleVolumeID(siteIDType, SMVRRole.NONE, session.getVolumeID());
    }

    public Session getAnchorSession() {
        return this._anchorSession.get();
    }

    public Session getPrimarySession() {
        return this._primarySession.get();
    }

    public void setPrimarySession(Session session) {
        Session primarySession = this._primarySession.get();
        if (primarySession == null) {
            this._primarySession.set(session);
            if (this._tracer.on()) {
                this._tracer.printDistribution((ConnectionSapDB)this._connection.get(), "Primary session changed to " + session.getTraceString(true, false));
            }
        } else if (primarySession != session) {
            this._primarySession.set(session);
            if (!session.isSiteRouted()) {
                this.setSendSessionContextFlag();
            }
            if (this._tracer.on()) {
                this._tracer.printDistribution((ConnectionSapDB)this._connection.get(), "Primary session changed to " + session.getTraceString(true, false));
            }
        }
    }

    SystemInfo getSystemInfo() {
        return this._systemInfo.get();
    }

    SystemInfo setSystemInfo(SystemInfo systemInfo) {
        return this._systemInfo.getAndSet(systemInfo);
    }

    public Session getLastPreparedExecuteSessionForNoneOrPrimarySite() {
        return this._lastPreparedExecuteSessionForNoneOrPrimarySite.get();
    }

    public void setLastPreparedExecuteSessionForNoneOrPrimarySite(Session session) {
        this._lastPreparedExecuteSessionForNoneOrPrimarySite.set(session);
    }

    public int getLastAnchorConnectionID() {
        Integer lastAnchorConnectionID = this._lastAnchorConnectionID.get();
        return lastAnchorConnectionID != null ? lastAnchorConnectionID : -1;
    }

    public void addSession(Session session) {
        SystemInfo systemInfo;
        SiteReplicaVolumeID siteReplicaVolumeID = session.getSiteReplicaVolumeID();
        Session primarySession = this._primarySession.get();
        if (!session.isSiteRouted() && !session.isReplicaRouted()) {
            if (this._anchorSession.compareAndSet(null, session)) {
                this._lastAnchorConnectionID.set(session.getConnectionID());
                if (this._tracer.on()) {
                    this._tracer.printDistribution((ConnectionSapDB)this._connection.get(), "Anchor session changed to " + session.getTraceString(true, false));
                }
            }
            if (primarySession == null || !primarySession.isConnected()) {
                this._primarySession.set(session);
                if (this._tracer.on()) {
                    this._tracer.printDistribution((ConnectionSapDB)this._connection.get(), "Primary session changed to " + session.getTraceString(true, false));
                }
            } else if (primarySession.getSiteReplicaVolumeID().equals(siteReplicaVolumeID)) {
                this._primarySession.set(session);
                if (this._tracer.on()) {
                    this._tracer.printDistribution((ConnectionSapDB)this._connection.get(), "Primary session changed to " + session.getTraceString(true, false));
                }
            }
        }
        SiteType siteType = (systemInfo = this._systemInfo.get()) != null ? systemInfo.getSiteType(siteReplicaVolumeID.getSiteID()) : SiteType.NONE;
        SMVRRole smvrRole = systemInfo != null ? systemInfo.getSMVRRole(siteReplicaVolumeID.intValue()) : SMVRRole.NONE;
        this._sessions.put(new SiteTypeReplicaRoleVolumeID(siteType, smvrRole, siteReplicaVolumeID.getVolumeID()), session);
    }

    public void setSendSessionContextFlag() {
        for (Session session : this.getSessions().values()) {
            session.setSendSessionContextFlag();
        }
    }

    public void setSendSessionVariablesFlag() {
        for (Session session : this.getSessions().values()) {
            session.setSendSessionVariablesFlag();
        }
    }

    public void setSendClientInfoFlag() {
        for (Session session : this.getSessions().values()) {
            session.setSendClientInfoFlag();
        }
    }

    public void releaseSecondary(Session session) {
        Session anchorSession = this._anchorSession.get();
        if (session == anchorSession) {
            throw new AssertionError((Object)"session must not be the anchor session");
        }
        this._releaseSessions(session, false, false);
        if (session == this._primarySession.get() && anchorSession != null) {
            this._primarySession.set(anchorSession);
        }
    }

    public void releaseAll(boolean sendCookieWithAnchorDisconnect) {
        this._releaseSessions(null, false, sendCookieWithAnchorDisconnect);
        this._sessions.clear();
        this._anchorSession.set(null);
        this._systemInfo.set(null);
        this._lastPreparedExecuteSessionForNoneOrPrimarySite.set(null);
    }

    public void releaseAllSiteRouted() {
        this._releaseSessions(null, true, false);
    }

    public void releaseAllReplicaRouted() {
        this._releaseSessions(null, true, false);
    }

    public void setCookieForDisconnect(String cookie) {
        this._cookieForDisconnect.set(cookie);
    }

    protected void _setSessionPublicAddress(Session session, PublicAddress publicAddress) {
        session._address.set(publicAddress);
        for (Map.Entry<SiteTypeReplicaRoleVolumeID, Session> entry : this._sessions.entrySet()) {
            SiteTypeReplicaRoleVolumeID siteTypeReplicaRoleVolumeID = entry.getKey();
            Session aSession = entry.getValue();
            boolean updateSiteType = false;
            boolean updateSMVRRole = false;
            if (aSession != session) continue;
            if (siteTypeReplicaRoleVolumeID.getSiteType() != publicAddress.getSiteType()) {
                updateSiteType = true;
            }
            if (siteTypeReplicaRoleVolumeID.getSMVRRole() != publicAddress.getSMVRRole()) {
                updateSMVRRole = true;
            }
            if (!updateSiteType && !updateSMVRRole) break;
            this._sessions.remove(siteTypeReplicaRoleVolumeID);
            this._sessions.put(new SiteTypeReplicaRoleVolumeID(publicAddress.getSiteType(), publicAddress.getSMVRRole(), publicAddress.getVolumeID()), session);
            break;
        }
    }

    private void _releaseSessions(Session thisSessionOnly, boolean siteOrReplicaRoutedOnly, boolean sendCookieWithAnchorDisconnect) {
        Session anchorSession = this._anchorSession.get();
        for (Map.Entry<SiteTypeReplicaRoleVolumeID, Session> entry : new HashMap<SiteTypeReplicaRoleVolumeID, Session>(this._sessions).entrySet()) {
            SiteTypeReplicaRoleVolumeID siteTypeReplicaRoleVolumeID = entry.getKey();
            Session session = entry.getValue();
            if (session != null && session.isConnected() && (thisSessionOnly == null || session != thisSessionOnly) && (thisSessionOnly != null || !siteOrReplicaRoutedOnly || !session.isSiteRouted() && !session.isReplicaRouted()) && (thisSessionOnly != null || siteOrReplicaRoutedOnly)) continue;
            if (session != null) {
                if (session.isConnected()) {
                    session.sendDisconnect(session == anchorSession && sendCookieWithAnchorDisconnect ? this._cookieForDisconnect.get() : null);
                }
                session.destroy();
            }
            this._sessions.remove(siteTypeReplicaRoleVolumeID);
        }
    }

    public Map<SiteTypeReplicaRoleVolumeID, Session> getSessionsMap() {
        return this._sessions;
    }

    public int getNumberOfLocations() {
        SystemInfo systemInfo = this._systemInfo.get();
        return systemInfo != null ? systemInfo.getAddressCount() : -1;
    }
}

