/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.JDBCAPI;
import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.HanaBlob;
import com.sap.db.jdbc.PassportListener;
import com.sap.db.jdbc.converters.AbstractGetval;
import com.sap.db.jdbc.converters.ReaderInputStream;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.exceptions.StreamIOException;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.util.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;

@NotThreadSafe
public abstract class GetvalBlob
extends AbstractGetval
implements Blob {
    protected GetvalBlob(SQLParamController controller, HDataPart dataPart, int lobFieldOffset, int length) throws SQLException {
        super(controller, dataPart, lobFieldOffset, length);
    }

    @Override
    protected long _length() {
        return this._byteLength;
    }

    @Override
    protected String _getString() throws SQLException {
        return new String(this._getBytes(1L, -1));
    }

    @Override
    protected byte[] _getBytes() throws SQLException {
        return this._getBytes(1L, -1);
    }

    @Override
    protected Reader _getCharacterStream(boolean traceReadNextChunk) throws SQLException {
        HanaBlob getvalBlob = new HanaBlob(this._controller, this._dataPart, this._lobFieldOffset, this._length);
        return new InputStreamReader(super._newBlobInputStream(traceReadNextChunk));
    }

    @Override
    protected InputStream _getAsciiStream(boolean traceReadNextChunk) throws SQLException {
        HanaBlob getvalBlob = new HanaBlob(this._controller, this._dataPart, this._lobFieldOffset, this._length);
        return new ReaderInputStream(new InputStreamReader(super._newBlobInputStream(traceReadNextChunk)), 4096, StandardCharsets.ISO_8859_1);
    }

    @Override
    protected InputStream _getBinaryStream(boolean traceReadNextChunk) throws SQLException {
        HanaBlob getvalBlob = new HanaBlob(this._controller, this._dataPart, this._lobFieldOffset, this._length);
        return super._newBlobInputStream(traceReadNextChunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public long length() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "length") : null;
        try {
            long result;
            if (on) {
                this._tracer.printCall(this, "length", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._length();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            long l = result;
            return l;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public byte[] getBytes(long pos, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("Blob", "getBytes") : null;
        try {
            byte[] result;
            if (on) {
                this._tracer.printCall(this, "getBytes", pos, length);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                result = this._getBytes(pos, length);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printResult(HexUtils.toDisplayHexString(result, 20));
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public InputStream getBinaryStream() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "getBinaryStream") : null;
        try {
            InputStream result;
            if (on) {
                this._tracer.printCall(this, "getBinaryStream", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getBinaryStream(true);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            InputStream inputStream = result;
            return inputStream;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public long position(byte[] pattern, long start) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "position") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "position", HexUtils.toDisplayHexString(pattern, 20), start);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw GetvalBlob._getUnsupportedMethodException("Blob", "position( byte[], long )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public long position(Blob pattern, long start) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "position") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "position", pattern, start);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw GetvalBlob._getUnsupportedMethodException("Blob", "position( Blob, long )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "setBytes") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setBytes", pos, HexUtils.toDisplayHexString(bytes, 20));
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw GetvalBlob._getUnsupportedMethodException("Blob", "setBytes( long, byte[] )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "setBytes") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setBytes", pos, HexUtils.toDisplayHexString(bytes, 20), offset, len);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw GetvalBlob._getUnsupportedMethodException("Blob", "setBytes( long, byte[], int, int )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public OutputStream setBinaryStream(long pos) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "setBinaryStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "setBinaryStream", pos);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw GetvalBlob._getUnsupportedMethodException("Blob", "setBinaryStream( long )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public void truncate(long len) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "truncate") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "truncate", len);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw GetvalBlob._getUnsupportedMethodException("Blob", "truncate( int )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public void free() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        PassportListener pl = this._connection.getPassportListener();
        TraceRecord r = pon ? this._newTraceRecord("Blob", "free") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "free", new Object[0]);
            }
            try {
                if (aon || pl != null) {
                    this._connection.apiStart();
                }
                this.removeAppLob(true);
            }
            finally {
                if (aon || pl != null) {
                    this._connection.apiFinish(aon, pl);
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "getBinaryStream") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "getBinaryStream", pos, length);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw GetvalBlob._getUnsupportedMethodException("Blob", "getBinaryStream( long, long )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    private byte[] _getBytes(long pos, int length) throws SQLException {
        byte[] bytes;
        BlobInputStream stream = this._newBlobInputStream(false);
        try {
            this._changeBytePosition(pos);
            if (length == -1) {
                int n;
                ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
                byte[] buf = new byte[4096];
                while ((n = stream.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                bytes = out.toByteArray();
            } else {
                byte[] buf = new byte[length];
                int n = stream.read(buf);
                if (n == -1) {
                    n = 0;
                }
                bytes = n == length ? buf : Arrays.copyOfRange(buf, 0, n);
            }
        }
        catch (StreamIOException e) {
            throw e.getSQLException();
        }
        catch (IOException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.stream.ioexception", e.getMessage());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bytes;
    }

    private BlobInputStream _newBlobInputStream(boolean traceReadNextChunk) throws SQLException {
        return new BlobInputStream(traceReadNextChunk);
    }

    private class BlobInputStream
    extends InputStream {
        private final boolean _traceReadNextChunk;

        private BlobInputStream(boolean traceReadNextChunk) {
            this._traceReadNextChunk = traceReadNextChunk;
        }

        @Override
        public int read() throws StreamIOException {
            if (GetvalBlob.this._currentPosition > GetvalBlob.this._byteLength) {
                return -1;
            }
            if (!GetvalBlob.this._atEnd && GetvalBlob.this._byteBuffer.remaining() == 0) {
                try {
                    if (this._traceReadNextChunk) {
                        GetvalBlob.this._tracer.printReadNextChunk(this);
                    }
                    GetvalBlob.this._nextChunk();
                }
                catch (SQLException e) {
                    throw new StreamIOException(e);
                }
            }
            if (GetvalBlob.this._atEnd) {
                return -1;
            }
            int result = GetvalBlob.this._byteBuffer.get() & 0xFF;
            ++GetvalBlob.this._currentPosition;
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws StreamIOException {
            int i;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            b[off] = (byte)c;
            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                b[off + i] = (byte)c;
            }
            return i;
        }
    }
}

