/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HPart;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.packet.PacketAnalyzer;
import com.sap.db.util.HexUtils;

@NotThreadSafe
public class HOptionsPart
extends HPart {
    protected final HRequestPacket _requestPacket;
    protected final boolean _includesPartHeader;
    protected int _argumentCount;
    protected int _currentOffset;
    private int _currentArgument;

    public HOptionsPart(HRequestPacket requestPacket, int offset) {
        super(requestPacket.getRawPacketArray(), offset, -1, false, requestPacket.asciiStringOptimization());
        this._requestPacket = requestPacket;
        this._includesPartHeader = false;
    }

    public HOptionsPart(byte[] packet, int offset, int length, boolean asciiStringOptimization) {
        super(packet, offset, length, true, asciiStringOptimization);
        this._requestPacket = null;
        this._includesPartHeader = true;
        this._argumentCount = PacketAnalyzer.getArgumentCount(this._packet, this._offset);
        this.rewind();
    }

    public int getArgumentCount() {
        return this._argumentCount;
    }

    public int getCurrentOffset() {
        return this._currentOffset;
    }

    public void rewind() {
        if (!this._isReadOnly) {
            return;
        }
        this._currentOffset = this._includesPartHeader ? 16 : 0;
        this._currentArgument = 0;
    }

    public void close() {
        this._checkModifiable();
        this._requestPacket._closePart(this._argumentCount, this._currentOffset);
    }

    public boolean nextOption() {
        if (this._currentArgument >= this._argumentCount) {
            return false;
        }
        if (!this._moveCurrentOffset()) {
            return false;
        }
        ++this._currentArgument;
        return this._currentArgument < this._argumentCount;
    }

    public int getOptionName() {
        return this.getByte(this._currentOffset);
    }

    public DataType getOptionType() {
        return DataType.decode(this.getByte(this._currentOffset + 1));
    }

    public String getDisplayOptionValue() {
        switch (this.getOptionType()) {
            case BOOLEAN: {
                return String.valueOf(this.getOptionBooleanValue());
            }
            case TINYINT: {
                return String.valueOf(this.getOptionTinyIntValue());
            }
            case INT: {
                return String.valueOf(this.getOptionIntValue());
            }
            case BIGINT: {
                return String.valueOf(this.getOptionLongValue());
            }
            case DOUBLE: {
                return String.valueOf(this.getOptionDoubleValue());
            }
            case STRING: {
                return this.getOptionStringValue();
            }
            case BSTRING: {
                return HexUtils.toDisplayHexString(this.getOptionBinaryValue());
            }
        }
        return null;
    }

    public boolean getOptionBooleanValue() {
        return this.getBoolean(this._currentOffset + 2);
    }

    public int getOptionTinyIntValue() {
        return this.getUByte(this._currentOffset + 2);
    }

    public int getOptionIntValue() {
        return this.getInt(this._currentOffset + 2);
    }

    public long getOptionLongValue() {
        return this.getLong(this._currentOffset + 2);
    }

    public double getOptionDoubleValue() {
        return this.getDouble(this._currentOffset + 2);
    }

    public String getOptionStringValue() {
        short len = this.getShort(this._currentOffset + 2);
        return this.getString(this._currentOffset + 4, len, false);
    }

    public byte[] getOptionBinaryValue() {
        return this.getOptionBinaryValue(null);
    }

    public byte[] getOptionBinaryValue(byte[] buffer) {
        short len = this.getShort(this._currentOffset + 2);
        return this.getBytes(this._currentOffset + 4, len, buffer);
    }

    public void addBooleanOption(int option, boolean optionValue) {
        this._addBooleanOpt(option, optionValue);
        ++this._argumentCount;
    }

    public void addTinyIntOption(int option, int optionValue) {
        this._addTinyIntOpt(option, optionValue);
        ++this._argumentCount;
    }

    public void addIntOption(int option, int optionValue) {
        this._addIntOpt(option, optionValue);
        ++this._argumentCount;
    }

    public void addLongOption(int option, long optionValue) {
        this._addLongOpt(option, optionValue);
        ++this._argumentCount;
    }

    public void addStringOption(int option, String optionValue) {
        this._addStringOpt(option, optionValue);
        ++this._argumentCount;
    }

    public void addBinaryOption(int option, byte[] optionValue) {
        this._addBinaryOpt(option, optionValue);
        ++this._argumentCount;
    }

    protected boolean _moveCurrentOffset() {
        switch (this.getOptionType()) {
            case BOOLEAN: 
            case TINYINT: {
                this._currentOffset += 3;
                break;
            }
            case INT: {
                this._currentOffset += 6;
                break;
            }
            case BIGINT: 
            case DOUBLE: {
                this._currentOffset += 10;
                break;
            }
            case STRING: 
            case BSTRING: {
                short len = this.getShort(this._currentOffset + 2);
                this._currentOffset += 4 + len;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected void _addBooleanOpt(int option, boolean optionValue) {
        this.putByte(option, this._currentOffset);
        this.putByte(DataType.BOOLEAN.getTypeCode(), this._currentOffset + 1);
        this.putByte(optionValue ? 1 : 0, this._currentOffset + 2);
        this._currentOffset += 3;
    }

    protected void _addTinyIntOpt(int option, int optionValue) {
        this.putByte(option, this._currentOffset);
        this.putByte(DataType.TINYINT.getTypeCode(), this._currentOffset + 1);
        this.putByte(optionValue, this._currentOffset + 2);
        this._currentOffset += 3;
    }

    protected void _addIntOpt(int option, int optionValue) {
        this.putByte(option, this._currentOffset);
        this.putByte(DataType.INT.getTypeCode(), this._currentOffset + 1);
        this.putInt(optionValue, this._currentOffset + 2);
        this._currentOffset += 6;
    }

    protected void _addLongOpt(int option, long optionValue) {
        this.putByte(option, this._currentOffset);
        this.putByte(DataType.BIGINT.getTypeCode(), this._currentOffset + 1);
        this.putLong(optionValue, this._currentOffset + 2);
        this._currentOffset += 10;
    }

    protected void _addStringOpt(int option, String optionValue) {
        this.putByte(option, this._currentOffset);
        this.putByte(DataType.STRING.getTypeCode(), this._currentOffset + 1);
        int len = this.putString(optionValue, this._currentOffset + 4);
        this.putShort(len, this._currentOffset + 2);
        this._currentOffset += 4 + len;
    }

    protected void _addBinaryOpt(int option, byte[] optionValue) {
        int len = optionValue.length;
        this.putByte(option, this._currentOffset);
        this.putByte(DataType.BSTRING.getTypeCode(), this._currentOffset + 1);
        this.putShort(optionValue.length, this._currentOffset + 2);
        this.putBytes(optionValue, this._currentOffset + 4);
        this._currentOffset += 4 + len;
    }
}

