/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.type;

import com.singlestore.jdbc.type.Point;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LineString {
    private final Point[] points;
    private static final Pattern linePattern = Pattern.compile("^LINESTRING\\((.*)\\)$");

    public LineString(String s) throws IllegalArgumentException {
        Matcher m = linePattern.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException();
        }
        String[] pointStrings = m.group(1).split(",");
        this.points = LineString.parsePoints(pointStrings);
    }

    private static Point[] parsePoints(String[] pointStrings) {
        Point[] points = new Point[pointStrings.length];
        for (int i = 0; i < pointStrings.length; ++i) {
            String[] coords = pointStrings[i].trim().split(" ");
            points[i] = new Point(Double.parseDouble(coords[0]), Double.parseDouble(coords[1]));
        }
        return points;
    }

    public LineString(Point[] points) {
        this.points = points;
    }

    public Point[] getPoints() {
        return this.points;
    }

    public static LineString FromRingString(String pointsString) throws IllegalArgumentException {
        if (pointsString.length() <= 2) {
            throw new IllegalArgumentException(String.format("Failed to decode '%s' as LineString", pointsString));
        }
        if (pointsString.charAt(0) == '(' && pointsString.charAt(pointsString.length() - 1) == ')') {
            pointsString = pointsString.substring(1, pointsString.length() - 1);
        }
        return new LineString(LineString.parsePoints(pointsString.split(",")));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LINESTRING(");
        int index = 0;
        for (Point pt : this.points) {
            if (index++ > 0) {
                sb.append(",");
            }
            sb.append(pt.getX()).append(" ").append(pt.getY());
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LineString)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return Arrays.hashCode(this.points);
    }
}

