/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc;

import com.singlestore.jdbc.CallableParameterMetaData;
import com.singlestore.jdbc.ClientPreparedStatement;
import com.singlestore.jdbc.Connection;
import com.singlestore.jdbc.ServerPreparedStatement;
import com.singlestore.jdbc.client.util.ClosableLock;
import com.singlestore.jdbc.export.ExceptionFactory;
import com.singlestore.jdbc.util.NativeSql;
import com.singlestore.jdbc.util.ParameterList;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public abstract class BaseCallableStatement
extends ServerPreparedStatement
implements CallableStatement {
    private static final String OUT_PARAMETERS_NOT_SUPPORTED_MSG = "SingleStore doesn't support OUT parameters";
    protected final String databaseName;
    protected final String procedureName;
    protected CallableParameterMetaData parameterMetaData = null;

    public BaseCallableStatement(String sql, Connection con, ClosableLock lock, String databaseName, String procedureName, boolean canCachePrepStmts, int resultSetType, int resultSetConcurrency, int defaultFetchSize) throws SQLException {
        super(sql, con, lock, canCachePrepStmts, 1, resultSetType, resultSetConcurrency, defaultFetchSize);
        this.databaseName = databaseName;
        this.procedureName = procedureName;
    }

    public abstract boolean isFunction();

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkNotClosed();
        this.parameters = new ParameterList();
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public boolean wasNull() throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        throw this.exceptionFactory().notSupported("Method ResultSet.getRef not supported");
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    private int nameToIndex(String parameterName) throws SQLException {
        if (parameterName == null) {
            throw this.exceptionFactory().create("parameter name cannot be null");
        }
        if (this.parameterMetaData == null) {
            this.parameterMetaData = this.getParameterMetaData();
        }
        int count = this.parameterMetaData.getParameterCount();
        for (int i = 1; i <= count; ++i) {
            String name = this.parameterMetaData.getParameterName(i);
            if (name == null || !name.equalsIgnoreCase(parameterName)) continue;
            return i;
        }
        throw this.exceptionFactory().create(String.format("parameter name %s not found", parameterName));
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        this.setURL(this.nameToIndex(parameterName), val);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNull(this.nameToIndex(parameterName), sqlType);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setBoolean(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.setByte(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.setShort(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.setInt(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.setLong(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.setFloat(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.setDouble(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setBigDecimal(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.setString(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setBytes(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.setDate(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.setTime(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setTimestamp(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setAsciiStream(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setBinaryStream(this.nameToIndex(parameterName), x, length);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setCharacterStream(this.nameToIndex(parameterName), reader, length);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setDate(this.nameToIndex(parameterName), x, cal);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setTime(this.nameToIndex(parameterName), x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(this.nameToIndex(parameterName), x, cal);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setNull(this.nameToIndex(parameterName), sqlType, typeName);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw this.exceptionFactory().notSupported("Method ResultSet.getRef not supported");
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        throw this.exceptionFactory().notSupported("Method ResultSet.getArray not supported");
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        throw this.exceptionFactory().notSupported("RowId are not supported");
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw this.exceptionFactory().notSupported("RowId are not supported");
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw this.exceptionFactory().notSupported("RowId parameter are not supported");
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.setNString(this.nameToIndex(parameterName), value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.setNCharacterStream(this.nameToIndex(parameterName), value, length);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.setNClob(this.nameToIndex(parameterName), value);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setClob(this.nameToIndex(parameterName), reader, length);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.setBlob(this.nameToIndex(parameterName), inputStream, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setNClob(this.nameToIndex(parameterName), reader, length);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return this.getNClob(this.nameToIndex(parameterName));
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw this.exceptionFactory().notSupported("SQLXML parameter are not supported");
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw this.exceptionFactory().notSupported("SQLXML are not supported");
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw this.exceptionFactory().notSupported("SQLXML are not supported");
    }

    private ExceptionFactory exceptionFactory() {
        return this.con.getExceptionFactory().of(this);
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return this.getNString(this.nameToIndex(parameterName));
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.getNCharacterStream(this.nameToIndex(parameterName));
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return this.getNCharacterStream(this.nameToIndex(parameterName));
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.setBlob(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        this.setClob(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setAsciiStream(this.nameToIndex(parameterName), x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setBinaryStream(this.nameToIndex(parameterName), x, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.setCharacterStream(this.nameToIndex(parameterName), reader, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.setAsciiStream(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.setBinaryStream(this.nameToIndex(parameterName), x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.setCharacterStream(this.nameToIndex(parameterName), reader);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.setNCharacterStream(this.nameToIndex(parameterName), value);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.setClob(this.nameToIndex(parameterName), reader);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.setBlob(this.nameToIndex(parameterName), inputStream);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.setNClob(this.nameToIndex(parameterName), reader);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException(OUT_PARAMETERS_NOT_SUPPORTED_MSG);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return this.getObject(this.nameToIndex(parameterName), type);
    }

    @Override
    public void setObject(String parameterName, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setObject(String parameterName, Object x, SQLType targetSqlType) throws SQLException {
        this.setObject(this.nameToIndex(parameterName), x, targetSqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex, 0);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        this.registerOutParameter(this.nameToIndex(parameterName), sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        this.registerOutParameter(this.nameToIndex(parameterName), sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        this.registerOutParameter(this.nameToIndex(parameterName), sqlType);
    }

    @Override
    public CallableParameterMetaData getParameterMetaData() throws SQLException {
        String sql = "SELECT PARAMETER_NAME, PARAMETER_MODE, DATA_TYPE, CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION, NUMERIC_SCALE, CHARACTER_SET_NAME, DTD_IDENTIFIER from information_schema.parameters WHERE SPECIFIC_NAME = ? and SPECIFIC_SCHEMA = ?";
        ClientPreparedStatement prep = new ClientPreparedStatement(NativeSql.parse(sql, this.con.getContext()), this.con, this.lock, 2, 1003, 1007, 0);
        prep.setString(1, this.procedureName);
        prep.setString(2, this.databaseName);
        prep.setString(3, this.procedureName);
        prep.setString(4, this.databaseName);
        ResultSet rs = prep.executeQuery();
        this.parameterMetaData = new CallableParameterMetaData(rs);
        return this.parameterMetaData;
    }
}

