/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc;

import com.singlestore.jdbc.Driver;
import com.singlestore.jdbc.HostAddress;
import com.singlestore.jdbc.TransactionIsolation;
import com.singlestore.jdbc.export.HaMode;
import com.singlestore.jdbc.export.SslMode;
import com.singlestore.jdbc.plugin.Codec;
import com.singlestore.jdbc.plugin.CredentialPlugin;
import com.singlestore.jdbc.plugin.credential.CredentialPluginLoader;
import com.singlestore.jdbc.util.log.Loggers;
import com.singlestore.jdbc.util.options.OptionAliases;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;

public class Configuration {
    private static final Set<String> EXCLUDED_FIELDS = new HashSet<String>();
    private static final Set<String> SECURE_FIELDS;
    private static final Set<String> PROPERTIES_TO_SKIP;
    private static final Set<String> SENSITIVE_FIELDS;
    private String user;
    private String password;
    private String database;
    private List<HostAddress> addresses;
    private HaMode haMode;
    private String initialUrl;
    private Properties nonMappedOptions;
    private Boolean autocommit;
    private boolean useMysqlMetadata;
    private boolean useMysqlVersion;
    private boolean nullDatabaseMeansCurrent;
    private boolean createDatabaseIfNotExist;
    private String initSql;
    private TransactionIsolation transactionIsolation;
    private int defaultFetchSize;
    private Integer maxAllowedPacket;
    private String geometryDefaultType;
    private String restrictedAuth;
    private String socketFactory;
    private int connectTimeout;
    private String pipe;
    private String localSocket;
    private boolean tcpKeepAlive;
    private int tcpKeepIdle;
    private int tcpKeepCount;
    private int tcpKeepInterval;
    private boolean tcpAbortiveClose;
    private String localSocketAddress;
    private int socketTimeout;
    private boolean useReadAheadInput;
    private String tlsSocketType;
    private SslMode sslMode;
    private String serverSslCert;
    private String trustStore;
    private String trustStorePassword;
    private String trustStoreType;
    private String keyStore;
    private String keyStorePassword;
    private String keyPassword;
    private String keyStoreType;
    private String enabledSslCipherSuites;
    private String enabledSslProtocolSuites;
    private boolean allowMultiQueries;
    private boolean allowLocalInfile;
    private boolean useCompression;
    private boolean useAffectedRows;
    private boolean disablePipeline;
    private boolean cachePrepStmts;
    private int prepStmtCacheSize;
    private boolean useServerPrepStmts;
    private boolean rewriteBatchedStatements;
    private CredentialPlugin credentialType;
    private String sessionVariables;
    private String connectionAttributes;
    private String servicePrincipalName;
    private String jaasApplicationName;
    private boolean blankTableNameMeta;
    private boolean tinyInt1isBit;
    private boolean transformedBitIsBoolean;
    private boolean yearIsDateType;
    private boolean dumpQueriesOnException;
    private boolean includeThreadDumpInDeadlockExceptions;
    private int retriesAllDown;
    private boolean transactionReplay;
    private int transactionReplaySize;
    private boolean pool;
    private String poolName;
    private int maxPoolSize;
    private int minPoolSize;
    private int maxIdleTime;
    private boolean registerJmxPool;
    private int poolValidMinDelay;
    private boolean useResetConnection;
    private int maxQuerySizeToLog;
    private String consoleLogLevel;
    private String consoleLogFilepath;
    private boolean printStackTrace;
    private Integer maxPrintStackSizeToLog;
    private boolean enableExtendedDataTypes;
    private String vectorTypeOutputFormat;
    private boolean vectorExtendedMetadata;
    private Codec<?>[] codecs;

    private Configuration(Builder builder) {
        try {
            this.initializeBasicConfig(builder);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.initializeSslConfig(builder);
        this.initializeSocketConfig(builder);
        this.initializeTransactionConfig(builder);
        this.initializeDataTypeConfig(builder);
        this.initializeQueryConfig(builder);
        this.initializePipelineConfig(builder);
        this.initializeDatabaseConfig(builder);
        this.initializeExceptionConfig(builder);
        this.initializePoolConfig(builder);
        this.initializeLoggingConfig(builder);
        this.initializeExtendedTypesConfig(builder);
        this.initializeAdditionalConfig(builder);
        this.validateConfiguration();
    }

    private void initializeBasicConfig(Builder builder) throws SQLException {
        this.database = builder.database;
        this.addresses = builder._addresses;
        this.nonMappedOptions = builder._nonMappedOptions;
        this.haMode = builder._haMode != null ? builder._haMode : HaMode.NONE;
        this.credentialType = CredentialPluginLoader.get(builder.credentialType);
        this.user = builder.user;
        this.password = builder.password;
    }

    private void initializeSslConfig(Builder builder) {
        this.enabledSslProtocolSuites = builder.enabledSslProtocolSuites;
        this.serverSslCert = builder.serverSslCert;
        this.keyStore = builder.keyStore;
        this.trustStore = builder.trustStore;
        this.keyStorePassword = builder.keyStorePassword;
        this.trustStorePassword = builder.trustStorePassword;
        this.keyPassword = builder.keyPassword;
        this.keyStoreType = builder.keyStoreType;
        this.trustStoreType = builder.trustStoreType;
        if (this.credentialType != null && this.credentialType.mustUseSsl() && (builder.sslMode == null || SslMode.from(builder.sslMode) == SslMode.DISABLE)) {
            Loggers.getLogger(Configuration.class).warn("Credential type '" + this.credentialType.type() + "' is required to be used with SSL. Enabling SSL.");
            this.sslMode = SslMode.VERIFY_FULL;
        } else {
            this.sslMode = builder.sslMode != null ? SslMode.from(builder.sslMode) : SslMode.DISABLE;
        }
    }

    private void initializeSocketConfig(Builder builder) {
        this.socketFactory = builder.socketFactory;
        this.connectTimeout = builder.connectTimeout != null ? builder.connectTimeout : (DriverManager.getLoginTimeout() > 0 ? DriverManager.getLoginTimeout() * 1000 : 30000);
        this.pipe = builder.pipe;
        this.localSocket = builder.localSocket;
        this.tcpKeepAlive = builder.tcpKeepAlive == null || builder.tcpKeepAlive != false;
        this.tcpKeepIdle = builder.tcpKeepIdle != null ? builder.tcpKeepIdle : 0;
        this.tcpKeepCount = builder.tcpKeepCount != null ? builder.tcpKeepCount : 0;
        this.tcpKeepInterval = builder.tcpKeepInterval != null ? builder.tcpKeepInterval : 0;
        this.tcpAbortiveClose = builder.tcpAbortiveClose != null && builder.tcpAbortiveClose != false;
        this.localSocketAddress = builder.localSocketAddress;
        this.socketTimeout = builder.socketTimeout != null ? builder.socketTimeout : 0;
        this.useReadAheadInput = builder.useReadAheadInput != null && builder.useReadAheadInput != false;
        this.tlsSocketType = builder.tlsSocketType;
        this.useCompression = builder.useCompression != null && builder.useCompression != false;
    }

    private void initializeTransactionConfig(Builder builder) {
        if (builder.transactionIsolation != null && TransactionIsolation.from(builder.transactionIsolation) != TransactionIsolation.READ_COMMITTED) {
            throw new IllegalArgumentException("Currently, the 'Read Committed' is the only isolation level that is supported in SingleStore.");
        }
        this.transactionIsolation = TransactionIsolation.READ_COMMITTED;
        this.enabledSslCipherSuites = builder.enabledSslCipherSuites;
        this.sessionVariables = builder.sessionVariables;
    }

    private void initializeDataTypeConfig(Builder builder) {
        this.tinyInt1isBit = builder.tinyInt1isBit == null || builder.tinyInt1isBit != false;
        this.transformedBitIsBoolean = builder.transformedBitIsBoolean != null && builder.transformedBitIsBoolean != false;
        this.yearIsDateType = builder.yearIsDateType == null || builder.yearIsDateType != false;
    }

    private void initializeQueryConfig(Builder builder) {
        this.dumpQueriesOnException = builder.dumpQueriesOnException != null && builder.dumpQueriesOnException != false;
        this.prepStmtCacheSize = builder.prepStmtCacheSize != null ? builder.prepStmtCacheSize : 250;
        this.useAffectedRows = builder.useAffectedRows != null && builder.useAffectedRows != false;
        this.useServerPrepStmts = builder.useServerPrepStmts != null && builder.useServerPrepStmts != false;
        this.rewriteBatchedStatements = builder.rewriteBatchedStatements != null && builder.rewriteBatchedStatements != false;
        this.connectionAttributes = builder.connectionAttributes;
        this.allowLocalInfile = builder.allowLocalInfile == null || builder.allowLocalInfile != false;
        this.allowMultiQueries = builder.allowMultiQueries != null && builder.allowMultiQueries != false;
    }

    private void initializePipelineConfig(Builder builder) {
        this.disablePipeline = builder.disablePipeline != null && builder.disablePipeline != false;
        this.autocommit = builder.autocommit;
        this.useMysqlMetadata = builder.useMysqlMetadata != null && builder.useMysqlMetadata != false;
        this.useMysqlVersion = builder.useMysqlVersion != null && builder.useMysqlVersion != false;
        this.nullDatabaseMeansCurrent = builder.nullDatabaseMeansCurrent != null && builder.nullDatabaseMeansCurrent != false;
    }

    private void initializeDatabaseConfig(Builder builder) {
        this.createDatabaseIfNotExist = builder.createDatabaseIfNotExist != null && builder.createDatabaseIfNotExist != false;
        this.blankTableNameMeta = builder.blankTableNameMeta != null && builder.blankTableNameMeta != false;
    }

    private void initializeExceptionConfig(Builder builder) {
        this.includeThreadDumpInDeadlockExceptions = builder.includeThreadDumpInDeadlockExceptions != null && builder.includeThreadDumpInDeadlockExceptions != false;
    }

    private void initializePoolConfig(Builder builder) {
        this.pool = builder.pool != null && builder.pool != false;
        this.poolName = builder.poolName;
        this.maxPoolSize = builder.maxPoolSize != null ? builder.maxPoolSize : 8;
        int n = this.minPoolSize = builder.minPoolSize != null ? builder.minPoolSize : this.maxPoolSize;
        if (builder.maxIdleTime != null) {
            if (builder.maxIdleTime < 2) {
                throw new IllegalArgumentException(String.format("Wrong argument value '%d' for maxIdleTime, must be >= 2", builder.maxIdleTime));
            }
            this.maxIdleTime = builder.maxIdleTime;
        } else {
            this.maxIdleTime = 600000;
        }
        this.registerJmxPool = builder.registerJmxPool == null || builder.registerJmxPool != false;
        this.poolValidMinDelay = builder.poolValidMinDelay != null ? builder.poolValidMinDelay : 1000;
        this.useResetConnection = builder.useResetConnection != null && builder.useResetConnection != false;
    }

    private void initializeLoggingConfig(Builder builder) {
        this.maxQuerySizeToLog = builder.maxQuerySizeToLog != null ? builder.maxQuerySizeToLog : 1024;
        this.consoleLogLevel = builder.consoleLogLevel;
        this.consoleLogFilepath = builder.consoleLogFilepath;
        this.printStackTrace = builder.printStackTrace != null && builder.printStackTrace != false;
        this.maxPrintStackSizeToLog = builder.maxPrintStackSizeToLog != null ? builder.maxPrintStackSizeToLog : 10;
    }

    private void initializeExtendedTypesConfig(Builder builder) {
        boolean bl = this.enableExtendedDataTypes = builder.enableExtendedDataTypes != null && builder.enableExtendedDataTypes != false;
        if (builder.vectorTypeOutputFormat != null) {
            String format = builder.vectorTypeOutputFormat.toUpperCase().trim();
            if (!"JSON".equals(format) && !"BINARY".equals(format)) {
                throw new IllegalArgumentException("Invalid 'vectorTypeOutputFormat' parameter: '" + format + "'. Expected values are 'JSON' or 'BINARY'.");
            }
            this.vectorTypeOutputFormat = format;
        }
        this.vectorExtendedMetadata = builder.vectorExtendedMetadata != null && builder.vectorExtendedMetadata != false;
    }

    private void initializeAdditionalConfig(Builder builder) {
        this.servicePrincipalName = builder.servicePrincipalName;
        this.jaasApplicationName = builder.jaasApplicationName;
        this.defaultFetchSize = builder.defaultFetchSize != null ? builder.defaultFetchSize : 0;
        this.tlsSocketType = builder.tlsSocketType;
        this.maxAllowedPacket = builder.maxAllowedPacket;
        this.retriesAllDown = builder.retriesAllDown != null ? builder.retriesAllDown : 120;
        this.cachePrepStmts = builder.cachePrepStmts == null || builder.cachePrepStmts != false;
        this.transactionReplay = builder.transactionReplay != null && builder.transactionReplay != false;
        this.transactionReplaySize = builder.transactionReplaySize != null ? builder.transactionReplaySize : 64;
        this.geometryDefaultType = builder.geometryDefaultType;
        this.restrictedAuth = builder.restrictedAuth;
        this.initSql = builder.initSql;
        this.codecs = null;
    }

    private void validateConfiguration() {
        this.validateIntegerFields();
    }

    private void validateIntegerFields() {
        Field[] fields = Configuration.class.getDeclaredFields();
        try {
            for (Field field : fields) {
                int val;
                if (!field.getType().equals(Integer.TYPE) || (val = field.getInt(this)) >= 0) continue;
                throw new IllegalArgumentException(String.format("Value for %s must be >= 1 (value is %s)", field.getName(), val));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public Builder toBuilder() {
        Builder builder = new Builder().user(this.user).password(this.password).database(this.database).addresses(this.addresses == null ? null : this.addresses.toArray(new HostAddress[0])).haMode(this.haMode).autocommit(this.autocommit).useMysqlMetadata(this.useMysqlMetadata).useMysqlVersion(this.useMysqlVersion).nullDatabaseMeansCurrent(this.nullDatabaseMeansCurrent).createDatabaseIfNotExist(this.createDatabaseIfNotExist).transactionIsolation(this.transactionIsolation == null ? null : this.transactionIsolation.getValue()).defaultFetchSize(this.defaultFetchSize).maxQuerySizeToLog(this.maxQuerySizeToLog).maxAllowedPacket(this.maxAllowedPacket).geometryDefaultType(this.geometryDefaultType).geometryDefaultType(this.geometryDefaultType).restrictedAuth(this.restrictedAuth).initSql(this.initSql).socketFactory(this.socketFactory).connectTimeout(this.connectTimeout).pipe(this.pipe).localSocket(this.localSocket).tcpKeepAlive(this.tcpKeepAlive).tcpKeepIdle(this.tcpKeepIdle).tcpKeepCount(this.tcpKeepCount).tcpKeepInterval(this.tcpKeepInterval).tcpAbortiveClose(this.tcpAbortiveClose).localSocketAddress(this.localSocketAddress).socketTimeout(this.socketTimeout).useReadAheadInput(this.useReadAheadInput).tlsSocketType(this.tlsSocketType).sslMode(this.sslMode.name()).serverSslCert(this.serverSslCert).keyStore(this.keyStore).trustStore(this.trustStore).keyStoreType(this.keyStoreType).keyStorePassword(this.keyStorePassword).trustStorePassword(this.trustStorePassword).keyPassword(this.keyPassword).trustStoreType(this.trustStoreType).enabledSslCipherSuites(this.enabledSslCipherSuites).enabledSslProtocolSuites(this.enabledSslProtocolSuites).allowMultiQueries(this.allowMultiQueries).allowLocalInfile(this.allowLocalInfile).useCompression(this.useCompression).useAffectedRows(this.useAffectedRows).rewriteBatchedStatements(this.rewriteBatchedStatements).disablePipeline(this.disablePipeline).cachePrepStmts(this.cachePrepStmts).prepStmtCacheSize(this.prepStmtCacheSize).useServerPrepStmts(this.useServerPrepStmts).credentialType(this.credentialType == null ? null : this.credentialType.type()).sessionVariables(this.sessionVariables).connectionAttributes(this.connectionAttributes).servicePrincipalName(this.servicePrincipalName).jaasApplicationName(this.jaasApplicationName).blankTableNameMeta(this.blankTableNameMeta).tinyInt1isBit(this.tinyInt1isBit).transformedBitIsBoolean(this.transformedBitIsBoolean).yearIsDateType(this.yearIsDateType).dumpQueriesOnException(this.dumpQueriesOnException).includeThreadDumpInDeadlockExceptions(this.includeThreadDumpInDeadlockExceptions).retriesAllDown(this.retriesAllDown).transactionReplay(this.transactionReplay).transactionReplaySize(this.transactionReplaySize).pool(this.pool).poolName(this.poolName).maxPoolSize(this.maxPoolSize).minPoolSize(this.minPoolSize).maxIdleTime(this.maxIdleTime).registerJmxPool(this.registerJmxPool).poolValidMinDelay(this.poolValidMinDelay).useResetConnection(this.useResetConnection).consoleLogLevel(this.consoleLogLevel).consoleLogFilepath(this.consoleLogFilepath).printStackTrace(this.printStackTrace).maxPrintStackSizeToLog(this.maxPrintStackSizeToLog).enableExtendedDataTypes(this.enableExtendedDataTypes).vectorTypeOutputFormat(this.vectorTypeOutputFormat).vectorExtendedMetadata(this.vectorExtendedMetadata);
        builder._nonMappedOptions = this.nonMappedOptions;
        return builder;
    }

    public static boolean acceptsUrl(String url) {
        return url != null && url.startsWith("jdbc:singlestore:");
    }

    public static Configuration parse(String url) throws SQLException {
        return Configuration.parse(url, new Properties());
    }

    public static Configuration parse(String url, Properties prop) throws SQLException {
        if (Configuration.acceptsUrl(url)) {
            return Configuration.parseInternal(url, prop == null ? new Properties() : prop);
        }
        return null;
    }

    private static Configuration parseInternal(String url, Properties properties) throws SQLException {
        try {
            String additionalParameters;
            String hostAddressesString;
            Builder builder = new Builder();
            Configuration.validateUrlFormat(url);
            int separator = url.indexOf("//");
            builder.haMode(Configuration.parseHaMode(url, separator));
            String urlSecondPart = url.substring(separator + 2);
            int posToSkip = Configuration.skipComplexAddresses(urlSecondPart);
            int dbIndex = urlSecondPart.indexOf("/", posToSkip);
            int paramIndex = urlSecondPart.indexOf("?");
            if (dbIndex < paramIndex && dbIndex < 0 || dbIndex > paramIndex && paramIndex > -1) {
                hostAddressesString = urlSecondPart.substring(0, paramIndex);
                additionalParameters = urlSecondPart.substring(paramIndex);
            } else if (dbIndex < paramIndex || dbIndex > paramIndex) {
                hostAddressesString = urlSecondPart.substring(0, dbIndex);
                additionalParameters = urlSecondPart.substring(dbIndex);
            } else {
                hostAddressesString = urlSecondPart;
                additionalParameters = null;
            }
            if (additionalParameters != null) {
                Configuration.processDatabaseAndParameters(additionalParameters, builder, properties);
            } else {
                builder.database(null);
            }
            Configuration.mapPropertiesToOption(builder, properties);
            builder._addresses = HostAddress.parse(hostAddressesString, builder._haMode);
            return builder.build();
        }
        catch (IllegalArgumentException i) {
            throw new SQLException("error parsing url: " + i.getMessage(), i);
        }
    }

    private static void validateUrlFormat(String url) {
        int separator = url.indexOf("//");
        if (separator == -1) {
            throw new IllegalArgumentException("url parsing error : '//' is not present in the url " + url);
        }
    }

    private static int skipComplexAddresses(String urlSecondPart) {
        int skipPos;
        int posToSkip = 0;
        while ((skipPos = urlSecondPart.indexOf("address=(", posToSkip)) > -1) {
            int endingBraceIndex;
            posToSkip = urlSecondPart.indexOf(")", skipPos) + 1;
            while (urlSecondPart.startsWith("(", posToSkip) && (endingBraceIndex = urlSecondPart.indexOf(")", posToSkip)) != -1) {
                posToSkip = endingBraceIndex + 1;
            }
        }
        return posToSkip;
    }

    private static void processDatabaseAndParameters(String additionalParameters, Builder builder, Properties properties) {
        String database;
        int optIndex = additionalParameters.indexOf("?");
        if (optIndex < 0) {
            database = additionalParameters.length() > 1 ? additionalParameters.substring(1) : null;
        } else {
            database = Configuration.extractDatabase(additionalParameters, optIndex);
            Configuration.processUrlParameters(additionalParameters.substring(optIndex + 1), properties);
        }
        builder.database(database);
    }

    private static String extractDatabase(String additionalParameters, int optIndex) {
        if (optIndex == 0) {
            return null;
        }
        String database = additionalParameters.substring(1, optIndex);
        return database.isEmpty() ? null : database;
    }

    private static void processUrlParameters(String urlParameters, Properties properties) {
        if (!urlParameters.isEmpty()) {
            String[] parameters;
            for (String parameter : parameters = urlParameters.split("&")) {
                int pos = parameter.indexOf(61);
                if (pos == -1) {
                    properties.setProperty(parameter, "");
                    continue;
                }
                properties.setProperty(parameter.substring(0, pos), parameter.substring(pos + 1));
            }
        }
    }

    private static void mapPropertiesToOption(Builder builder, Properties properties) {
        Properties nonMappedOptions = new Properties();
        try {
            Configuration.processProperties(builder, properties, nonMappedOptions);
            Configuration.handleLegacySslSettings(builder, nonMappedOptions);
            builder._nonMappedOptions = nonMappedOptions;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Unexpected error while mapping properties", e);
        }
    }

    private static void processProperties(Builder builder, Properties properties, Properties nonMappedOptions) throws ReflectiveOperationException {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String realKey = Configuration.getRealKey(entry.getKey().toString());
            Object propertyValue = entry.getValue();
            if (propertyValue == null) continue;
            Configuration.processProperty(builder, realKey, propertyValue, entry.getKey(), nonMappedOptions);
        }
    }

    private static String getRealKey(String key) {
        String lowercaseKey = key.toLowerCase(Locale.ROOT);
        String realKey = OptionAliases.OPTIONS_ALIASES.get(lowercaseKey);
        return realKey != null ? realKey : key;
    }

    private static void processProperty(Builder builder, String realKey, Object propertyValue, Object originalKey, Properties nonMappedOptions) throws ReflectiveOperationException {
        boolean used = false;
        for (Field field : Builder.class.getDeclaredFields()) {
            if (!realKey.toLowerCase(Locale.ROOT).equals(field.getName().toLowerCase(Locale.ROOT))) continue;
            used = true;
            Configuration.setFieldValue(builder, field, propertyValue, originalKey);
        }
        if (!used) {
            nonMappedOptions.put(realKey, propertyValue);
        }
    }

    private static void setFieldValue(Builder builder, Field field, Object propertyValue, Object originalKey) throws ReflectiveOperationException {
        if (field.getGenericType().equals(String.class)) {
            Configuration.handleStringField(builder, field, propertyValue);
        } else if (field.getGenericType().equals(Boolean.class)) {
            Configuration.handleBooleanField(builder, field, propertyValue, originalKey);
        } else if (field.getGenericType().equals(Integer.class)) {
            Configuration.handleIntegerField(builder, field, propertyValue, originalKey);
        }
    }

    private static void handleStringField(Builder builder, Field field, Object value) throws ReflectiveOperationException {
        String stringValue = value.toString();
        if (!stringValue.isEmpty()) {
            Method method = Builder.class.getDeclaredMethod(field.getName(), String.class);
            method.invoke((Object)builder, stringValue);
        }
    }

    private static void handleBooleanField(Builder builder, Field field, Object value, Object originalKey) throws ReflectiveOperationException {
        Method method = Builder.class.getDeclaredMethod(field.getName(), Boolean.class);
        switch (value.toString().toLowerCase()) {
            case "": 
            case "1": 
            case "true": {
                method.invoke((Object)builder, Boolean.TRUE);
                break;
            }
            case "0": 
            case "false": {
                method.invoke((Object)builder, Boolean.FALSE);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Optional parameter %s must be boolean (true/false or 0/1) was '%s'", originalKey, value));
            }
        }
    }

    private static void handleIntegerField(Builder builder, Field field, Object value, Object originalKey) throws ReflectiveOperationException {
        try {
            Method method = Builder.class.getDeclaredMethod(field.getName(), Integer.class);
            Integer intValue = Integer.parseInt(value.toString());
            method.invoke((Object)builder, intValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Optional parameter %s must be Integer, was '%s'", originalKey, value));
        }
    }

    private static void handleLegacySslSettings(Builder builder, Properties nonMappedOptions) {
        if (Configuration.isSet("useSsl", nonMappedOptions) || Configuration.isSet("useSSL", nonMappedOptions)) {
            Properties deprecatedDesc = new Properties();
            try (InputStream inputStream = Driver.class.getClassLoader().getResourceAsStream("deprecated.properties");){
                deprecatedDesc.load(inputStream);
                Loggers.getLogger(Configuration.class).warn(deprecatedDesc.getProperty("useSsl"));
                if (Configuration.isSet("trustServerCertificate", nonMappedOptions)) {
                    builder.sslMode("trust");
                    Loggers.getLogger(Configuration.class).warn(deprecatedDesc.getProperty("trustServerCertificate"));
                } else if (Configuration.isSet("disableSslHostnameVerification", nonMappedOptions)) {
                    Loggers.getLogger(Configuration.class).warn(deprecatedDesc.getProperty("disableSslHostnameVerification"));
                    builder.sslMode("verify-ca");
                } else {
                    builder.sslMode("verify-full");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static boolean isSet(String key, Properties nonMappedOptions) {
        String value = nonMappedOptions.getProperty(key);
        return value != null && (value.equals("1") || value.equals("true") || value.isEmpty());
    }

    private static HaMode parseHaMode(String url, int separator) {
        int firstColonPos = url.indexOf(58);
        int secondColonPos = url.indexOf(58, firstColonPos + 1);
        int thirdColonPos = url.indexOf(58, secondColonPos + 1);
        if (thirdColonPos > separator || thirdColonPos == -1) {
            if (secondColonPos == separator - 1) {
                return HaMode.NONE;
            }
            thirdColonPos = separator;
        }
        try {
            String haModeString = url.substring(secondColonPos + 1, thirdColonPos);
            if ("FAILOVER".equalsIgnoreCase(haModeString)) {
                haModeString = "LOADBALANCE";
            }
            return HaMode.from(haModeString);
        }
        catch (IllegalArgumentException i) {
            throw new IllegalArgumentException("wrong failover parameter format in connection String " + url);
        }
    }

    public static String toConf(String url) throws SQLException {
        Configuration conf = Configuration.parseInternal(url, new Properties());
        Configuration defaultConf = Configuration.parse("jdbc:singlestore://localhost/");
        StringBuilder result = new StringBuilder();
        Configuration.appendBasicConfiguration(result, conf);
        Configuration.appendUnknownOptions(result, conf);
        Configuration.appendNonDefaultOptions(result, conf, defaultConf);
        Configuration.appendDefaultOptions(result, conf, defaultConf);
        return result.toString();
    }

    private static void appendBasicConfiguration(StringBuilder sb, Configuration conf) {
        sb.append("Configuration:\n * resulting Url : ").append(conf.initialUrl);
    }

    private static void appendUnknownOptions(StringBuilder sb, Configuration conf) {
        sb.append("\nUnknown options : ");
        if (conf.nonMappedOptions.isEmpty()) {
            sb.append("None\n");
            return;
        }
        conf.nonMappedOptions.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, String>(entry.getKey().toString(), entry.getValue() != null ? entry.getValue().toString() : "")).sorted(Map.Entry.comparingByKey()).forEach(entry -> sb.append("\n * ").append((String)entry.getKey()).append(" : ").append((String)entry.getValue()));
        sb.append("\n");
    }

    private static void appendNonDefaultOptions(StringBuilder sb, Configuration conf, Configuration defaultConf) {
        try {
            StringBuilder diffOpts = new StringBuilder();
            Configuration.processFields(conf, defaultConf, new StringBuilder(), diffOpts);
            sb.append("\nNon default options : ");
            if (diffOpts.length() == 0) {
                sb.append("None\n");
            } else {
                sb.append((CharSequence)diffOpts);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Error processing non-default options", e);
        }
    }

    private static void appendDefaultOptions(StringBuilder sb, Configuration conf, Configuration defaultConf) {
        try {
            StringBuilder defaultOpts = new StringBuilder();
            Configuration.processFields(conf, defaultConf, defaultOpts, new StringBuilder());
            sb.append("\n\ndefault options :");
            if (defaultOpts.length() == 0) {
                sb.append("None\n");
            } else {
                sb.append((CharSequence)defaultOpts);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Error processing default options", e);
        }
    }

    private static void processFields(Configuration conf, Configuration defaultConf, StringBuilder defaultOpts, StringBuilder diffOpts) throws IllegalAccessException {
        Field[] fields = Configuration.class.getDeclaredFields();
        Arrays.sort(fields, Comparator.comparing(Field::getName));
        for (Field field : fields) {
            if (PROPERTIES_TO_SKIP.contains(field.getName())) continue;
            Object fieldValue = field.get(conf);
            Object defaultValue = field.get(defaultConf);
            Configuration.processField(field, fieldValue, defaultValue, defaultOpts, diffOpts);
        }
    }

    private static void processField(Field field, Object fieldValue, Object defaultValue, StringBuilder defaultOpts, StringBuilder diffOpts) {
        String typeName;
        if (fieldValue == null) {
            Configuration.appendNullField(field, defaultValue, defaultOpts, diffOpts);
            return;
        }
        if (field.getName().equals("haMode")) {
            Configuration.appendHaModeField(field, fieldValue, defaultValue, defaultOpts, diffOpts);
            return;
        }
        switch (typeName = fieldValue.getClass().getSimpleName()) {
            case "String": 
            case "Boolean": 
            case "HaMode": 
            case "TransactionIsolation": 
            case "Integer": 
            case "SslMode": {
                Configuration.appendSimpleField(field, fieldValue, defaultValue, defaultOpts, diffOpts);
                break;
            }
            case "ArrayList": {
                Configuration.appendListField(field, fieldValue, defaultValue, defaultOpts, diffOpts);
                break;
            }
            case "Properties": 
            case "HashSet": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected field type for: " + field.getName());
            }
        }
    }

    private static void appendNullField(Field field, Object defaultValue, StringBuilder defaultOpts, StringBuilder diffOpts) {
        StringBuilder target = defaultValue == null ? defaultOpts : diffOpts;
        target.append("\n * ").append(field.getName()).append(" : null");
    }

    private static void appendHaModeField(Field field, Object fieldValue, Object defaultValue, StringBuilder defaultOpts, StringBuilder diffOpts) {
        StringBuilder target = Objects.equals(fieldValue, defaultValue) ? defaultOpts : diffOpts;
        target.append("\n * ").append(field.getName()).append(" : ").append(fieldValue);
    }

    private static void appendSimpleField(Field field, Object fieldValue, Object defaultValue, StringBuilder defaultOpts, StringBuilder diffOpts) {
        StringBuilder target = Objects.equals(fieldValue, defaultValue) ? defaultOpts : diffOpts;
        target.append("\n * ").append(field.getName()).append(" : ");
        if (SENSITIVE_FIELDS.contains(field.getName())) {
            target.append("***");
        } else {
            target.append(fieldValue);
        }
    }

    private static void appendListField(Field field, Object fieldValue, Object defaultValue, StringBuilder defaultOpts, StringBuilder diffOpts) {
        StringBuilder target = Objects.equals(fieldValue.toString(), defaultValue.toString()) ? defaultOpts : diffOpts;
        target.append("\n * ").append(field.getName()).append(" : ").append(fieldValue);
    }

    public Configuration clone(String username, String password) {
        return this.toBuilder().user((String)(username != null && username.isEmpty() ? null : username)).password((String)(password != null && password.isEmpty() ? null : password)).build();
    }

    public String database() {
        return this.database;
    }

    public List<HostAddress> addresses() {
        return this.addresses;
    }

    public HaMode haMode() {
        return this.haMode;
    }

    public CredentialPlugin credentialPlugin() {
        return this.credentialType;
    }

    public String user() {
        return this.user;
    }

    public String password() {
        return this.password;
    }

    public String initialUrl() {
        return this.initialUrl;
    }

    public String serverSslCert() {
        return this.serverSslCert;
    }

    public String trustStore() {
        return this.trustStore;
    }

    public String trustStorePassword() {
        return this.trustStorePassword;
    }

    public String trustStoreType() {
        return this.trustStoreType;
    }

    public String keyStore() {
        return this.keyStore;
    }

    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    public String keyPassword() {
        return this.keyPassword;
    }

    public String keyStoreType() {
        return this.keyStoreType;
    }

    public String enabledSslProtocolSuites() {
        return this.enabledSslProtocolSuites;
    }

    public String socketFactory() {
        return this.socketFactory;
    }

    public int connectTimeout() {
        return this.connectTimeout;
    }

    public Configuration connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public String pipe() {
        return this.pipe;
    }

    public String localSocket() {
        return this.localSocket;
    }

    public boolean tcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public int tcpKeepIdle() {
        return this.tcpKeepIdle;
    }

    public int tcpKeepCount() {
        return this.tcpKeepCount;
    }

    public int tcpKeepInterval() {
        return this.tcpKeepInterval;
    }

    public boolean tcpAbortiveClose() {
        return this.tcpAbortiveClose;
    }

    public String localSocketAddress() {
        return this.localSocketAddress;
    }

    public int socketTimeout() {
        return this.socketTimeout;
    }

    public boolean allowMultiQueries() {
        return this.allowMultiQueries;
    }

    public boolean allowLocalInfile() {
        return this.allowLocalInfile;
    }

    public boolean useCompression() {
        return this.useCompression;
    }

    public boolean blankTableNameMeta() {
        return this.blankTableNameMeta;
    }

    public SslMode sslMode() {
        return this.sslMode;
    }

    public TransactionIsolation transactionIsolation() {
        return this.transactionIsolation;
    }

    public String enabledSslCipherSuites() {
        return this.enabledSslCipherSuites;
    }

    public String sessionVariables() {
        return this.sessionVariables;
    }

    public boolean tinyInt1isBit() {
        return this.tinyInt1isBit;
    }

    public boolean transformedBitIsBoolean() {
        return this.transformedBitIsBoolean;
    }

    public boolean yearIsDateType() {
        return this.yearIsDateType;
    }

    public boolean dumpQueriesOnException() {
        return this.dumpQueriesOnException;
    }

    public int prepStmtCacheSize() {
        return this.prepStmtCacheSize;
    }

    public boolean useAffectedRows() {
        return this.useAffectedRows;
    }

    public boolean disablePipeline() {
        return this.disablePipeline;
    }

    public boolean useServerPrepStmts() {
        return this.useServerPrepStmts;
    }

    public String connectionAttributes() {
        return this.connectionAttributes;
    }

    public Boolean autocommit() {
        return this.autocommit;
    }

    public boolean nullDatabaseMeansCurrent() {
        return this.nullDatabaseMeansCurrent;
    }

    public boolean includeThreadDumpInDeadlockExceptions() {
        return this.includeThreadDumpInDeadlockExceptions;
    }

    public boolean createDatabaseIfNotExist() {
        return this.createDatabaseIfNotExist;
    }

    public String initSql() {
        return this.initSql;
    }

    public String servicePrincipalName() {
        return this.servicePrincipalName;
    }

    public String jaasApplicationName() {
        return this.jaasApplicationName;
    }

    public int defaultFetchSize() {
        return this.defaultFetchSize;
    }

    public Properties nonMappedOptions() {
        return this.nonMappedOptions;
    }

    public String tlsSocketType() {
        return this.tlsSocketType;
    }

    public int maxQuerySizeToLog() {
        return this.maxQuerySizeToLog;
    }

    public Integer maxAllowedPacket() {
        return this.maxAllowedPacket;
    }

    public int retriesAllDown() {
        return this.retriesAllDown;
    }

    public boolean pool() {
        return this.pool;
    }

    public String poolName() {
        return this.poolName;
    }

    public int maxPoolSize() {
        return this.maxPoolSize;
    }

    public int minPoolSize() {
        return this.minPoolSize;
    }

    public int maxIdleTime() {
        return this.maxIdleTime;
    }

    public boolean registerJmxPool() {
        return this.registerJmxPool;
    }

    public int poolValidMinDelay() {
        return this.poolValidMinDelay;
    }

    public boolean useResetConnection() {
        return this.useResetConnection;
    }

    public boolean useReadAheadInput() {
        return this.useReadAheadInput;
    }

    public boolean cachePrepStmts() {
        return this.cachePrepStmts;
    }

    public boolean transactionReplay() {
        return this.transactionReplay;
    }

    public int transactionReplaySize() {
        return this.transactionReplaySize;
    }

    public String geometryDefaultType() {
        return this.geometryDefaultType;
    }

    public String restrictedAuth() {
        return this.restrictedAuth;
    }

    public Codec<?>[] codecs() {
        return this.codecs;
    }

    public boolean useMysqlVersion() {
        return this.useMysqlVersion;
    }

    public boolean useMysqlMetadata() {
        return this.useMysqlMetadata;
    }

    public boolean rewriteBatchedStatements() {
        return this.rewriteBatchedStatements;
    }

    public String getConsoleLogLevel() {
        return this.consoleLogLevel;
    }

    public String getConsoleLogFilepath() {
        return this.consoleLogFilepath;
    }

    public boolean printStackTrace() {
        return this.printStackTrace;
    }

    public int maxPrintStackSizeToLog() {
        return this.maxPrintStackSizeToLog;
    }

    public boolean enableExtendedDataTypes() {
        return this.enableExtendedDataTypes;
    }

    public String vectorTypeOutputFormat() {
        return this.vectorTypeOutputFormat;
    }

    public boolean vectorExtendedMetadata() {
        return this.vectorExtendedMetadata;
    }

    public String toString() {
        return this.initialUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        return this.initialUrl.equals(that.initialUrl);
    }

    protected static String buildUrl(Configuration conf) {
        try {
            StringBuilder urlBuilder = new StringBuilder("jdbc:singlestore:");
            Configuration.appendHaModeIfPresent(urlBuilder, conf);
            Configuration.appendHostAddresses(urlBuilder, conf);
            Configuration.appendDatabase(urlBuilder, conf);
            Configuration.appendConfigurationParameters(urlBuilder, conf);
            conf.loadCodecs();
            conf.resetLoggerFactory();
            return urlBuilder.toString();
        }
        catch (SecurityException s) {
            throw new IllegalArgumentException("Security too restrictive: " + s.getMessage());
        }
    }

    private static void appendHostAddresses(StringBuilder sb, Configuration conf) {
        sb.append("//");
        for (int i = 0; i < conf.addresses.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            Configuration.appendHostAddress(sb, conf.addresses.get(i), i);
        }
        sb.append("/");
    }

    private static void appendHostAddress(StringBuilder sb, HostAddress hostAddress, int index) {
        if (index < 1) {
            sb.append(hostAddress.host);
            if (hostAddress.port != 3306) {
                sb.append(":").append(hostAddress.port);
            }
        } else {
            sb.append(hostAddress);
        }
    }

    private static void appendDatabase(StringBuilder sb, Configuration conf) {
        if (conf.database != null) {
            sb.append(conf.database);
        }
    }

    private static void appendHaModeIfPresent(StringBuilder sb, Configuration conf) {
        if (conf.haMode != HaMode.NONE) {
            sb.append(conf.haMode.toString().toLowerCase(Locale.ROOT).replace("_", "-")).append(":");
        }
    }

    private static void appendConfigurationParameters(StringBuilder sb, Configuration conf) {
        try {
            Configuration defaultConf = new Configuration(new Builder());
            ParameterAppender paramAppender = new ParameterAppender(sb);
            for (Field field : Configuration.class.getDeclaredFields()) {
                Object value;
                if (EXCLUDED_FIELDS.contains(field.getName()) || (value = field.get(conf)) == null || value instanceof Properties && ((Properties)value).isEmpty()) continue;
                Configuration.appendFieldParameter(paramAppender, field, value, defaultConf);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void appendFieldParameter(ParameterAppender appender, Field field, Object value, Configuration defaultConf) throws IllegalAccessException {
        if (SECURE_FIELDS.contains(field.getName())) {
            appender.appendParameter(field.getName(), "***");
            return;
        }
        Class<?> fieldType = field.getType();
        if (fieldType.equals(String.class)) {
            Configuration.appendStringParameter(appender, field, value, defaultConf);
        } else if (fieldType.equals(Boolean.TYPE)) {
            Configuration.appendBooleanParameter(appender, field, value, defaultConf);
        } else if (fieldType.equals(Integer.TYPE)) {
            Configuration.appendIntParameter(appender, field, value, defaultConf);
        } else if (fieldType.equals(Properties.class)) {
            Configuration.appendPropertiesParameter(appender, (Properties)value);
        } else if (fieldType.equals(CredentialPlugin.class)) {
            Configuration.appendCredentialPluginParameter(appender, field, value, defaultConf);
        } else {
            Configuration.appendDefaultParameter(appender, field, value, defaultConf);
        }
    }

    private static void appendStringParameter(ParameterAppender appender, Field field, Object value, Configuration defaultConf) throws IllegalAccessException {
        String defaultValue = (String)field.get(defaultConf);
        if (!value.equals(defaultValue)) {
            appender.appendParameter(field.getName(), (String)value);
        }
    }

    private static void appendBooleanParameter(ParameterAppender appender, Field field, Object value, Configuration defaultConf) throws IllegalAccessException {
        boolean defaultValue = field.getBoolean(defaultConf);
        if (!value.equals(defaultValue)) {
            appender.appendParameter(field.getName(), value.toString());
        }
    }

    private static void appendIntParameter(ParameterAppender appender, Field field, Object value, Configuration defaultConf) {
        try {
            int defaultValue = field.getInt(defaultConf);
            if (!value.equals(defaultValue)) {
                appender.appendParameter(field.getName(), value.toString());
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static void appendPropertiesParameter(ParameterAppender appender, Properties props) {
        for (Object key : props.keySet()) {
            appender.appendParameter(key.toString(), props.get(key).toString());
        }
    }

    private static void appendCredentialPluginParameter(ParameterAppender appender, Field field, Object value, Configuration defaultConf) throws IllegalAccessException {
        Object defaultValue = field.get(defaultConf);
        if (!value.equals(defaultValue)) {
            appender.appendParameter(field.getName(), ((CredentialPlugin)value).type());
        }
    }

    private static void appendDefaultParameter(ParameterAppender appender, Field field, Object value, Configuration defaultConf) throws IllegalAccessException {
        Object defaultValue = field.get(defaultConf);
        if (!value.equals(defaultValue)) {
            appender.appendParameter(field.getName(), value.toString());
        }
    }

    private void loadCodecs() {
        ServiceLoader<Codec> loader = ServiceLoader.load(Codec.class, Configuration.class.getClassLoader());
        ArrayList result = new ArrayList();
        loader.iterator().forEachRemaining(result::add);
        this.codecs = result.toArray(new Codec[0]);
    }

    private void resetLoggerFactory() {
        Loggers.resetLoggerFactoryProperties(this.consoleLogLevel, this.consoleLogFilepath, this.printStackTrace, this.maxPrintStackSizeToLog);
    }

    public int hashCode() {
        return this.initialUrl.hashCode();
    }

    private static String nullOrEmpty(String val) {
        return val == null || val.isEmpty() ? null : val;
    }

    static {
        EXCLUDED_FIELDS.add("database");
        EXCLUDED_FIELDS.add("haMode");
        EXCLUDED_FIELDS.add("$jacocoData");
        EXCLUDED_FIELDS.add("addresses");
        EXCLUDED_FIELDS.add("transactionIsolation");
        SECURE_FIELDS = new HashSet<String>();
        SECURE_FIELDS.add("password");
        SECURE_FIELDS.add("keyStorePassword");
        SECURE_FIELDS.add("trustStorePassword");
        PROPERTIES_TO_SKIP = new HashSet<String>();
        PROPERTIES_TO_SKIP.add("initialUrl");
        PROPERTIES_TO_SKIP.add("logger");
        PROPERTIES_TO_SKIP.add("codecs");
        PROPERTIES_TO_SKIP.add("$jacocoData");
        SENSITIVE_FIELDS = new HashSet<String>();
        SENSITIVE_FIELDS.add("password");
        SENSITIVE_FIELDS.add("keyStorePassword");
        SENSITIVE_FIELDS.add("trustStorePassword");
    }

    public static final class Builder
    implements Cloneable {
        private Properties _nonMappedOptions;
        private HaMode _haMode;
        private List<HostAddress> _addresses = new ArrayList<HostAddress>();
        private String user;
        private String password;
        private String database;
        private Boolean autocommit;
        private Boolean useMysqlMetadata;
        private Boolean useMysqlVersion;
        private Boolean nullDatabaseMeansCurrent;
        private Boolean createDatabaseIfNotExist;
        private String initSql;
        private Integer defaultFetchSize;
        private Integer maxQuerySizeToLog;
        private Integer maxAllowedPacket;
        private String geometryDefaultType;
        private String restrictedAuth;
        private String transactionIsolation;
        private String socketFactory;
        private Integer connectTimeout;
        private String pipe;
        private String localSocket;
        private Boolean tcpKeepAlive;
        private Integer tcpKeepIdle;
        private Integer tcpKeepCount;
        private Integer tcpKeepInterval;
        private Boolean tcpAbortiveClose;
        private String localSocketAddress;
        private Integer socketTimeout;
        private Boolean useReadAheadInput;
        private String tlsSocketType;
        private String sslMode;
        private String serverSslCert;
        private String trustStore;
        private String trustStorePassword;
        private String trustStoreType;
        private String keyStore;
        private String keyStorePassword;
        private String keyPassword;
        private String keyStoreType;
        private String enabledSslCipherSuites;
        private String enabledSslProtocolSuites;
        private Boolean allowMultiQueries;
        private Boolean allowLocalInfile;
        private Boolean useCompression;
        private Boolean useAffectedRows;
        private Boolean disablePipeline;
        private Boolean cachePrepStmts;
        private Integer prepStmtCacheSize;
        private Boolean useServerPrepStmts;
        private String credentialType;
        private String sessionVariables;
        private String connectionAttributes;
        private String servicePrincipalName;
        private String jaasApplicationName;
        private Boolean blankTableNameMeta;
        private Boolean tinyInt1isBit;
        private Boolean transformedBitIsBoolean;
        private Boolean yearIsDateType;
        private Boolean dumpQueriesOnException;
        private Boolean includeThreadDumpInDeadlockExceptions;
        private Integer retriesAllDown;
        private Boolean transactionReplay;
        private Integer transactionReplaySize;
        private Boolean pool;
        private String poolName;
        private Integer maxPoolSize;
        private Integer minPoolSize;
        private Integer maxIdleTime;
        private Boolean registerJmxPool;
        private Integer poolValidMinDelay;
        private Boolean useResetConnection;
        private Boolean rewriteBatchedStatements;
        private String consoleLogLevel;
        private String consoleLogFilepath;
        private Boolean printStackTrace;
        private Integer maxPrintStackSizeToLog;
        private Boolean enableExtendedDataTypes;
        private String vectorTypeOutputFormat;
        private Boolean vectorExtendedMetadata;

        public Builder user(String user) {
            this.user = Configuration.nullOrEmpty(user);
            return this;
        }

        public Builder serverSslCert(String serverSslCert) {
            this.serverSslCert = Configuration.nullOrEmpty(serverSslCert);
            return this;
        }

        public Builder trustStore(String trustStore) {
            this.trustStore = Configuration.nullOrEmpty(trustStore);
            return this;
        }

        public Builder trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = Configuration.nullOrEmpty(trustStorePassword);
            return this;
        }

        public Builder trustStoreType(String trustStoreType) {
            this.trustStoreType = Configuration.nullOrEmpty(trustStoreType);
            return this;
        }

        public Builder keyStore(String keyStore) {
            this.keyStore = Configuration.nullOrEmpty(keyStore);
            return this;
        }

        public Builder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = Configuration.nullOrEmpty(keyStorePassword);
            return this;
        }

        public Builder keyPassword(String keyPassword) {
            this.keyPassword = Configuration.nullOrEmpty(keyPassword);
            return this;
        }

        public Builder keyStoreType(String keyStoreType) {
            this.keyStoreType = Configuration.nullOrEmpty(keyStoreType);
            return this;
        }

        public Builder password(String password) {
            this.password = Configuration.nullOrEmpty(password);
            return this;
        }

        public Builder enabledSslProtocolSuites(String enabledSslProtocolSuites) {
            this.enabledSslProtocolSuites = Configuration.nullOrEmpty(enabledSslProtocolSuites);
            return this;
        }

        public Builder database(String database) {
            this.database = database;
            return this;
        }

        public Builder haMode(HaMode haMode) {
            this._haMode = haMode;
            return this;
        }

        public Builder addHost(String host, int port) {
            this._addresses.add(HostAddress.from(Configuration.nullOrEmpty(host), port));
            return this;
        }

        public Builder addresses(HostAddress ... hostAddress) {
            this._addresses = new ArrayList<HostAddress>();
            this._addresses.addAll(Arrays.asList(hostAddress));
            return this;
        }

        public Builder socketFactory(String socketFactory) {
            this.socketFactory = socketFactory;
            return this;
        }

        public Builder connectTimeout(Integer connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder pipe(String pipe) {
            this.pipe = Configuration.nullOrEmpty(pipe);
            return this;
        }

        public Builder localSocket(String localSocket) {
            this.localSocket = Configuration.nullOrEmpty(localSocket);
            return this;
        }

        public Builder tcpKeepAlive(Boolean tcpKeepAlive) {
            this.tcpKeepAlive = tcpKeepAlive;
            return this;
        }

        public Builder tcpKeepIdle(Integer tcpKeepIdle) {
            this.tcpKeepIdle = tcpKeepIdle;
            return this;
        }

        public Builder tcpKeepCount(Integer tcpKeepCount) {
            this.tcpKeepCount = tcpKeepCount;
            return this;
        }

        public Builder tcpKeepInterval(Integer tcpKeepInterval) {
            this.tcpKeepInterval = tcpKeepInterval;
            return this;
        }

        public Builder tcpAbortiveClose(Boolean tcpAbortiveClose) {
            this.tcpAbortiveClose = tcpAbortiveClose;
            return this;
        }

        public Builder geometryDefaultType(String geometryDefault) {
            this.geometryDefaultType = Configuration.nullOrEmpty(geometryDefault);
            return this;
        }

        public Builder restrictedAuth(String restrictedAuth) {
            this.restrictedAuth = restrictedAuth;
            return this;
        }

        public Builder localSocketAddress(String localSocketAddress) {
            this.localSocketAddress = Configuration.nullOrEmpty(localSocketAddress);
            return this;
        }

        public Builder socketTimeout(Integer socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder allowMultiQueries(Boolean allowMultiQueries) {
            this.allowMultiQueries = allowMultiQueries;
            return this;
        }

        public Builder allowLocalInfile(Boolean allowLocalInfile) {
            this.allowLocalInfile = allowLocalInfile;
            return this;
        }

        public Builder useCompression(Boolean useCompression) {
            this.useCompression = useCompression;
            return this;
        }

        public Builder blankTableNameMeta(Boolean blankTableNameMeta) {
            this.blankTableNameMeta = blankTableNameMeta;
            return this;
        }

        public Builder credentialType(String credentialType) {
            this.credentialType = Configuration.nullOrEmpty(credentialType);
            return this;
        }

        public Builder sslMode(String sslMode) {
            this.sslMode = sslMode;
            return this;
        }

        public Builder transactionIsolation(String transactionIsolation) {
            this.transactionIsolation = Configuration.nullOrEmpty(transactionIsolation);
            return this;
        }

        public Builder enabledSslCipherSuites(String enabledSslCipherSuites) {
            this.enabledSslCipherSuites = Configuration.nullOrEmpty(enabledSslCipherSuites);
            return this;
        }

        public Builder sessionVariables(String sessionVariables) {
            this.sessionVariables = Configuration.nullOrEmpty(sessionVariables);
            return this;
        }

        public Builder tinyInt1isBit(Boolean tinyInt1isBit) {
            this.tinyInt1isBit = tinyInt1isBit;
            return this;
        }

        public Builder transformedBitIsBoolean(Boolean transformedBitIsBoolean) {
            this.transformedBitIsBoolean = transformedBitIsBoolean;
            return this;
        }

        public Builder yearIsDateType(Boolean yearIsDateType) {
            this.yearIsDateType = yearIsDateType;
            return this;
        }

        public Builder dumpQueriesOnException(Boolean dumpQueriesOnException) {
            this.dumpQueriesOnException = dumpQueriesOnException;
            return this;
        }

        public Builder prepStmtCacheSize(Integer prepStmtCacheSize) {
            this.prepStmtCacheSize = prepStmtCacheSize;
            return this;
        }

        public Builder useAffectedRows(Boolean useAffectedRows) {
            this.useAffectedRows = useAffectedRows;
            return this;
        }

        public Builder disablePipeline(Boolean disablePipeline) {
            this.disablePipeline = disablePipeline;
            return this;
        }

        public Builder useServerPrepStmts(Boolean useServerPrepStmts) {
            this.useServerPrepStmts = useServerPrepStmts;
            return this;
        }

        public Builder autocommit(Boolean autocommit) {
            this.autocommit = autocommit;
            return this;
        }

        public Builder useMysqlMetadata(Boolean useMysqlMetadata) {
            this.useMysqlMetadata = useMysqlMetadata;
            return this;
        }

        public Builder nullDatabaseMeansCurrent(Boolean nullDatabaseMeansCurrent) {
            this.nullDatabaseMeansCurrent = nullDatabaseMeansCurrent;
            return this;
        }

        public Builder createDatabaseIfNotExist(Boolean createDatabaseIfNotExist) {
            this.createDatabaseIfNotExist = createDatabaseIfNotExist;
            return this;
        }

        public Builder initSql(String initSql) {
            this.initSql = initSql;
            return this;
        }

        public Builder connectionAttributes(String connectionAttributes) {
            this.connectionAttributes = Configuration.nullOrEmpty(connectionAttributes);
            return this;
        }

        public Builder includeThreadDumpInDeadlockExceptions(Boolean includeThreadDumpInDeadlockExceptions) {
            this.includeThreadDumpInDeadlockExceptions = includeThreadDumpInDeadlockExceptions;
            return this;
        }

        public Builder servicePrincipalName(String servicePrincipalName) {
            this.servicePrincipalName = Configuration.nullOrEmpty(servicePrincipalName);
            return this;
        }

        public Builder jaasApplicationName(String jaasApplicationName) {
            this.jaasApplicationName = Configuration.nullOrEmpty(jaasApplicationName);
            return this;
        }

        public Builder defaultFetchSize(Integer defaultFetchSize) {
            this.defaultFetchSize = defaultFetchSize;
            return this;
        }

        public Builder tlsSocketType(String tlsSocketType) {
            this.tlsSocketType = Configuration.nullOrEmpty(tlsSocketType);
            return this;
        }

        public Builder maxQuerySizeToLog(Integer maxQuerySizeToLog) {
            this.maxQuerySizeToLog = maxQuerySizeToLog;
            return this;
        }

        public Builder maxAllowedPacket(Integer maxAllowedPacket) {
            this.maxAllowedPacket = maxAllowedPacket;
            return this;
        }

        public Builder retriesAllDown(Integer retriesAllDown) {
            this.retriesAllDown = retriesAllDown;
            return this;
        }

        public Builder pool(Boolean pool) {
            this.pool = pool;
            return this;
        }

        public Builder poolName(String poolName) {
            this.poolName = Configuration.nullOrEmpty(poolName);
            return this;
        }

        public Builder maxPoolSize(Integer maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            return this;
        }

        public Builder minPoolSize(Integer minPoolSize) {
            this.minPoolSize = minPoolSize;
            return this;
        }

        public Builder maxIdleTime(Integer maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
            return this;
        }

        public Builder registerJmxPool(Boolean registerJmxPool) {
            this.registerJmxPool = registerJmxPool;
            return this;
        }

        public Builder poolValidMinDelay(Integer poolValidMinDelay) {
            this.poolValidMinDelay = poolValidMinDelay;
            return this;
        }

        public Builder useResetConnection(Boolean useResetConnection) {
            this.useResetConnection = useResetConnection;
            return this;
        }

        public Builder useReadAheadInput(Boolean useReadAheadInput) {
            this.useReadAheadInput = useReadAheadInput;
            return this;
        }

        public Builder cachePrepStmts(Boolean cachePrepStmts) {
            this.cachePrepStmts = cachePrepStmts;
            return this;
        }

        public Builder transactionReplay(Boolean transactionReplay) {
            this.transactionReplay = transactionReplay;
            return this;
        }

        public Builder transactionReplaySize(Integer transactionReplaySize) {
            this.transactionReplaySize = transactionReplaySize;
            return this;
        }

        public Builder useMysqlVersion(Boolean useMysqlVersion) {
            this.useMysqlVersion = useMysqlVersion;
            return this;
        }

        public Builder rewriteBatchedStatements(Boolean rewriteBatchedStatements) {
            this.rewriteBatchedStatements = rewriteBatchedStatements;
            return this;
        }

        public Builder consoleLogLevel(String consoleLogLevel) {
            this.consoleLogLevel = consoleLogLevel;
            return this;
        }

        public Builder consoleLogFilepath(String consoleLogFilepath) {
            this.consoleLogFilepath = consoleLogFilepath;
            return this;
        }

        public Builder printStackTrace(Boolean printStackTrace) {
            this.printStackTrace = printStackTrace;
            return this;
        }

        public Builder maxPrintStackSizeToLog(Integer maxPrintStackSizeToLog) {
            this.maxPrintStackSizeToLog = maxPrintStackSizeToLog;
            return this;
        }

        public Builder enableExtendedDataTypes(Boolean enableExtendedDataTypes) {
            this.enableExtendedDataTypes = enableExtendedDataTypes;
            return this;
        }

        public Builder vectorTypeOutputFormat(String vectorTypeOutputFormat) {
            this.vectorTypeOutputFormat = vectorTypeOutputFormat;
            return this;
        }

        public Builder vectorExtendedMetadata(Boolean vectorExtendedMetadata) {
            this.vectorExtendedMetadata = vectorExtendedMetadata;
            return this;
        }

        public Configuration build() {
            Configuration conf = new Configuration(this);
            conf.initialUrl = Configuration.buildUrl(conf);
            return conf;
        }
    }

    private static class ParameterAppender {
        private final StringBuilder sb;
        private boolean first = true;

        ParameterAppender(StringBuilder sb) {
            this.sb = sb;
        }

        void appendParameter(String name, String value) {
            this.sb.append(this.first ? (char)'?' : '&').append(name).append('=').append(value);
            this.first = false;
        }
    }
}

