/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc;

import com.singlestore.jdbc.ClientPreparedStatement;
import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.DatabaseMetaData;
import com.singlestore.jdbc.FunctionStatement;
import com.singlestore.jdbc.HostAddress;
import com.singlestore.jdbc.ProcedureStatement;
import com.singlestore.jdbc.ServerPreparedStatement;
import com.singlestore.jdbc.SingleStoreBlob;
import com.singlestore.jdbc.SingleStoreClob;
import com.singlestore.jdbc.SingleStorePoolConnection;
import com.singlestore.jdbc.Statement;
import com.singlestore.jdbc.client.Client;
import com.singlestore.jdbc.client.Context;
import com.singlestore.jdbc.client.impl.StandardClient;
import com.singlestore.jdbc.client.util.ClosableLock;
import com.singlestore.jdbc.export.ExceptionFactory;
import com.singlestore.jdbc.message.client.ChangeDbPacket;
import com.singlestore.jdbc.message.client.PingPacket;
import com.singlestore.jdbc.message.client.QueryPacket;
import com.singlestore.jdbc.message.client.ResetPacket;
import com.singlestore.jdbc.plugin.array.FloatArray;
import com.singlestore.jdbc.util.NativeSql;
import com.singlestore.jdbc.util.timeout.QueryTimeoutHandler;
import com.singlestore.jdbc.util.timeout.QueryTimeoutHandlerImpl;
import java.math.BigInteger;
import java.nio.FloatBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.ConnectionEvent;

public class Connection
implements java.sql.Connection {
    private static final Pattern CALLABLE_STATEMENT_PATTERN = Pattern.compile("^(\\s*\\{)?\\s*((\\?\\s*=)?(\\s*/\\*([^*]|\\*[^/])*\\*/)*\\s*call(\\s*/\\*([^*]|\\*[^/])*\\*/)*\\s*((((`[^`]+`)|([^`\\}]+))\\.)?((`[^`]+`)|([^`\\}(]+)))\\s*(\\(.*\\))?(\\s*/\\*([^*]|\\*[^/])*\\*/)*\\s*(#.*)?)\\s*(\\}\\s*)?$", 34);
    private final ClosableLock lock;
    private final Configuration conf;
    private ExceptionFactory exceptionFactory;
    private final Client client;
    private final Properties clientInfo = new Properties();
    private Boolean tableNameCaseSensitivity;
    private boolean readOnly;
    private final boolean canCachePrepStmts;
    private final int defaultFetchSize;
    private SingleStorePoolConnection poolConnection;
    private final boolean forceTransactionEnd;
    private long sqlSelectLimit;
    private QueryTimeoutHandler queryTimeoutHandler;

    public Connection(Configuration conf, ClosableLock lock, Client client) {
        this.conf = conf;
        this.forceTransactionEnd = Boolean.parseBoolean(conf.nonMappedOptions().getProperty("forceTransactionEnd", "false"));
        this.lock = lock;
        this.exceptionFactory = client.getExceptionFactory().setConnection(this);
        this.client = client;
        Context context = this.client.getContext();
        this.sqlSelectLimit = client.getInitialSqlSelectLimit() == null ? 0L : client.getInitialSqlSelectLimit().longValue();
        this.canCachePrepStmts = context.getConf().cachePrepStmts();
        this.defaultFetchSize = context.getConf().defaultFetchSize();
        this.queryTimeoutHandler = new QueryTimeoutHandlerImpl(this, lock);
    }

    public void setPoolConnection(SingleStorePoolConnection poolConnection) {
        this.poolConnection = poolConnection;
        this.exceptionFactory = this.exceptionFactory.setPoolConnection(poolConnection);
    }

    public void cancelCurrentQuery() throws SQLException {
        String currentIp = this.client.getSocketIp();
        HostAddress hostAddress = currentIp == null ? this.client.getHostAddress() : HostAddress.from(currentIp, this.client.getHostAddress().port);
        try (StandardClient cli = new StandardClient(this.conf, hostAddress, new ClosableLock(), true);){
            BigInteger aggregatorId = this.client.getAggregatorId();
            String killQuery = String.format("KILL QUERY %d %d", this.client.getContext().getThreadId(), aggregatorId);
            cli.execute(new QueryPacket(killQuery), false);
        }
    }

    public void setSqlSelectLimit(long maxRows) throws SQLException {
        if (maxRows < 0L) {
            throw this.exceptionFactory.create("sql_select_limit cannot be negative : asked for " + maxRows, "42000");
        }
        String setSelectLimitQuery = String.format("set sql_select_limit=%d", maxRows);
        this.client.execute(new QueryPacket(setSelectLimitQuery), false);
        this.sqlSelectLimit = maxRows;
    }

    public long getSqlSelectLimit() {
        return this.sqlSelectLimit;
    }

    @Override
    public Statement createStatement() {
        return new Statement(this, this.lock, 1, 1003, 1007, this.defaultFetchSize);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareInternal(sql, 2, 1003, 1007, this.conf.useServerPrepStmts());
    }

    public PreparedStatement prepareInternal(String sql, int autoGeneratedKeys, int resultSetType, int resultSetConcurrency, boolean useBinary) throws SQLException {
        this.checkNotClosed();
        if (useBinary && !sql.startsWith("/*client prepare*/")) {
            try {
                return new ServerPreparedStatement(NativeSql.parse(sql, this.client.getContext()), this, this.lock, this.canCachePrepStmts, autoGeneratedKeys, resultSetType, resultSetConcurrency, this.defaultFetchSize);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return new ClientPreparedStatement(NativeSql.parse(sql, this.client.getContext()), this, this.lock, autoGeneratedKeys, resultSetType, resultSetConcurrency, this.defaultFetchSize);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return NativeSql.parse(sql, this.client.getContext());
    }

    @Override
    public boolean getAutoCommit() {
        return (this.client.getContext().getServerStatus() & 2) > 0;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit == this.getAutoCommit()) {
            return;
        }
        try (ClosableLock ignore = this.lock.closeableLock();){
            this.getContext().addStateFlag(8);
            this.client.execute(new QueryPacket("set autocommit=" + (autoCommit ? "true" : "false")), true);
        }
    }

    @Override
    public void commit() throws SQLException {
        try (ClosableLock ignore = this.lock.closeableLock();){
            if ((this.client.getContext().getServerStatus() & 1) > 0) {
                this.client.execute(new QueryPacket("COMMIT"), false);
            }
        }
    }

    @Override
    public void rollback() throws SQLException {
        try (ClosableLock ignore = this.lock.closeableLock();){
            if (this.forceTransactionEnd || (this.client.getContext().getServerStatus() & 1) > 0) {
                this.client.execute(new QueryPacket("ROLLBACK"), false);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.poolConnection != null) {
            this.poolConnection.fireConnectionClosed(new ConnectionEvent(this.poolConnection));
            return;
        }
        this.client.close();
    }

    @Override
    public boolean isClosed() {
        return this.client.isClosed();
    }

    public Context getContext() {
        return this.client.getContext();
    }

    public boolean getTableNameCaseSensitivity() throws SQLException {
        block14: {
            if (this.tableNameCaseSensitivity == null) {
                if (this.getMetaData().getSingleStoreVersion().versionGreaterOrEqual(7, 0, 11)) {
                    try (Statement st = this.createStatement();
                         ResultSet rs = st.executeQuery("select @@table_name_case_sensitivity");){
                        rs.next();
                        this.tableNameCaseSensitivity = rs.getBoolean(1);
                        break block14;
                    }
                }
                this.tableNameCaseSensitivity = Boolean.TRUE;
            }
        }
        return this.tableNameCaseSensitivity;
    }

    @Override
    public DatabaseMetaData getMetaData() {
        return new DatabaseMetaData(this, this.conf);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try (ClosableLock ignore = this.lock.closeableLock();){
            if (this.readOnly != readOnly) {
                this.client.setReadOnly(readOnly);
            }
            this.readOnly = readOnly;
            this.getContext().addStateFlag(4);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        if (this.client.getContext().hasServerCapability(0x800000L)) {
            return this.client.getContext().getDatabase();
        }
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select database()");
        rs.next();
        this.client.getContext().setDatabase(rs.getString(1));
        return this.client.getContext().getDatabase();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (catalog == null || this.client.getContext().hasClientCapability(0x800000L) && catalog.equals(this.client.getContext().getDatabase())) {
            return;
        }
        try (ClosableLock ignore = this.lock.closeableLock();){
            this.getContext().addStateFlag(2);
            this.client.execute(new ChangeDbPacket(catalog), true);
            this.client.getContext().setDatabase(catalog);
        }
    }

    @Override
    public int getTransactionIsolation() {
        return 2;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        String query = "SET SESSION TRANSACTION ISOLATION LEVEL";
        if (level != 2) {
            throw new SQLException("Unsupported transaction isolation level");
        }
        query = query + " READ COMMITTED";
        try (ClosableLock ignore = this.lock.closeableLock();){
            this.checkNotClosed();
            this.getContext().addStateFlag(16);
            this.client.getContext().setTransactionIsolationLevel(level);
            this.client.execute(new QueryPacket(query), true);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        if (this.client.getContext().getWarning() == 0) {
            return null;
        }
        SQLWarning last = null;
        SQLWarning first = null;
        try (Statement st = this.createStatement();
             ResultSet rs = st.executeQuery("show warnings");){
            while (rs.next()) {
                int code = rs.getInt(2);
                String message = rs.getString(3);
                SQLWarning warning = new SQLWarning(message, null, code);
                if (first == null) {
                    first = warning;
                } else {
                    last.setNextWarning(warning);
                }
                last = warning;
            }
        }
        return first;
    }

    @Override
    public void clearWarnings() {
        this.client.getContext().setWarning(0);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkNotClosed();
        return new Statement(this, this.lock, 1, resultSetType, resultSetConcurrency, this.defaultFetchSize);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareInternal(sql, 1, resultSetType, resultSetConcurrency, this.conf.useServerPrepStmts());
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkNotClosed();
        Matcher matcher = CALLABLE_STATEMENT_PATTERN.matcher(sql);
        if (!matcher.matches()) {
            throw new SQLSyntaxErrorException("invalid callable syntax. must be like {[?=]call <procedure/function name>[(?,?, ...)]}\n but was : " + sql);
        }
        String query = NativeSql.parse(matcher.group(2), this.client.getContext());
        boolean isFunction = matcher.group(3) != null;
        String databaseAndProcedure = matcher.group(8);
        String database = matcher.group(10);
        String procedureName = matcher.group(13);
        String arguments = matcher.group(16);
        if (database == null) {
            database = this.getCatalog();
        }
        if (isFunction) {
            return new FunctionStatement(this, database, databaseAndProcedure, arguments == null ? "()" : arguments, this.lock, this.canCachePrepStmts, resultSetType, resultSetConcurrency);
        }
        return new ProcedureStatement(this, query, database, procedureName, this.lock, this.canCachePrepStmts, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return new HashMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw this.exceptionFactory.notSupported("TypeMap are not supported");
    }

    @Override
    public int getHoldability() {
        return 1;
    }

    @Override
    public void setHoldability(int holdability) {
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkNotClosed();
        return new Statement(this, this.lock, 2, resultSetType, resultSetConcurrency, this.defaultFetchSize);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareInternal(sql, autoGeneratedKeys, 1003, 1007, this.conf.useServerPrepStmts());
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql, 1);
    }

    @Override
    public Clob createClob() {
        return new SingleStoreClob();
    }

    @Override
    public Blob createBlob() {
        return new SingleStoreBlob();
    }

    @Override
    public NClob createNClob() {
        return new SingleStoreClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw this.exceptionFactory.notSupported("SQLXML type is not supported");
    }

    private void checkNotClosed() throws SQLException {
        if (this.client.isClosed()) {
            throw this.exceptionFactory.create("Connection is closed", "08000", 1220);
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw this.exceptionFactory.create("the value supplied for timeout is negative");
        }
        ClosableLock ignore = this.lock.closeableLock();
        try {
            this.client.execute(PingPacket.INSTANCE, true);
            boolean bl = true;
            if (ignore != null) {
                ignore.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (ignore != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException sqle) {
                return false;
            }
        }
    }

    @Override
    public void setClientInfo(String name, String value) {
        this.clientInfo.put(name, value);
    }

    @Override
    public String getClientInfo(String name) {
        return (String)this.clientInfo.get(name);
    }

    @Override
    public Properties getClientInfo() {
        return this.clientInfo;
    }

    @Override
    public void setClientInfo(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.clientInfo.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.createArrayOf(typeName, (Object)elements);
    }

    public Array createArrayOf(String typeName, Object elements) throws SQLException {
        if (typeName == null) {
            throw this.exceptionFactory.notSupported("typeName is not mandatory");
        }
        if (elements == null) {
            return null;
        }
        switch (typeName) {
            case "float": 
            case "Float": {
                if (float[].class.equals(elements.getClass())) {
                    return new FloatArray((float[])elements, this.client.getContext());
                }
                if (Float[].class.equals(elements.getClass())) {
                    float[] result = Arrays.stream((Float[])elements).collect(() -> FloatBuffer.allocate(((Float[])elements).length), FloatBuffer::put, (left, right) -> {
                        throw new UnsupportedOperationException();
                    }).array();
                    return new FloatArray(result, this.client.getContext());
                }
                throw this.exceptionFactory.notSupported("elements class is expect to be float[]/Float[] for 'float/Float' typeName");
            }
        }
        throw this.exceptionFactory.notSupported(String.format("typeName %s is not supported", typeName));
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw this.exceptionFactory.notSupported("Struct type is not supported");
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public void setSchema(String schema) {
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.poolConnection != null) {
            SingleStorePoolConnection poolConnection = this.poolConnection;
            poolConnection.close();
            return;
        }
        this.client.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (this.isClosed()) {
            throw this.exceptionFactory.create("Connection.setNetworkTimeout cannot be called on a closed connection");
        }
        if (milliseconds < 0) {
            throw this.exceptionFactory.create("Connection.setNetworkTimeout cannot be called with a negative timeout");
        }
        this.getContext().addStateFlag(1);
        try (ClosableLock ignore = this.lock.closeableLock();){
            this.client.setSocketTimeout(milliseconds);
        }
    }

    @Override
    public int getNetworkTimeout() {
        return this.client.getSocketTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException("The receiver is not a wrapper for " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    public Client getClient() {
        return this.client;
    }

    public void reset() throws SQLException {
        int stateFlag;
        boolean useComReset;
        boolean bl = useComReset = this.conf.useResetConnection() && this.getMetaData().getSingleStoreVersion().versionGreaterOrEqual(7, 5, 2);
        if (useComReset) {
            this.client.execute(ResetPacket.INSTANCE, true);
        }
        if (this.forceTransactionEnd || (this.client.getContext().getServerStatus() & 1) > 0) {
            this.client.execute(new QueryPacket("ROLLBACK"), true);
        }
        if ((stateFlag = this.getContext().getStateFlag()) != 0) {
            try {
                if ((stateFlag & 1) != 0) {
                    this.setNetworkTimeout(null, this.conf.socketTimeout());
                }
                if ((stateFlag & 8) != 0) {
                    this.setAutoCommit(this.conf.autocommit() == null ? true : this.conf.autocommit());
                }
                if ((stateFlag & 2) != 0) {
                    this.setCatalog(this.conf.database());
                }
                if ((stateFlag & 4) != 0) {
                    this.setReadOnly(false);
                }
            }
            catch (SQLException sqle) {
                throw this.exceptionFactory.create("error resetting connection");
            }
        }
        this.client.reset();
        this.clearWarnings();
    }

    public long getThreadId() {
        return this.client.getContext().getThreadId();
    }

    public void fireStatementClosed(PreparedStatement prep) {
        if (this.poolConnection != null) {
            this.poolConnection.fireStatementClosed(prep);
        }
    }

    protected ExceptionFactory getExceptionFactory() {
        return this.exceptionFactory;
    }

    public QueryTimeoutHandler handleTimeout(int queryTimeout) {
        return this.queryTimeoutHandler.create(queryTimeout);
    }
}

