/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.pool.InternalPoolConnection;
import com.singlestore.jdbc.pool.Pool;
import com.singlestore.jdbc.pool.Pools;
import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;

public class SingleStorePoolDataSource
implements DataSource,
ConnectionPoolDataSource,
Closeable,
AutoCloseable {
    private Pool pool;
    private Configuration conf = null;
    private String url = null;
    private String user = null;
    private String password = null;
    private Integer loginTimeout = null;

    public SingleStorePoolDataSource() {
    }

    public SingleStorePoolDataSource(String url) throws SQLException {
        if (!Configuration.acceptsUrl(url)) {
            throw new SQLException(String.format("Wrong SingleStoreDB url: %s", url));
        }
        this.url = url;
        this.conf = Configuration.parse(url);
        this.pool = Pools.retrievePool(this.conf);
    }

    private void config() throws SQLException {
        if (this.url == null) {
            throw new SQLException("url not set");
        }
        this.conf = Configuration.parse(this.url);
        if (this.loginTimeout != null) {
            this.conf.connectTimeout(this.loginTimeout * 1000);
        }
        if (this.user != null) {
            this.conf = this.conf.clone(this.user, this.password);
        } else {
            this.user = this.conf.user();
            this.password = this.conf.password();
        }
        this.pool = Pools.retrievePool(this.conf);
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.conf == null) {
            this.config();
        }
        return this.pool.getPoolConnection().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        if (this.conf == null) {
            this.config();
        }
        return this.pool.getPoolConnection(username, password).getConnection();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException("Datasource is not a wrapper for " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    @Override
    public int getLoginTimeout() {
        if (this.loginTimeout != null) {
            return this.loginTimeout;
        }
        if (this.conf != null) {
            return this.conf.connectTimeout() / 1000;
        }
        return DriverManager.getLoginTimeout() > 0 ? DriverManager.getLoginTimeout() : 30;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
        if (this.conf != null) {
            this.config();
        }
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    @Override
    public InternalPoolConnection getPooledConnection() throws SQLException {
        if (this.conf == null) {
            this.config();
        }
        return this.pool.getPoolConnection();
    }

    @Override
    public InternalPoolConnection getPooledConnection(String username, String password) throws SQLException {
        if (this.conf == null) {
            this.config();
        }
        return this.pool.getPoolConnection(username, password);
    }

    public void setUrl(String url) throws SQLException {
        if (!Configuration.acceptsUrl(url)) {
            throw new SQLException(String.format("Wrong singleStoreDB url: %s", url));
        }
        this.url = url;
        this.config();
    }

    public String getUrl() {
        if (this.conf == null) {
            return this.url;
        }
        return this.conf.initialUrl();
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) throws SQLException {
        this.user = user;
        if (this.conf != null) {
            this.config();
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) throws SQLException {
        this.password = password;
        if (this.conf != null) {
            this.config();
        }
    }

    @Override
    public void close() {
        this.pool.close();
    }

    public String getPoolName() {
        return this.pool != null ? this.pool.getPoolTag() : null;
    }

    public List<Long> testGetConnectionIdleThreadIds() {
        return this.pool != null ? this.pool.testGetConnectionIdleThreadIds() : null;
    }
}

