/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.client.column;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.client.ColumnDecoder;
import com.singlestore.jdbc.client.DataType;
import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.client.util.MutableInt;
import com.singlestore.jdbc.message.server.ColumnDefinitionPacket;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class SignedTinyIntColumn
extends ColumnDefinitionPacket
implements ColumnDecoder {
    public SignedTinyIntColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat, false);
    }

    protected SignedTinyIntColumn(SignedTinyIntColumn prev) {
        super(prev, true);
    }

    @Override
    public SignedTinyIntColumn useAliasAsName() {
        return new SignedTinyIntColumn(this);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        if (conf.tinyInt1isBit() && conf.transformedBitIsBoolean()) {
            return Boolean.class.getName();
        }
        return Byte.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        if (conf.tinyInt1isBit()) {
            return conf.transformedBitIsBoolean() ? 16 : -7;
        }
        return -6;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        if (conf.tinyInt1isBit()) {
            return conf.transformedBitIsBoolean() ? "BOOLEAN" : "BIT";
        }
        return this.dataType.name();
    }

    @Override
    public int getPrecision() {
        return Math.min(3, (int)this.columnLength);
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (conf.tinyInt1isBit() && conf.transformedBitIsBoolean()) {
            return this.decodeBooleanText(buf, length);
        }
        return (byte)buf.atoll(length.get());
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (conf.tinyInt1isBit() && conf.transformedBitIsBoolean()) {
            return this.decodeBooleanBinary(buf, length);
        }
        return buf.readByte();
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        String s = buf.readAscii(length.get());
        return !"0".equals(s);
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return buf.readByte() != 0;
    }

    @Override
    public byte decodeByteText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        long result = buf.atoll(length.get());
        if ((long)((byte)result) != result) {
            throw new SQLDataException("byte overflow");
        }
        return (byte)result;
    }

    @Override
    public byte decodeByteBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return buf.readByte();
    }

    @Override
    public String decodeStringText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        return buf.readString(length.get());
    }

    @Override
    public String decodeStringBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        return String.valueOf(buf.readByte());
    }

    @Override
    public short decodeShortText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return (short)buf.atoll(length.get());
    }

    @Override
    public short decodeShortBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return buf.readByte();
    }

    @Override
    public int decodeIntText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return (int)buf.atoll(length.get());
    }

    @Override
    public int decodeIntBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return buf.readByte();
    }

    @Override
    public long decodeLongText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return buf.atoll(length.get());
    }

    @Override
    public long decodeLongBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return buf.readByte();
    }

    @Override
    public float decodeFloatText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return Float.parseFloat(buf.readAscii(length.get()));
    }

    @Override
    public float decodeFloatBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return buf.readByte();
    }

    @Override
    public double decodeDoubleText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return Double.parseDouble(buf.readAscii(length.get()));
    }

    @Override
    public double decodeDoubleBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return buf.readByte();
    }

    @Override
    public Date decodeDateText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
    }

    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
    }

    @Override
    public Time decodeTimeText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
    }

    @Override
    public Time decodeTimeBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
    }

    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }

    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
    }
}

