/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.client.result.rowdecoder;

import com.singlestore.jdbc.Configuration;
import com.singlestore.jdbc.client.ColumnDecoder;
import com.singlestore.jdbc.client.impl.StandardReadableByteBuf;
import com.singlestore.jdbc.client.result.rowdecoder.RowDecoder;
import com.singlestore.jdbc.client.util.MutableInt;
import com.singlestore.jdbc.plugin.Codec;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class BinaryRowDecoder
implements RowDecoder {
    @Override
    public <T> T decode(Codec<T> codec, Calendar cal, StandardReadableByteBuf rowBuf, MutableInt fieldLength, ColumnDecoder[] metadataList, MutableInt fieldIndex) throws SQLException {
        return codec.decodeBinary(rowBuf, fieldLength, metadataList[fieldIndex.get()], cal);
    }

    @Override
    public Object defaultDecode(Configuration conf, ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength) throws SQLException {
        return metadataList[fieldIndex.get()].getDefaultBinary(conf, rowBuf, fieldLength);
    }

    @Override
    public String decodeString(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength) throws SQLException {
        return metadataList[fieldIndex.get()].decodeStringBinary(rowBuf, fieldLength, null);
    }

    @Override
    public byte decodeByte(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength) throws SQLException {
        return metadataList[fieldIndex.get()].decodeByteBinary(rowBuf, fieldLength);
    }

    @Override
    public boolean decodeBoolean(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength) throws SQLException {
        return metadataList[fieldIndex.get()].decodeBooleanBinary(rowBuf, fieldLength);
    }

    @Override
    public Date decodeDate(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength, Calendar cal) throws SQLException {
        return metadataList[fieldIndex.get()].decodeDateBinary(rowBuf, fieldLength, cal);
    }

    @Override
    public Time decodeTime(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength, Calendar cal) throws SQLException {
        return metadataList[fieldIndex.get()].decodeTimeBinary(rowBuf, fieldLength, cal);
    }

    @Override
    public Timestamp decodeTimestamp(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength, Calendar cal) throws SQLException {
        return metadataList[fieldIndex.get()].decodeTimestampBinary(rowBuf, fieldLength, cal);
    }

    @Override
    public short decodeShort(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength) throws SQLException {
        return metadataList[fieldIndex.get()].decodeShortBinary(rowBuf, fieldLength);
    }

    @Override
    public int decodeInt(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength) throws SQLException {
        return metadataList[fieldIndex.get()].decodeIntBinary(rowBuf, fieldLength);
    }

    @Override
    public long decodeLong(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength) throws SQLException {
        return metadataList[fieldIndex.get()].decodeLongBinary(rowBuf, fieldLength);
    }

    @Override
    public float decodeFloat(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength) throws SQLException {
        return metadataList[fieldIndex.get()].decodeFloatBinary(rowBuf, fieldLength);
    }

    @Override
    public double decodeDouble(ColumnDecoder[] metadataList, MutableInt fieldIndex, StandardReadableByteBuf rowBuf, MutableInt fieldLength) throws SQLException {
        return metadataList[fieldIndex.get()].decodeDoubleBinary(rowBuf, fieldLength);
    }

    @Override
    public boolean wasNull(byte[] nullBitmap, MutableInt fieldIndex, MutableInt fieldLength) {
        return (nullBitmap[(fieldIndex.get() + 2) / 8] & 1 << (fieldIndex.get() + 2) % 8) > 0 || fieldLength.get() == -1;
    }

    @Override
    public int setPosition(int newIndex, MutableInt fieldIndex, int maxIndex, StandardReadableByteBuf rowBuf, byte[] nullBitmap, ColumnDecoder[] metadataList) {
        if (fieldIndex.get() >= newIndex) {
            fieldIndex.set(0);
            rowBuf.pos(1);
            rowBuf.readBytes(nullBitmap);
        } else {
            fieldIndex.incrementAndGet();
            if (fieldIndex.get() == 0) {
                rowBuf.pos(1);
                rowBuf.readBytes(nullBitmap);
            }
        }
        while (fieldIndex.get() < newIndex) {
            if ((nullBitmap[(fieldIndex.get() + 2) / 8] & 1 << (fieldIndex.get() + 2) % 8) == 0) {
                switch (metadataList[fieldIndex.get()].getType()) {
                    case BIGINT: 
                    case DOUBLE: {
                        rowBuf.skip(8);
                        break;
                    }
                    case INT: 
                    case MEDIUMINT: 
                    case FLOAT: {
                        rowBuf.skip(4);
                        break;
                    }
                    case SMALLINT: 
                    case YEAR: {
                        rowBuf.skip(2);
                        break;
                    }
                    case TINYINT: {
                        rowBuf.skip(1);
                        break;
                    }
                    default: {
                        rowBuf.skipLengthEncoded();
                    }
                }
            }
            fieldIndex.incrementAndGet();
        }
        if ((nullBitmap[(fieldIndex.get() + 2) / 8] & 1 << (fieldIndex.get() + 2) % 8) > 0) {
            return -1;
        }
        switch (metadataList[fieldIndex.get()].getType()) {
            case BIGINT: 
            case DOUBLE: {
                return 8;
            }
            case INT: 
            case MEDIUMINT: 
            case FLOAT: {
                return 4;
            }
            case SMALLINT: 
            case YEAR: {
                return 2;
            }
            case TINYINT: {
                return 1;
            }
        }
        byte len = rowBuf.readByte();
        switch (len) {
            case -4: {
                return rowBuf.readUnsignedShort();
            }
            case -3: {
                return rowBuf.readUnsignedMedium();
            }
            case -2: {
                return (int)rowBuf.readLong();
            }
        }
        return len & 0xFF;
    }
}

