/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.util.vector;

import com.singlestore.jdbc.client.util.VectorType;
import com.singlestore.jdbc.util.vector.VectorParser;

public class Int16VectorParser
extends VectorParser<short[]> {
    public static final Int16VectorParser INSTANCE = new Int16VectorParser();

    protected Int16VectorParser() {
        super(VectorType.I16);
    }

    @Override
    public short[] parseDefault(byte[] data, int length) {
        String[] values = Int16VectorParser.parseVectorString(data, length);
        short[] shorts = new short[length];
        for (int i = 0; i < length; ++i) {
            try {
                shorts[i] = Short.parseShort(values[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid I16 number format at index " + i + ": " + values[i]);
            }
        }
        return shorts;
    }

    @Override
    short[] parseShorts(byte[] data, int length) {
        return this.parseDefault(data, length);
    }

    @Override
    int[] parseIntegers(byte[] data, int length) {
        short[] shorts = this.parseDefault(data, length);
        int[] integers = new int[shorts.length];
        for (int i = 0; i < shorts.length; ++i) {
            integers[i] = shorts[i];
        }
        return integers;
    }

    @Override
    long[] parseLongs(byte[] data, int length) {
        short[] shorts = this.parseDefault(data, length);
        long[] longs = new long[shorts.length];
        for (int i = 0; i < shorts.length; ++i) {
            longs[i] = shorts[i];
        }
        return longs;
    }

    @Override
    float[] parseFloats(byte[] data, int length) {
        short[] shorts = this.parseDefault(data, length);
        float[] floats = new float[shorts.length];
        for (int i = 0; i < shorts.length; ++i) {
            floats[i] = shorts[i];
        }
        return floats;
    }

    @Override
    double[] parseDoubles(byte[] data, int length) {
        short[] shorts = this.parseDefault(data, length);
        double[] doubles = new double[shorts.length];
        for (int i = 0; i < shorts.length; ++i) {
            doubles[i] = shorts[i];
        }
        return doubles;
    }
}

