/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okio.BufferedSource;
import okio.ByteString;
import okio.Options;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"UNICODE_BOMS", "Lokio/Options;", "readBomAsCharset", "Ljava/nio/charset/Charset;", "Lokio/BufferedSource;", "default", "toOkioFileSystem", "Lokio/FileSystem;", "Ljava/nio/file/FileSystem;", "wire-compiler"})
public final class FileSystemsKt {
    @NotNull
    private static final Options UNICODE_BOMS;

    @NotNull
    public static final okio.FileSystem toOkioFileSystem(@NotNull FileSystem $this$toOkioFileSystem) {
        Intrinsics.checkNotNullParameter((Object)$this$toOkioFileSystem, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$toOkioFileSystem, (Object)FileSystems.getDefault())) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Wire doesn't support non-default file system: ", (Object)$this$toOkioFileSystem).toString());
        }
        return okio.FileSystem.SYSTEM;
    }

    @NotNull
    public static final Charset readBomAsCharset(@NotNull BufferedSource $this$readBomAsCharset, @NotNull Charset charset) {
        Charset charset2;
        Intrinsics.checkNotNullParameter((Object)$this$readBomAsCharset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"default");
        switch ($this$readBomAsCharset.select(UNICODE_BOMS)) {
            case 0: {
                charset2 = Charsets.UTF_8;
                break;
            }
            case 1: {
                charset2 = Charsets.UTF_16BE;
                break;
            }
            case 2: {
                charset2 = Charsets.UTF_16LE;
                break;
            }
            case 3: {
                charset2 = Charsets.INSTANCE.UTF32_BE();
                break;
            }
            case 4: {
                charset2 = Charsets.INSTANCE.UTF32_LE();
                break;
            }
            case -1: {
                charset2 = charset;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return charset2;
    }

    public static /* synthetic */ Charset readBomAsCharset$default(BufferedSource bufferedSource, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FileSystemsKt.readBomAsCharset(bufferedSource, charset);
    }

    static {
        ByteString[] byteStringArray = new ByteString[]{ByteString.Companion.decodeHex("efbbbf"), ByteString.Companion.decodeHex("feff"), ByteString.Companion.decodeHex("fffe"), ByteString.Companion.decodeHex("0000ffff"), ByteString.Companion.decodeHex("ffff0000")};
        UNICODE_BOMS = Options.Companion.of(byteStringArray);
    }
}

