/*
 * Decompiled with CFR 0.152.
 */
package com.ultimatesoftware.sonar.plugins.mulesoft;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ultimatesoftware.sonar.plugins.mulesoft.models.Flow;
import com.ultimatesoftware.sonar.plugins.mulesoft.models.MunitFile;
import com.ultimatesoftware.sonar.plugins.mulesoft.models.MunitReport;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class JsonParser {
    private final Path jsonReportPath;

    public JsonParser(Path jsonReportPath) {
        this.jsonReportPath = jsonReportPath;
    }

    public List<SourceFile> parse() throws IOException {
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        byte[] jsonData = Files.readAllBytes(Paths.get(this.jsonReportPath.toString(), new String[0]));
        ObjectMapper objectMapper = new ObjectMapper();
        MunitReport mur = objectMapper.readValue(jsonData, MunitReport.class);
        for (MunitFile file : mur.getFiles()) {
            SourceFile sourceFile = new SourceFile("", file.getName());
            int numOfLines = 0;
            int covered = 0;
            for (Flow flow : file.getFlows()) {
                numOfLines += flow.getMessageProcessorCount();
                covered += flow.getCoveredProcessorCount();
            }
            for (int i = 1; i <= numOfLines; ++i) {
                sourceFile.lines().add(new Line(i, i > covered ? 1 : 0, i > covered ? 0 : 1, 0, 0));
            }
            sourceFiles.add(sourceFile);
        }
        return sourceFiles;
    }

    static class Line {
        private int number;
        private int missedInstrs;
        private int coveredInstrs;
        private int missedBranches;
        private int coveredBranches;

        Line(int number, int missedInstrs, int coveredInstrs, int missedBranches, int coveredBranches) {
            this.number = number;
            this.missedInstrs = missedInstrs;
            this.coveredInstrs = coveredInstrs;
            this.missedBranches = missedBranches;
            this.coveredBranches = coveredBranches;
        }

        public int number() {
            return this.number;
        }

        public int missedInstrs() {
            return this.missedInstrs;
        }

        public int coveredInstrs() {
            return this.coveredInstrs;
        }

        public int missedBranches() {
            return this.missedBranches;
        }

        public int coveredBranches() {
            return this.coveredBranches;
        }
    }

    static class SourceFile {
        private String name;
        private String packageName;
        private List<Line> lines = new ArrayList<Line>();

        SourceFile(String packageName, String name) {
            this.name = name;
            this.packageName = packageName;
        }

        public String name() {
            return this.name;
        }

        public String packageName() {
            return this.packageName;
        }

        public List<Line> lines() {
            return this.lines;
        }
    }
}

