/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.DataTable;
import io.cucumber.messages.types.DocString;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleDocString;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.PickleStepArgument;
import io.cucumber.messages.types.PickleStepType;
import io.cucumber.messages.types.PickleTable;
import io.cucumber.messages.types.PickleTableCell;
import io.cucumber.messages.types.PickleTableRow;
import io.cucumber.messages.types.PickleTag;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.RuleChild;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.StepKeywordType;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class PickleCompiler {
    private final IdGenerator idGenerator;
    private static final Map<StepKeywordType, PickleStepType> pickleStepTypeFromKeywordType = new EnumMap<StepKeywordType, PickleStepType>(StepKeywordType.class);

    PickleCompiler(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    List<Pickle> compile(GherkinDocument gherkinDocument, String uri) {
        ArrayList<Pickle> pickles = new ArrayList<Pickle>(2048);
        if (!gherkinDocument.getFeature().isPresent()) {
            return pickles;
        }
        Feature feature = (Feature)gherkinDocument.getFeature().get();
        String language = feature.getLanguage();
        this.compileFeature(pickles, feature, language, uri);
        return pickles;
    }

    private void compileFeature(List<Pickle> pickles, Feature feature, String language, String uri) {
        List tags = feature.getTags();
        ArrayList<Step> featureBackgroundSteps = new ArrayList<Step>();
        for (FeatureChild featureChild : feature.getChildren()) {
            if (featureChild.getBackground().isPresent()) {
                featureBackgroundSteps.addAll(((Background)featureChild.getBackground().get()).getSteps());
                continue;
            }
            if (featureChild.getRule().isPresent()) {
                this.compileRule(pickles, (Rule)featureChild.getRule().get(), tags, featureBackgroundSteps, language, uri);
                continue;
            }
            if (!featureChild.getScenario().isPresent()) continue;
            Scenario scenario = (Scenario)featureChild.getScenario().get();
            if (scenario.getExamples().isEmpty()) {
                this.compileScenario(pickles, scenario, tags, featureBackgroundSteps, language, uri);
                continue;
            }
            this.compileScenarioOutline(pickles, scenario, tags, featureBackgroundSteps, language, uri);
        }
    }

    private void compileRule(List<Pickle> pickles, Rule rule, List<Tag> parentTags, List<Step> featureBackgroundSteps, String language, String uri) {
        ArrayList<Step> ruleBackgroundSteps = new ArrayList<Step>(featureBackgroundSteps);
        List<Tag> ruleTags = this.compileTags(parentTags, rule.getTags());
        for (RuleChild ruleChild : rule.getChildren()) {
            if (ruleChild.getBackground().isPresent()) {
                ruleBackgroundSteps.addAll(((Background)ruleChild.getBackground().get()).getSteps());
                continue;
            }
            if (!ruleChild.getScenario().isPresent()) continue;
            Scenario scenario = (Scenario)ruleChild.getScenario().get();
            if (scenario.getExamples().isEmpty()) {
                this.compileScenario(pickles, scenario, ruleTags, ruleBackgroundSteps, language, uri);
                continue;
            }
            this.compileScenarioOutline(pickles, scenario, ruleTags, ruleBackgroundSteps, language, uri);
        }
    }

    private void compileScenario(List<Pickle> pickles, Scenario scenario, List<Tag> parentTags, List<Step> backgroundSteps, String language, String uri) {
        List<PickleStep> steps = this.compilePickleSteps(backgroundSteps, scenario.getSteps(), Collections.emptyList(), null);
        List<Tag> scenarioTags = this.compileTags(parentTags, scenario.getTags());
        List<String> sourceIds = Collections.singletonList(scenario.getId());
        Pickle pickle = new Pickle(this.idGenerator.newId(), uri, scenario.getName(), language, steps, this.pickleTags(scenarioTags), sourceIds);
        pickles.add(pickle);
    }

    private List<Tag> compileTags(List<Tag> parentTags, List<Tag> scenarioTags) {
        if (parentTags.isEmpty()) {
            return scenarioTags;
        }
        if (scenarioTags.isEmpty()) {
            return parentTags;
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(parentTags.size() + scenarioTags.size());
        tags.addAll(parentTags);
        tags.addAll(scenarioTags);
        return tags;
    }

    private List<PickleStep> compilePickleSteps(List<Step> backgroundSteps, List<Step> scenarioSteps, List<TableCell> variableCells, TableRow valuesRow) {
        StepKeywordType stepKeywordType;
        if (scenarioSteps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PickleStep> steps = new ArrayList<PickleStep>(backgroundSteps.size() + scenarioSteps.size());
        StepKeywordType lastKeywordType = StepKeywordType.UNKNOWN;
        for (Step step : backgroundSteps) {
            stepKeywordType = step.getKeywordType().orElse(StepKeywordType.UNKNOWN);
            if (stepKeywordType != StepKeywordType.CONJUNCTION) {
                lastKeywordType = stepKeywordType;
            }
            steps.add(this.pickleBackgroundStep(step, lastKeywordType));
        }
        for (Step scenarioStep : scenarioSteps) {
            stepKeywordType = scenarioStep.getKeywordType().orElse(StepKeywordType.UNKNOWN);
            if (stepKeywordType != StepKeywordType.CONJUNCTION) {
                lastKeywordType = stepKeywordType;
            }
            steps.add(this.pickleStep(scenarioStep, variableCells, valuesRow, lastKeywordType));
        }
        return steps;
    }

    private void compileScenarioOutline(List<Pickle> pickles, Scenario scenario, List<Tag> parentTags, List<Step> backgroundSteps, String language, String uri) {
        List<Tag> scenarioTags = this.compileTags(parentTags, scenario.getTags());
        for (Examples examples : scenario.getExamples()) {
            if (!examples.getTableHeader().isPresent()) continue;
            List variableCells = ((TableRow)examples.getTableHeader().get()).getCells();
            for (TableRow valuesRow : examples.getTableBody()) {
                List<PickleStep> steps = this.compilePickleSteps(backgroundSteps, scenario.getSteps(), variableCells, valuesRow);
                List<Tag> tags = this.compileTags(scenarioTags, examples.getTags());
                List<String> sourceIds = Arrays.asList(scenario.getId(), valuesRow.getId());
                Pickle pickle = new Pickle(this.idGenerator.newId(), uri, this.interpolate(scenario.getName(), variableCells, valuesRow.getCells()), language, steps, this.pickleTags(tags), sourceIds);
                pickles.add(pickle);
            }
        }
    }

    private PickleTable pickleDataTable(DataTable dataTable, List<TableCell> variableCells, List<TableCell> valueCells) {
        List rows = dataTable.getRows();
        int rowCount = rows.size();
        ArrayList<PickleTableRow> newRows = new ArrayList<PickleTableRow>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            TableRow row = (TableRow)rows.get(i);
            List cells = row.getCells();
            int cellCount = cells.size();
            ArrayList<PickleTableCell> newCells = new ArrayList<PickleTableCell>(cellCount);
            for (int j = 0; j < cellCount; ++j) {
                TableCell cell = (TableCell)cells.get(j);
                newCells.add(new PickleTableCell(this.interpolate(cell.getValue(), variableCells, valueCells)));
            }
            newRows.add(new PickleTableRow(newCells));
        }
        return new PickleTable(newRows);
    }

    private PickleDocString pickleDocString(DocString docString, List<TableCell> variableCells, List<TableCell> valueCells) {
        return new PickleDocString(docString.getMediaType().isPresent() ? this.interpolate((String)docString.getMediaType().get(), variableCells, valueCells) : null, this.interpolate(docString.getContent(), variableCells, valueCells));
    }

    private PickleStep pickleStep(Step step, List<TableCell> variableCells, TableRow valuesRow, StepKeywordType keywordType) {
        Optional docString;
        List valueCells = valuesRow == null ? Collections.emptyList() : valuesRow.getCells();
        String stepText = this.interpolate(step.getText(), variableCells, valueCells);
        PickleStepArgument argument = null;
        Optional dataTable = step.getDataTable();
        if (dataTable.isPresent()) {
            argument = new PickleStepArgument(null, this.pickleDataTable((DataTable)dataTable.get(), variableCells, valueCells));
        }
        if ((docString = step.getDocString()).isPresent()) {
            argument = new PickleStepArgument(this.pickleDocString((DocString)docString.get(), variableCells, valueCells), null);
        }
        List<String> astNodeIds = valuesRow != null ? Arrays.asList(step.getId(), valuesRow.getId()) : Collections.singletonList(step.getId());
        return new PickleStep(argument, astNodeIds, this.idGenerator.newId(), pickleStepTypeFromKeywordType.get(keywordType), stepText);
    }

    private PickleStep pickleBackgroundStep(Step step, StepKeywordType keywordType) {
        return this.pickleStep(step, Collections.emptyList(), null, keywordType);
    }

    private String interpolate(String name, List<TableCell> variableCells, List<TableCell> valueCells) {
        int variableCellsSize = variableCells.size();
        for (int i = 0; i < variableCellsSize; ++i) {
            TableCell variableCell = variableCells.get(i);
            TableCell valueCell = valueCells.get(i);
            String header = variableCell.getValue();
            String value = valueCell.getValue();
            name = name.replace("<" + header + ">", value);
        }
        return name;
    }

    private List<PickleTag> pickleTags(List<Tag> tags) {
        if (tags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PickleTag> result = new ArrayList<PickleTag>();
        for (Tag tag : tags) {
            result.add(this.pickleTag(tag));
        }
        return result;
    }

    private PickleTag pickleTag(Tag tag) {
        return new PickleTag(tag.getName(), tag.getId());
    }

    static {
        pickleStepTypeFromKeywordType.put(StepKeywordType.UNKNOWN, PickleStepType.UNKNOWN);
        pickleStepTypeFromKeywordType.put(StepKeywordType.CONTEXT, PickleStepType.CONTEXT);
        pickleStepTypeFromKeywordType.put(StepKeywordType.ACTION, PickleStepType.ACTION);
        pickleStepTypeFromKeywordType.put(StepKeywordType.OUTCOME, PickleStepType.OUTCOME);
    }
}

