/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.prettyformatter;

import io.cucumber.messages.types.PickleDocString;
import io.cucumber.prettyformatter.LineBuilder;
import io.cucumber.prettyformatter.Theme;

final class PickleDocStringFormatter {
    private static final String DOC_STRING_DELIMITER_STRING = "\"\"\"";
    private final int indentation;

    private PickleDocStringFormatter(int indentation) {
        this.indentation = indentation;
    }

    static Builder builder() {
        return new Builder();
    }

    void formatTo(PickleDocString pickleDocString, LineBuilder lineBuilder) {
        String[] lines;
        lineBuilder.indent(this.indentation).begin(Theme.Element.DOC_STRING).append(Theme.Element.DOC_STRING_DELIMITER, DOC_STRING_DELIMITER_STRING).accept(lb -> pickleDocString.getMediaType().ifPresent(mediaType -> lb.append(Theme.Element.DOC_STRING_MEDIA_TYPE, (String)mediaType))).end(Theme.Element.DOC_STRING).newLine();
        for (String line : lines = pickleDocString.getContent().split("\\n")) {
            lineBuilder.indent(this.indentation).begin(Theme.Element.DOC_STRING).append(Theme.Element.DOC_STRING_CONTENT, line).end(Theme.Element.DOC_STRING).newLine();
        }
        lineBuilder.indent(this.indentation).begin(Theme.Element.DOC_STRING).append(Theme.Element.DOC_STRING_DELIMITER, DOC_STRING_DELIMITER_STRING).end(Theme.Element.DOC_STRING).newLine();
    }

    static final class Builder {
        private int indentation = 0;

        private Builder() {
        }

        Builder indentation(int indentation) {
            this.indentation = indentation;
            return this;
        }

        PickleDocStringFormatter build() {
            return new PickleDocStringFormatter(this.indentation);
        }
    }
}

