/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.prettyformatter;

import io.cucumber.messages.types.PickleTable;
import io.cucumber.messages.types.PickleTableCell;
import io.cucumber.prettyformatter.LineBuilder;
import io.cucumber.prettyformatter.Theme;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

final class PickleTableFormatter {
    private final int indentation;

    private PickleTableFormatter(int indentation) {
        this.indentation = indentation;
    }

    static Builder builder() {
        return new Builder();
    }

    private static int[] findLongestCellLengthInColumn(String[][] renderedCells) {
        int width = renderedCells[0].length;
        int[] longestCellInColumnLength = new int[width];
        for (String[] row : renderedCells) {
            for (int colIndex = 0; colIndex < width; ++colIndex) {
                int current = longestCellInColumnLength[colIndex];
                int candidate = row[colIndex].length();
                longestCellInColumnLength[colIndex] = Math.max(current, candidate);
            }
        }
        return longestCellInColumnLength;
    }

    private static String renderCellWithPadding(String cellText, int padding) {
        StringBuilder result = new StringBuilder();
        result.append(" ");
        result.append(cellText);
        PickleTableFormatter.padSpace(result, padding);
        result.append(" ");
        return result.toString();
    }

    private static void padSpace(StringBuilder result, int padding) {
        for (int i = 0; i < padding; ++i) {
            result.append(" ");
        }
    }

    private static void renderTableRowWithPaddingTo(String[] renderedCell, int[] longestCellLengthInColumn, LineBuilder lineBuilder) {
        int width = renderedCell.length;
        for (int colIndex = 0; colIndex < width; ++colIndex) {
            String cellText = renderedCell[colIndex];
            int padding = longestCellLengthInColumn[colIndex] - cellText.length();
            lineBuilder.append(Theme.Element.DATA_TABLE_CONTENT, PickleTableFormatter.renderCellWithPadding(cellText, padding)).append(Theme.Element.DATA_TABLE_BORDER, "|");
        }
    }

    void formatTo(PickleTable pickleTable, LineBuilder lineBuilder) {
        List<List<String>> cells = pickleTable.getRows().stream().map(pickleTableRow -> pickleTableRow.getCells().stream().map(PickleTableCell::getValue).collect(Collectors.toList())).collect(Collectors.toList());
        this.formatTo(cells, lineBuilder);
    }

    private void formatTo(List<List<String>> table, LineBuilder lineBuilder) {
        Objects.requireNonNull(table, "table may not be null");
        if (table.isEmpty()) {
            return;
        }
        String[][] renderedCells = this.renderCells(table);
        int[] longestCellLengthInColumn = PickleTableFormatter.findLongestCellLengthInColumn(renderedCells);
        this.renderTableWithPaddingTo(renderedCells, longestCellLengthInColumn, lineBuilder);
    }

    private void renderTableWithPaddingTo(String[][] renderedCells, int[] longestCellLengthInColumn, LineBuilder lineBuilder) {
        for (String[] renderedCell : renderedCells) {
            lineBuilder.indent(this.indentation).begin(Theme.Element.DATA_TABLE).append(Theme.Element.DATA_TABLE_BORDER, "|").accept(innerLineBuilder -> PickleTableFormatter.renderTableRowWithPaddingTo(renderedCell, longestCellLengthInColumn, innerLineBuilder)).end(Theme.Element.DATA_TABLE).newLine();
        }
    }

    private String[][] renderCells(List<List<String>> table) {
        int height = table.size();
        int width = table.get(0).size();
        String[][] renderedCells = new String[height][width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                renderedCells[i][j] = this.renderCell(table.get(i).get(j));
            }
        }
        return renderedCells;
    }

    private String renderCell(String cell) {
        if (cell == null) {
            return "";
        }
        return cell;
    }

    static final class Builder {
        private int indentation = 0;

        Builder() {
        }

        Builder indentation(int indentation) {
            this.indentation = indentation;
            return this;
        }

        PickleTableFormatter build() {
            return new PickleTableFormatter(this.indentation);
        }
    }
}

