/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.spark;

import io.delta.sharing.client.DeltaSharingClient;
import io.delta.sharing.client.model.DeltaTableFiles;
import io.delta.sharing.client.model.Table;
import io.delta.sharing.spark.ConstructedDeltaLogMetadata;
import io.delta.sharing.spark.DeltaSharingErrors$;
import io.delta.sharing.spark.DeltaSharingLogFileSystem$;
import io.delta.sharing.spark.DeltaSharingOptions;
import io.delta.sharing.spark.DeltaSharingOptions$;
import io.delta.sharing.spark.DeltaSharingUtils$;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import org.apache.hadoop.fs.Path;
import org.apache.spark.delta.sharing.CachedTableManager$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.catalog.DeltaTableV2$;
import org.apache.spark.sql.sources.BaseRelation;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class DeltaSharingCDFUtils$
implements Logging {
    public static final DeltaSharingCDFUtils$ MODULE$ = new DeltaSharingCDFUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private double getDuration(long start) {
        return (double)(System.currentTimeMillis() - start) / 1000.0;
    }

    public BaseRelation prepareCDFRelation(SQLContext sqlContext, DeltaSharingOptions options, Table table, DeltaSharingClient client) {
        long startTime = System.currentTimeMillis();
        DeltaTableFiles deltaTableFiles = client.getCDFFiles(table, options.cdfOptions(), true);
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Fetched ").append(deltaTableFiles.lines().size()).append(" lines with cdf options ").append(options.cdfOptions()).append(" ").append("for table ").append(table).append(" from delta sharing server, took ").append(MODULE$.getDuration(startTime)).append("s.").toString());
        String path = (String)options.options().getOrElse((Object)"path", (Function0 & Serializable)() -> {
            throw DeltaSharingErrors$.MODULE$.pathNotSpecifiedException();
        });
        String queryCustomTablePath = client.getProfileProvider().getCustomTablePath(path);
        String queryParamsHashId = DeltaSharingUtils$.MODULE$.getQueryParamsHashId((Map<String, String>)options.cdfOptions());
        String tablePathWithHashIdSuffix = DeltaSharingUtils$.MODULE$.getTablePathWithIdSuffix(queryCustomTablePath, queryParamsHashId);
        ConstructedDeltaLogMetadata deltaLogMetadata = DeltaSharingLogFileSystem$.MODULE$.constructLocalDeltaLogAcrossVersions((Seq<String>)deltaTableFiles.lines(), tablePathWithHashIdSuffix, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
        CachedTableManager$.MODULE$.INSTANCE().register(DeltaSharingUtils$.MODULE$.getTablePathWithIdSuffix(path, queryParamsHashId), deltaLogMetadata.idToUrl(), (Seq)new .colon.colon(new WeakReference<DeltaSharingCDFUtils$>(this), (List)Nil$.MODULE$), client.getProfileProvider(), DeltaSharingUtils$.MODULE$.getRefresherForGetCDFFiles(client, table, (Map<String, String>)options.cdfOptions()), CachedTableManager$.MODULE$.INSTANCE().isValidUrlExpirationTime(deltaLogMetadata.minUrlExpirationTimestamp()) ? BoxesRunTime.unboxToLong((Object)deltaLogMetadata.minUrlExpirationTimestamp().get()) : System.currentTimeMillis() + CachedTableManager$.MODULE$.INSTANCE().preSignedUrlExpirationMs(), (Option)None$.MODULE$);
        Map localDeltaCdfOptions = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaSharingOptions$.MODULE$.CDF_START_VERSION()), (Object)Long.toString(deltaLogMetadata.minVersion())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaSharingOptions$.MODULE$.CDF_END_VERSION()), (Object)Long.toString(deltaLogMetadata.maxVersion())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaSharingOptions$.MODULE$.CDF_READ_OPTION()), (Object)"true")}));
        SparkSession x$1 = sqlContext.sparkSession();
        Path x$2 = DeltaSharingLogFileSystem$.MODULE$.encode(tablePathWithHashIdSuffix);
        Map x$3 = localDeltaCdfOptions;
        Option x$4 = DeltaTableV2$.MODULE$.apply$default$3();
        Option x$5 = DeltaTableV2$.MODULE$.apply$default$4();
        Option x$6 = DeltaTableV2$.MODULE$.apply$default$6();
        return DeltaTableV2$.MODULE$.apply(x$1, x$2, x$4, x$5, x$3, x$6).toBaseRelation();
    }

    private DeltaSharingCDFUtils$() {
    }
}

