/*
 * Decompiled with CFR 0.152.
 */
package io.delta.sharing.spark;

import io.delta.sharing.client.util.JsonUtils$;
import io.delta.sharing.spark.ConstructedDeltaLogMetadata;
import io.delta.sharing.spark.DeltaSharingLogFileStatus;
import io.delta.sharing.spark.DeltaSharingUtils;
import io.delta.sharing.spark.DeltaSharingUtils$;
import io.delta.sharing.spark.model.DeltaSharingAction;
import io.delta.sharing.spark.model.DeltaSharingFileAction;
import io.delta.sharing.spark.model.DeltaSharingMetadata;
import io.delta.sharing.spark.model.DeltaSharingProtocol;
import io.delta.sharing.spark.model.DeltaSharingSingleAction;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddCDCFile;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor$;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SingleAction;
import org.apache.spark.sql.delta.util.FileNames;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockId$;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockResult;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public final class DeltaSharingLogFileSystem$
implements Logging {
    public static final DeltaSharingLogFileSystem$ MODULE$ = new DeltaSharingLogFileSystem$();
    private static final String SCHEME;
    private static final String BLOCK_ID_TEST_PREFIX;
    private static final String DELTA_SHARING_LOG_BLOCK_ID_PREFIX;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        SCHEME = "delta-sharing-log";
        BLOCK_ID_TEST_PREFIX = "test_";
        DELTA_SHARING_LOG_BLOCK_ID_PREFIX = "test_delta-sharing-log:";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String SCHEME() {
        return SCHEME;
    }

    private String BLOCK_ID_TEST_PREFIX() {
        return BLOCK_ID_TEST_PREFIX;
    }

    public String DELTA_SHARING_LOG_BLOCK_ID_PREFIX() {
        return DELTA_SHARING_LOG_BLOCK_ID_PREFIX;
    }

    public BlockId getDeltaSharingLogBlockId(String path) {
        return BlockId$.MODULE$.apply(new StringBuilder(0).append(this.BLOCK_ID_TEST_PREFIX()).append(path).toString());
    }

    public Path encode(String tablePath) {
        String encodedTablePath = URLEncoder.encode(tablePath, "UTF-8");
        return new Path(new StringBuilder(4).append(this.SCHEME()).append(":///").append(encodedTablePath).toString());
    }

    public String decode(Path path) {
        String encodedTablePath = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(path.toString()), new StringBuilder(4).append(this.SCHEME()).append(":///").toString())), new StringBuilder(2).append(this.SCHEME()).append(":/").toString());
        return URLDecoder.decode(encodedTablePath, "UTF-8");
    }

    private DeletionVectorDescriptor getDeltaSharingDeletionVectorDescriptor(DeltaSharingFileAction fileAction, String customTablePath) {
        if (fileAction.getDeletionVectorOpt().isEmpty()) {
            return null;
        }
        DeletionVectorDescriptor deletionVector = (DeletionVectorDescriptor)fileAction.getDeletionVectorOpt().get();
        String string = deletionVector.storageType();
        String string2 = DeletionVectorDescriptor$.MODULE$.PATH_DV_MARKER();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            String x$1 = fileAction.getDeletionVectorDeltaSharingPath(customTablePath);
            String x$2 = deletionVector.copy$default$1();
            Option x$3 = deletionVector.copy$default$3();
            int x$4 = deletionVector.copy$default$4();
            long x$5 = deletionVector.copy$default$5();
            Option x$6 = deletionVector.copy$default$6();
            return deletionVector.copy(x$2, x$1, x$3, x$4, x$5, x$6);
        }
        String string4 = DeletionVectorDescriptor$.MODULE$.INLINE_DV_MARKER();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return deletionVector;
        }
        throw new IllegalStateException(new StringBuilder(63).append("Unexpected DV storage type:").append(string).append(" in the delta sharing response for ").append(fileAction.json()).append(".").toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean requiresIdToUrlForDV(Option<DeletionVectorDescriptor> deletionVectorOpt) {
        if (!deletionVectorOpt.isDefined()) return false;
        String string = ((DeletionVectorDescriptor)deletionVectorOpt.get()).storageType();
        String string2 = DeletionVectorDescriptor$.MODULE$.PATH_DV_MARKER();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    private String getActionWithDeltaSharingPath(DeltaSharingFileAction fileAction, String customTablePath) {
        AddCDCFile addCDCFile;
        String deltaSharingPath = fileAction.getDeltaSharingPath(customTablePath);
        Action action = fileAction.deltaSingleAction().unwrap();
        if (action instanceof AddFile) {
            AddFile addFile = (AddFile)action;
            String x$1 = deltaSharingPath;
            DeletionVectorDescriptor x$2 = this.getDeltaSharingDeletionVectorDescriptor(fileAction, customTablePath);
            scala.collection.immutable.Map x$3 = addFile.copy$default$2();
            long x$4 = addFile.copy$default$3();
            long x$5 = addFile.copy$default$4();
            boolean x$6 = addFile.copy$default$5();
            String x$7 = addFile.copy$default$6();
            scala.collection.immutable.Map x$8 = addFile.copy$default$7();
            Option x$9 = addFile.copy$default$9();
            Option x$10 = addFile.copy$default$10();
            Option x$11 = addFile.copy$default$11();
            addCDCFile = addFile.copy(x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$2, x$9, x$10, x$11);
        } else if (action instanceof AddCDCFile) {
            AddCDCFile addCDCFile2 = (AddCDCFile)action;
            Predef$.MODULE$.assert(addCDCFile2.deletionVector() == null, (Function0 & Serializable)() -> new StringBuilder(71).append("deletionVector not null in the AddCDCFile from delta").append(" sharing response: ").append(addCDCFile2.json()).toString());
            addCDCFile = addCDCFile2.copy(deltaSharingPath, addCDCFile2.copy$default$2(), addCDCFile2.copy$default$3(), addCDCFile2.copy$default$4());
        } else if (action instanceof RemoveFile) {
            RemoveFile removeFile = (RemoveFile)action;
            String x$12 = deltaSharingPath;
            DeletionVectorDescriptor x$13 = this.getDeltaSharingDeletionVectorDescriptor(fileAction, customTablePath);
            Option x$14 = removeFile.copy$default$2();
            boolean x$15 = removeFile.copy$default$3();
            Option x$16 = removeFile.copy$default$4();
            scala.collection.immutable.Map x$17 = removeFile.copy$default$5();
            Option x$18 = removeFile.copy$default$6();
            scala.collection.immutable.Map x$19 = removeFile.copy$default$7();
            Option x$20 = removeFile.copy$default$9();
            Option x$21 = removeFile.copy$default$10();
            String x$22 = removeFile.copy$default$11();
            addCDCFile = removeFile.copy(x$12, x$14, x$15, x$16, x$17, x$18, x$19, x$13, x$20, x$21, x$22);
        } else {
            throw new IllegalStateException(new StringBuilder(45).append("unexpected action in delta sharing ").append("response: ").append(action.json()).toString());
        }
        AddCDCFile newSingleAction = addCDCFile;
        return newSingleAction.json();
    }

    private boolean deltaSharingFileActionIncreaseOrderFunc(DeltaSharingFileAction f1, DeltaSharingFileAction f2) {
        return StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(f1.id()), f2.id());
    }

    public void tryToCleanUpDeltaLog(String deltaLogPath) {
        BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
        Seq matchingBlockIds = blockManager.getMatchingBlockIds((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)this.shouldCleanUp$1(x$3, deltaLogPath)));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Trying to clean up ").append(matchingBlockIds.size()).append(" blocks for ").append(deltaLogPath).append(".").toString());
        Builder problematicBlockIds = package$.MODULE$.Seq().newBuilder();
        matchingBlockIds.foreach((Function1 & Serializable)b -> {
            Growable growable;
            try {
                blockManager.removeBlock(b, blockManager.removeBlock$default$2());
                growable = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                growable = problematicBlockIds.$plus$eq(b);
            }
            return growable;
        });
        Seq problematicBlockIdsSeq = ((Seq)problematicBlockIds.result()).toSeq();
        if (problematicBlockIdsSeq.size() > 0) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("Done cleaning up ").append(matchingBlockIds.size()).append(" blocks for ").append(deltaLogPath).append(", but ").append("failed to remove: ").append(problematicBlockIdsSeq).append(".").toString());
            return;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Done cleaning up ").append(matchingBlockIds.size()).append(" blocks for ").append(deltaLogPath).append(".").toString());
    }

    private void prepareCheckpointFile(String deltaLogPath, long checkpointVersion, Builder<DeltaSharingLogFileStatus, Seq<DeltaSharingLogFileStatus>> fileSizeTsSeq) {
        String checkpointParquetFileName = FileNames$.MODULE$.checkpointFileSingular(new Path(deltaLogPath), checkpointVersion).toString();
        fileSizeTsSeq.$plus$eq((Object)new DeltaSharingLogFileStatus(checkpointParquetFileName, ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(DeltaSharingUtils$.MODULE$.FAKE_CHECKPOINT_BYTE_ARRAY())), 0L));
        String lastCheckpointContent = new StringBuilder(20).append("{\"version\":").append(checkpointVersion).append(",\"size\":").append(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(DeltaSharingUtils$.MODULE$.FAKE_CHECKPOINT_BYTE_ARRAY()))).append("}").toString();
        String lastCheckpointPath = new Path(deltaLogPath, "_last_checkpoint").toString();
        fileSizeTsSeq.$plus$eq((Object)new DeltaSharingLogFileStatus(lastCheckpointPath, lastCheckpointContent.length(), 0L));
        DeltaSharingUtils$.MODULE$.overrideSingleBlock(this.getDeltaSharingLogBlockId(lastCheckpointPath), lastCheckpointContent, ClassTag$.MODULE$.apply(String.class));
    }

    private void updateListingDeltaLog(String deltaLogPath, long checkpointVersion) {
        Builder fileSizeTsSeq = package$.MODULE$.Seq().newBuilder();
        this.prepareCheckpointFile(deltaLogPath, checkpointVersion, (Builder<DeltaSharingLogFileStatus, Seq<DeltaSharingLogFileStatus>>)fileSizeTsSeq);
        Option option = SparkEnv$.MODULE$.get().blockManager().get(this.getDeltaSharingLogBlockId(deltaLogPath), ClassTag$.MODULE$.apply(DeltaSharingLogFileStatus.class));
        if (!(option instanceof Some)) {
            throw new FileNotFoundException(new StringBuilder(32).append("Failed to list files for path: ").append(deltaLogPath).append(".").toString());
        }
        Some some = (Some)option;
        BlockResult block = (BlockResult)some.value();
        Iterator iterator = block.data();
        IndexedSeq files = iterator.flatMap((Function1 & Serializable)deltaSharingLogFileStatus -> {
            long version;
            Option option;
            long version2;
            Option option2;
            Path filePath = new Path(deltaSharingLogFileStatus.path());
            Path path = filePath;
            if (path != null && !(option2 = FileNames.CheckpointFile$.MODULE$.unapply(path)).isEmpty() && (version2 = ((Tuple2)option2.get())._2$mcJ$sp()) > checkpointVersion) {
                return new Some(deltaSharingLogFileStatus);
            }
            if (path != null && !(option = FileNames.DeltaFile$.MODULE$.unapply(path)).isEmpty() && (version = ((Tuple2)option.get())._2$mcJ$sp()) > checkpointVersion) {
                return new Some(deltaSharingLogFileStatus);
            }
            return None$.MODULE$;
        }).toIndexedSeq();
        DeltaSharingUtils$.MODULE$.overrideIteratorBlock(this.getDeltaSharingLogBlockId(deltaLogPath), ((IterableOnceOps)((IterableOps)fileSizeTsSeq.result()).$plus$plus((IterableOnce)files)).toIterator(), ClassTag$.MODULE$.apply(DeltaSharingLogFileStatus.class));
    }

    public void tryToCleanUpPreviousBlocks(String deltaLogPath, long maxVersion) {
        if (maxVersion < 0L) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Skipping clean up previous blocks for ").append(deltaLogPath).append(" because maxVersion(").append(maxVersion).append(") < 0.").toString());
            return;
        }
        BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
        try {
            this.updateListingDeltaLog(deltaLogPath, maxVersion);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(105).append("Stopped cleaning up the delta log for [").append(deltaLogPath).append("], because updating the ").append("listStatus of deltaLog() failed due to [").append(throwable2.toString()).append("].").toString());
                return;
            }
            throw throwable;
        }
        Seq matchingBlockIds = blockManager.getMatchingBlockIds((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)this.shouldCleanUp$2(x$5, deltaLogPath, maxVersion)));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Trying to clean up ").append(matchingBlockIds.size()).append(" previous blocks for ").append(deltaLogPath).append(" ").append("before version: ").append(maxVersion).append(".").toString());
        Builder problematicBlockIds = package$.MODULE$.Seq().newBuilder();
        matchingBlockIds.foreach((Function1 & Serializable)b -> {
            Growable growable;
            try {
                blockManager.removeBlock(b, blockManager.removeBlock$default$2());
                growable = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                growable = problematicBlockIds.$plus$eq(b);
            }
            return growable;
        });
        Seq problematicBlockIdsSeq = ((Seq)problematicBlockIds.result()).toSeq();
        if (problematicBlockIdsSeq.size() > 0) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(80).append("Done cleaning up ").append(matchingBlockIds.size()).append(" previous blocks for ").append(deltaLogPath).append(" ").append("before version: ").append(maxVersion).append(", but failed to remove: ").append(problematicBlockIdsSeq).append(".").toString());
            return;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Done cleaning up ").append(matchingBlockIds.size()).append(" previous blocks for ").append(deltaLogPath).append(" ").append("before version: ").append(maxVersion).append(".").toString());
    }

    public ConstructedDeltaLogMetadata constructLocalDeltaLogAcrossVersions(Seq<String> lines, String customTablePath, Option<Object> startingVersionOpt, Option<Object> endingVersionOpt) {
        long startTime = System.currentTimeMillis();
        Predef$.MODULE$.assert(startingVersionOpt.isDefined() == endingVersionOpt.isDefined(), (Function0 & Serializable)() -> new StringBuilder(74).append("startingVersionOpt(").append(startingVersionOpt).append(") and endingVersionOpt(").append(endingVersionOpt).append(") should be").append(" both defined or not.").toString());
        if (startingVersionOpt.isDefined()) {
            Predef$.MODULE$.assert(BoxesRunTime.unboxToLong((Object)startingVersionOpt.get()) <= BoxesRunTime.unboxToLong((Object)endingVersionOpt.get()), (Function0 & Serializable)() -> new StringBuilder(61).append("startingVersionOpt(").append(startingVersionOpt).append(") must be smaller than ").append("endingVersionOpt(").append(endingVersionOpt).append(").").toString());
        }
        LongRef minVersion = LongRef.create((long)Long.MAX_VALUE);
        LongRef maxVersion = LongRef.create((long)0L);
        ObjectRef minUrlExpirationTimestamp = ObjectRef.create((Object)None$.MODULE$);
        scala.collection.mutable.Map idToUrl = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map versionToDeltaSharingFileActions = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map versionToMetadata = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map versionToJsonLogBuilderMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map versionToJsonLogSize = ((scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).withDefaultValue((Object)BoxesRunTime.boxToLong((long)0L));
        int numFileActionsInMinVersion = 0;
        scala.collection.mutable.Map versionToTimestampMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef startingMetadataLineOpt = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef startingProtocolLineOpt = ObjectRef.create((Object)None$.MODULE$);
        lines.foreach((Function1 & Serializable)line -> {
            DeltaSharingAction action = ((DeltaSharingSingleAction)JsonUtils$.MODULE$.fromJson(line, ManifestFactory$.MODULE$.classType(DeltaSharingSingleAction.class))).unwrap();
            DeltaSharingAction deltaSharingAction = action;
            if (deltaSharingAction instanceof DeltaSharingFileAction) {
                DeltaSharingFileAction deltaSharingFileAction = (DeltaSharingFileAction)deltaSharingAction;
                minVersion$1.elem = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(minVersion$1.elem), Predef$.MODULE$.Long2long(deltaSharingFileAction.version()));
                maxVersion$2.elem = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(maxVersion$2.elem), Predef$.MODULE$.Long2long(deltaSharingFileAction.version()));
                return ((Growable)versionToDeltaSharingFileActions.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(deltaSharingFileAction.version())), (Function0 & Serializable)() -> (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).$plus$eq((Object)deltaSharingFileAction);
            }
            if (deltaSharingAction instanceof DeltaSharingMetadata) {
                DeltaSharingMetadata deltaSharingMetadata = (DeltaSharingMetadata)deltaSharingAction;
                if (deltaSharingMetadata.version() != null) {
                    minVersion$1.elem = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(minVersion$1.elem), Predef$.MODULE$.Long2long(deltaSharingMetadata.version()));
                    maxVersion$2.elem = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(maxVersion$2.elem), Predef$.MODULE$.Long2long(deltaSharingMetadata.version()));
                    versionToMetadata.update((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(deltaSharingMetadata.version())), (Object)deltaSharingMetadata);
                    if (BoxesRunTime.equalsNumObject((Number)deltaSharingMetadata.version(), (Object)BoxesRunTime.boxToLong((long)minVersion$1.elem))) {
                        startingMetadataLineOpt$1.elem = new Some((Object)new StringBuilder(1).append(deltaSharingMetadata.deltaMetadata().json()).append("\n").toString());
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                startingMetadataLineOpt$1.elem = new Some((Object)new StringBuilder(1).append(deltaSharingMetadata.deltaMetadata().json()).append("\n").toString());
                return BoxedUnit.UNIT;
            }
            if (deltaSharingAction instanceof DeltaSharingProtocol) {
                DeltaSharingProtocol deltaSharingProtocol = (DeltaSharingProtocol)deltaSharingAction;
                startingProtocolLineOpt$1.elem = new Some((Object)new StringBuilder(1).append(deltaSharingProtocol.deltaProtocol().json()).append("\n").toString());
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        if (startingVersionOpt.isDefined()) {
            minVersion.elem = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(minVersion.elem), BoxesRunTime.unboxToLong((Object)startingVersionOpt.get()));
        } else if (minVersion.elem == Long.MAX_VALUE) {
            minVersion.elem = 0L;
        }
        if (endingVersionOpt.isDefined()) {
            maxVersion.elem = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(maxVersion.elem), BoxesRunTime.unboxToLong((Object)endingVersionOpt.get()));
        }
        String protocolAndMetadataStr = new StringBuilder(0).append((String)((Option)startingMetadataLineOpt.elem).getOrElse((Function0 & Serializable)() -> "")).append(((Option)startingProtocolLineOpt.elem).getOrElse((Function0 & Serializable)() -> "")).toString();
        ((Growable)versionToJsonLogBuilderMap.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)minVersion.elem), (Function0 & Serializable)() -> (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).$plus$eq((Object)protocolAndMetadataStr);
        long l = minVersion.elem;
        versionToJsonLogSize.update((Object)BoxesRunTime.boxToLong((long)l), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)versionToJsonLogSize.apply((Object)BoxesRunTime.boxToLong((long)l))) + (long)protocolAndMetadataStr.getBytes(StandardCharsets.UTF_8).length)));
        numFileActionsInMinVersion = ((SeqOps)versionToDeltaSharingFileActions.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)minVersion.elem), (Function0 & Serializable)() -> (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).size();
        versionToMetadata.foreach((Function1 & Serializable)x0$1 -> {
            DeltaSharingLogFileSystem$.$anonfun$constructLocalDeltaLogAcrossVersions$9(minVersion, versionToJsonLogBuilderMap, versionToJsonLogSize, x0$1);
            return BoxedUnit.UNIT;
        });
        ObjectRef previousIdOpt = ObjectRef.create((Object)None$.MODULE$);
        versionToDeltaSharingFileActions.foreach((Function1 & Serializable)x0$2 -> {
            DeltaSharingLogFileSystem$.$anonfun$constructLocalDeltaLogAcrossVersions$11(previousIdOpt, idToUrl, versionToTimestampMap, customTablePath, versionToJsonLogBuilderMap, versionToJsonLogSize, minUrlExpirationTimestamp, x0$2);
            return BoxedUnit.UNIT;
        });
        Path encodedTablePath = this.encode(customTablePath);
        String deltaLogPath = new StringBuilder(11).append(encodedTablePath.toString()).append("/_delta_log").toString();
        Builder fileSizeTsSeq = package$.MODULE$.Seq().newBuilder();
        if (minVersion.elem > 0L) {
            this.prepareCheckpointFile(deltaLogPath, minVersion.elem - 1L, (Builder<DeltaSharingLogFileStatus, Seq<DeltaSharingLogFileStatus>>)fileSizeTsSeq);
        }
        new RichLong(Predef$.MODULE$.longWrapper(minVersion.elem)).to((Object)BoxesRunTime.boxToLong((long)maxVersion.elem)).foreach((Function1 & Serializable)version -> DeltaSharingLogFileSystem$.$anonfun$constructLocalDeltaLogAcrossVersions$20(deltaLogPath, versionToJsonLogBuilderMap, fileSizeTsSeq, versionToJsonLogSize, versionToTimestampMap, BoxesRunTime.unboxToLong((Object)version)));
        DeltaSharingUtils$.MODULE$.overrideIteratorBlock(this.getDeltaSharingLogBlockId(deltaLogPath), ((IterableOnceOps)fileSizeTsSeq.result()).toIterator(), ClassTag$.MODULE$.apply(DeltaSharingLogFileStatus.class));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("It takes ").append((double)(System.currentTimeMillis() - startTime) / 1000.0).append("s to construct delta log").append("for ").append(customTablePath).append(" from ").append(minVersion$1.elem).append(" to ").append(maxVersion$2.elem).append(", with ").append(idToUrl.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).size()).append(" urls.").toString());
        return new ConstructedDeltaLogMetadata((scala.collection.immutable.Map<String, String>)idToUrl.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Option<Object>)((Option)minUrlExpirationTimestamp.elem), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numFileActionsInMinVersion)), minVersion.elem, maxVersion.elem);
    }

    private SingleAction setModificationTimestampToZero(SingleAction deltaSingleAction) {
        Action action = deltaSingleAction.unwrap();
        if (action instanceof AddFile) {
            AddFile addFile = (AddFile)action;
            long x$1 = 0L;
            String x$2 = addFile.copy$default$1();
            scala.collection.immutable.Map x$3 = addFile.copy$default$2();
            long x$4 = addFile.copy$default$3();
            boolean x$5 = addFile.copy$default$5();
            String x$6 = addFile.copy$default$6();
            scala.collection.immutable.Map x$7 = addFile.copy$default$7();
            DeletionVectorDescriptor x$8 = addFile.copy$default$8();
            Option x$9 = addFile.copy$default$9();
            Option x$10 = addFile.copy$default$10();
            Option x$11 = addFile.copy$default$11();
            return addFile.copy(x$2, x$3, x$4, 0L, x$5, x$6, x$7, x$8, x$9, x$10, x$11).wrap();
        }
        return deltaSingleAction;
    }

    public ConstructedDeltaLogMetadata constructLocalDeltaLogAtVersionZero(Seq<String> lines, String customTablePath) {
        long startTime = System.currentTimeMillis();
        Builder jsonLogSeq = package$.MODULE$.Seq().newBuilder();
        IntRef jsonLogSize = IntRef.create((int)0);
        ObjectRef minUrlExpirationTimestamp = ObjectRef.create((Object)None$.MODULE$);
        ArrayBuffer fileActionsSeq = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map idToUrl = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        lines.foreach((Function1 & Serializable)line -> {
            DeltaSharingAction action = ((DeltaSharingSingleAction)JsonUtils$.MODULE$.fromJson(line, ManifestFactory$.MODULE$.classType(DeltaSharingSingleAction.class))).unwrap();
            DeltaSharingAction deltaSharingAction = action;
            if (deltaSharingAction instanceof DeltaSharingFileAction) {
                DeltaSharingFileAction deltaSharingFileAction = (DeltaSharingFileAction)deltaSharingAction;
                SingleAction x$1 = MODULE$.setModificationTimestampToZero(deltaSharingFileAction.deltaSingleAction());
                String x$2 = deltaSharingFileAction.copy$default$1();
                Long x$3 = deltaSharingFileAction.copy$default$2();
                Long x$4 = deltaSharingFileAction.copy$default$3();
                Long x$5 = deltaSharingFileAction.copy$default$4();
                String x$6 = deltaSharingFileAction.copy$default$5();
                return fileActionsSeq.$plus$eq((Object)deltaSharingFileAction.copy(x$2, x$3, x$4, x$5, x$6, x$1));
            }
            if (deltaSharingAction instanceof DeltaSharingProtocol) {
                DeltaSharingProtocol deltaSharingProtocol = (DeltaSharingProtocol)deltaSharingAction;
                String protocolJsonStr = new StringBuilder(1).append(deltaSharingProtocol.deltaProtocol().json()).append("\n").toString();
                jsonLogSize$1.elem += protocolJsonStr.getBytes(StandardCharsets.UTF_8).length;
                return jsonLogSeq.$plus$eq((Object)protocolJsonStr);
            }
            if (deltaSharingAction instanceof DeltaSharingMetadata) {
                DeltaSharingMetadata deltaSharingMetadata = (DeltaSharingMetadata)deltaSharingAction;
                String metadataJsonStr = new StringBuilder(1).append(deltaSharingMetadata.deltaMetadata().json()).append("\n").toString();
                jsonLogSize$1.elem += metadataJsonStr.getBytes(StandardCharsets.UTF_8).length;
                return jsonLogSeq.$plus$eq((Object)metadataJsonStr);
            }
            throw new IllegalStateException(new StringBuilder(46).append("unknown action in the delta sharing ").append("response: ").append((String)line).toString());
        });
        ObjectRef previousIdOpt = ObjectRef.create((Object)None$.MODULE$);
        ((IterableOnceOps)fileActionsSeq.toSeq().sortWith((Function2 & Serializable)(f1, f2) -> BoxesRunTime.boxToBoolean((boolean)DeltaSharingLogFileSystem$.MODULE$.deltaSharingFileActionIncreaseOrderFunc(f1, f2)))).foreach((Function1 & Serializable)fileAction -> {
            DeltaSharingLogFileSystem$.$anonfun$constructLocalDeltaLogAtVersionZero$3(previousIdOpt, idToUrl, customTablePath, jsonLogSize, jsonLogSeq, minUrlExpirationTimestamp, fileAction);
            return BoxedUnit.UNIT;
        });
        Path encodedTablePath = this.encode(customTablePath);
        String deltaLogPath = new StringBuilder(11).append(encodedTablePath.toString()).append("/_delta_log").toString();
        String jsonFilePath = FileNames$.MODULE$.unsafeDeltaFile(new Path(deltaLogPath), 0L).toString();
        DeltaSharingUtils$.MODULE$.overrideIteratorBlock(this.getDeltaSharingLogBlockId(jsonFilePath), ((IterableOnceOps)jsonLogSeq.result()).toIterator(), ClassTag$.MODULE$.apply(String.class));
        .colon.colon fileStatusSeq = new .colon.colon((Object)new DeltaSharingLogFileStatus(jsonFilePath, jsonLogSize.elem, 0L), (List)Nil$.MODULE$);
        DeltaSharingUtils$.MODULE$.overrideIteratorBlock(this.getDeltaSharingLogBlockId(deltaLogPath), fileStatusSeq.toIterator(), ClassTag$.MODULE$.apply(DeltaSharingLogFileStatus.class));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("It takes ").append((double)(System.currentTimeMillis() - startTime) / 1000.0).append("s to construct delta").append(" log for ").append(customTablePath).append(" with ").append(jsonLogSize$1.elem).append(" bytes for ").append(idToUrl.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).size()).append(" urls.").toString());
        return new ConstructedDeltaLogMetadata((scala.collection.immutable.Map<String, String>)idToUrl.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Option<Object>)((Option)minUrlExpirationTimestamp.elem), (Option<Object>)None$.MODULE$, 0L, 0L);
    }

    public void constructDeltaLogWithMetadataAtVersionZero(String customTablePath, DeltaSharingUtils.DeltaSharingTableMetadata deltaSharingTableMetadata) {
        Path encodedTablePath = this.encode(customTablePath);
        String deltaLogPath = new StringBuilder(11).append(encodedTablePath.toString()).append("/_delta_log").toString();
        String jsonLogStr = new StringBuilder(2).append(deltaSharingTableMetadata.protocol().deltaProtocol().json()).append("\n").append(deltaSharingTableMetadata.metadata().deltaMetadata().json()).append("\n").toString();
        String jsonFilePath = FileNames$.MODULE$.unsafeDeltaFile(new Path(deltaLogPath), 0L).toString();
        DeltaSharingUtils$.MODULE$.overrideIteratorBlock(this.getDeltaSharingLogBlockId(jsonFilePath), new .colon.colon((Object)jsonLogStr, (List)Nil$.MODULE$).toIterator(), ClassTag$.MODULE$.apply(String.class));
        .colon.colon fileStatusSeq = new .colon.colon((Object)new DeltaSharingLogFileStatus(jsonFilePath, jsonLogStr.getBytes(StandardCharsets.UTF_8).length, 0L), (List)Nil$.MODULE$);
        DeltaSharingUtils$.MODULE$.overrideIteratorBlock(this.getDeltaSharingLogBlockId(deltaLogPath), fileStatusSeq.toIterator(), ClassTag$.MODULE$.apply(DeltaSharingLogFileStatus.class));
    }

    private final boolean shouldCleanUp$1(BlockId blockId, String deltaLogPath$1) {
        if (!blockId.name().startsWith(this.DELTA_SHARING_LOG_BLOCK_ID_PREFIX())) {
            return false;
        }
        String blockName = blockId.name();
        return blockName.startsWith(new StringBuilder(0).append(this.BLOCK_ID_TEST_PREFIX()).append(deltaLogPath$1).toString());
    }

    private final boolean shouldCleanUp$2(BlockId blockId, String deltaLogPath$2, long maxVersion$1) {
        if (!blockId.name().startsWith(this.DELTA_SHARING_LOG_BLOCK_ID_PREFIX())) {
            return false;
        }
        String blockName = blockId.name();
        return blockName.startsWith(new StringBuilder(0).append(this.BLOCK_ID_TEST_PREFIX()).append(deltaLogPath$2).toString()) && FileNames$.MODULE$.getFileVersionOpt(new Path(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(blockName), this.BLOCK_ID_TEST_PREFIX()))).exists((Function1)(JFunction1.mcZJ.sp & Serializable)x$4 -> x$4 <= maxVersion$1);
    }

    public static final /* synthetic */ void $anonfun$constructLocalDeltaLogAcrossVersions$9(LongRef minVersion$1, scala.collection.mutable.Map versionToJsonLogBuilderMap$1, scala.collection.mutable.Map versionToJsonLogSize$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            long version = tuple2._1$mcJ$sp();
            DeltaSharingMetadata metadata = (DeltaSharingMetadata)tuple2._2();
            if (version != minVersion$1.elem) {
                String metadataStr = new StringBuilder(1).append(metadata.deltaMetadata().json()).append("\n").toString();
                ((Growable)versionToJsonLogBuilderMap$1.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)version), (Function0 & Serializable)() -> (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).$plus$eq((Object)metadataStr);
                versionToJsonLogSize$1.update((Object)BoxesRunTime.boxToLong((long)version), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)versionToJsonLogSize$1.apply((Object)BoxesRunTime.boxToLong((long)version))) + (long)metadataStr.getBytes(StandardCharsets.UTF_8).length)));
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$constructLocalDeltaLogAcrossVersions$13(ObjectRef previousIdOpt$1, long version$1, scala.collection.mutable.Map idToUrl$1, scala.collection.mutable.Map versionToTimestampMap$1, String customTablePath$1, scala.collection.mutable.Map versionToJsonLogBuilderMap$1, scala.collection.mutable.Map versionToJsonLogSize$1, ObjectRef minUrlExpirationTimestamp$1, DeltaSharingFileAction fileAction) {
        Predef$.MODULE$.assert(!((Option)previousIdOpt$1.elem).exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.$greater$extension(Predef$.MODULE$.augmentString(x$6), fileAction.id()))), (Function0 & Serializable)() -> new StringBuilder(82).append("fileActions must be in increasing order by id: ").append((Option)previousIdOpt$1.elem).append(" is not smaller than").append(" ").append(fileAction.id()).append(", in version:").append(version$1).append(".").toString());
        previousIdOpt$1.elem = new Some((Object)fileAction.id());
        idToUrl$1.update((Object)fileAction.id(), (Object)fileAction.path());
        if (MODULE$.requiresIdToUrlForDV(fileAction.getDeletionVectorOpt())) {
            idToUrl$1.update((Object)fileAction.deletionVectorFileId(), (Object)((DeletionVectorDescriptor)fileAction.getDeletionVectorOpt().get()).pathOrInlineDv());
        }
        versionToTimestampMap$1.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)version$1), (Function0)(JFunction0.mcJ.sp & Serializable)() -> Predef$.MODULE$.Long2long(fileAction.timestamp()));
        String actionJsonStr = new StringBuilder(1).append(MODULE$.getActionWithDeltaSharingPath(fileAction, customTablePath$1)).append("\n").toString();
        ((Growable)versionToJsonLogBuilderMap$1.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)version$1), (Function0 & Serializable)() -> (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).$plus$eq((Object)actionJsonStr);
        versionToJsonLogSize$1.update((Object)BoxesRunTime.boxToLong((long)version$1), (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)versionToJsonLogSize$1.apply((Object)BoxesRunTime.boxToLong((long)version$1))) + (long)actionJsonStr.getBytes(StandardCharsets.UTF_8).length)));
        if (fileAction.expirationTimestamp() != null) {
            minUrlExpirationTimestamp$1.elem = ((Option)minUrlExpirationTimestamp$1.elem).filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$7 -> x$7 < Predef$.MODULE$.Long2long(fileAction.expirationTimestamp())).orElse((Function0 & Serializable)() -> new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(fileAction.expirationTimestamp()))));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$constructLocalDeltaLogAcrossVersions$11(ObjectRef previousIdOpt$1, scala.collection.mutable.Map idToUrl$1, scala.collection.mutable.Map versionToTimestampMap$1, String customTablePath$1, scala.collection.mutable.Map versionToJsonLogBuilderMap$1, scala.collection.mutable.Map versionToJsonLogSize$1, ObjectRef minUrlExpirationTimestamp$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            long version = tuple2._1$mcJ$sp();
            ArrayBuffer actions = (ArrayBuffer)tuple2._2();
            previousIdOpt$1.elem = None$.MODULE$;
            ((IterableOnceOps)actions.toSeq().sortWith((Function2 & Serializable)(f1, f2) -> BoxesRunTime.boxToBoolean((boolean)DeltaSharingLogFileSystem$.MODULE$.deltaSharingFileActionIncreaseOrderFunc(f1, f2)))).foreach((Function1 & Serializable)fileAction -> {
                DeltaSharingLogFileSystem$.$anonfun$constructLocalDeltaLogAcrossVersions$13(previousIdOpt$1, version, idToUrl$1, versionToTimestampMap$1, customTablePath$1, versionToJsonLogBuilderMap$1, versionToJsonLogSize$1, minUrlExpirationTimestamp$1, fileAction);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Builder $anonfun$constructLocalDeltaLogAcrossVersions$20(String deltaLogPath$3, scala.collection.mutable.Map versionToJsonLogBuilderMap$1, Builder fileSizeTsSeq$1, scala.collection.mutable.Map versionToJsonLogSize$1, scala.collection.mutable.Map versionToTimestampMap$1, long version) {
        String jsonFilePath = FileNames$.MODULE$.unsafeDeltaFile(new Path(deltaLogPath$3), version).toString();
        DeltaSharingUtils$.MODULE$.overrideIteratorBlock(MODULE$.getDeltaSharingLogBlockId(jsonFilePath), ((IterableOnceOps)versionToJsonLogBuilderMap$1.getOrElse((Object)BoxesRunTime.boxToLong((long)version), (Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty())).toIterator(), ClassTag$.MODULE$.apply(String.class));
        return (Builder)fileSizeTsSeq$1.$plus$eq((Object)new DeltaSharingLogFileStatus(jsonFilePath, BoxesRunTime.unboxToLong((Object)versionToJsonLogSize$1.getOrElse((Object)BoxesRunTime.boxToLong((long)version), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)), BoxesRunTime.unboxToLong((Object)versionToTimestampMap$1.get((Object)BoxesRunTime.boxToLong((long)version)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))));
    }

    public static final /* synthetic */ void $anonfun$constructLocalDeltaLogAtVersionZero$3(ObjectRef previousIdOpt$2, scala.collection.mutable.Map idToUrl$2, String customTablePath$2, IntRef jsonLogSize$1, Builder jsonLogSeq$1, ObjectRef minUrlExpirationTimestamp$2, DeltaSharingFileAction fileAction) {
        Predef$.MODULE$.assert(!((Option)previousIdOpt$2.elem).exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.$greater$extension(Predef$.MODULE$.augmentString(x$8), fileAction.id()))), (Function0 & Serializable)() -> new StringBuilder(69).append("fileActions must be in increasing order by id: ").append((Option)previousIdOpt$2.elem).append(" is not smaller than").append(" ").append(fileAction.id()).append(".").toString());
        previousIdOpt$2.elem = new Some((Object)fileAction.id());
        idToUrl$2.update((Object)fileAction.id(), (Object)fileAction.path());
        if (MODULE$.requiresIdToUrlForDV(fileAction.getDeletionVectorOpt())) {
            idToUrl$2.update((Object)fileAction.deletionVectorFileId(), (Object)((DeletionVectorDescriptor)fileAction.getDeletionVectorOpt().get()).pathOrInlineDv());
        }
        String actionJsonStr = new StringBuilder(1).append(MODULE$.getActionWithDeltaSharingPath(fileAction, customTablePath$2)).append("\n").toString();
        jsonLogSize$1.elem += actionJsonStr.getBytes(StandardCharsets.UTF_8).length;
        jsonLogSeq$1.$plus$eq((Object)actionJsonStr);
        if (fileAction.expirationTimestamp() != null) {
            minUrlExpirationTimestamp$2.elem = ((Option)minUrlExpirationTimestamp$2.elem).isDefined() && BoxesRunTime.unboxToLong((Object)((Option)minUrlExpirationTimestamp$2.elem).get()) < Predef$.MODULE$.Long2long(fileAction.expirationTimestamp()) ? (Option)minUrlExpirationTimestamp$2.elem : new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(fileAction.expirationTimestamp())));
            return;
        }
    }

    private DeltaSharingLogFileSystem$() {
    }
}

