/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.actions;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaTablePropertyValidationFailedException;
import org.apache.spark.sql.delta.DeltaTablePropertyValidationFailedSubClass$ExistingDeletionVectorsWithIncrementalManifestGeneration$;
import org.apache.spark.sql.delta.DeltaTablePropertyValidationFailedSubClass$PersistentDeletionVectorsInNonParquetTable$;
import org.apache.spark.sql.delta.DeltaTablePropertyValidationFailedSubClass$PersistentDeletionVectorsWithIncrementalManifestGeneration$;
import org.apache.spark.sql.delta.FeatureAutomaticallyEnabledByMetadata;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.TableFeature;
import org.apache.spark.sql.delta.TableFeature$;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Metadata$;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.TableFeatureProtocolUtils$;
import org.apache.spark.sql.delta.commands.DeletionVectorUtils$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.internal.SQLConf;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Protocol$
implements Serializable {
    public static final Protocol$ MODULE$ = new Protocol$();
    private static final String MIN_READER_VERSION_PROP = "delta.minReaderVersion";
    private static final String MIN_WRITER_VERSION_PROP = "delta.minWriterVersion";

    public String MIN_READER_VERSION_PROP() {
        return MIN_READER_VERSION_PROP;
    }

    public String MIN_WRITER_VERSION_PROP() {
        return MIN_WRITER_VERSION_PROP;
    }

    public Protocol apply(int minReaderVersion, int minWriterVersion) {
        return new Protocol(minReaderVersion, minWriterVersion, (Option<Set<String>>)(TableFeatureProtocolUtils$.MODULE$.supportsReaderFeatures(minReaderVersion) ? new Some(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)) : None$.MODULE$), (Option<Set<String>>)(TableFeatureProtocolUtils$.MODULE$.supportsWriterFeatures(minWriterVersion) ? new Some(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)) : None$.MODULE$));
    }

    public int apply$default$1() {
        return Action$.MODULE$.readerVersion();
    }

    public int apply$default$2() {
        return Action$.MODULE$.writerVersion();
    }

    public Protocol forTableFeature(TableFeature tf) {
        Set writerFeatures = (Set)tf.requiredFeatures().$plus((Object)tf);
        Set readerFeatures = (Set)writerFeatures.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Protocol$.$anonfun$forTableFeature$1(f)));
        Set writerFeaturesNames = (Set)writerFeatures.map((Function1 & Serializable)x$7 -> x$7.name());
        Set readerFeaturesNames = (Set)readerFeatures.map((Function1 & Serializable)x$8 -> x$8.name());
        int minWriterVersion = TableFeatureProtocolUtils$.MODULE$.TABLE_FEATURES_MIN_WRITER_VERSION();
        int minReaderVersion = BoxesRunTime.unboxToInt((Object)((SetOps)readerFeatures.map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.minReaderVersion()))).$plus((Object)BoxesRunTime.boxToInteger((int)1)).max((Ordering)Ordering.Int$.MODULE$));
        return new Protocol(minReaderVersion, minWriterVersion, (Option<Set<String>>)Option$.MODULE$.apply((Object)readerFeaturesNames).filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.nonEmpty())), (Option<Set<String>>)new Some((Object)writerFeaturesNames));
    }

    public Protocol forNewTable(SparkSession spark, Option<Metadata> metadataOpt) {
        Option<Object> x$8;
        Seq<String> x$7;
        String x$6;
        Format x$5;
        String x$4;
        String x$3;
        Metadata metadata;
        SQLConf conf = spark.sessionState().conf();
        boolean ignoreProtocolDefaults = DeltaConfigs$.MODULE$.ignoreProtocolDefaultsIsSet(conf, (Map<String, String>)((Map)metadataOpt.map((Function1 & Serializable)x$11 -> x$11.configuration()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())));
        Map defaultGlobalConf = ignoreProtocolDefaults ? (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MIN_READER_VERSION_PROP()), (Object)Integer.toString(1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MIN_WRITER_VERSION_PROP()), (Object)Integer.toString(1))})) : (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MIN_READER_VERSION_PROP()), (Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_PROTOCOL_DEFAULT_READER_VERSION()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MIN_WRITER_VERSION_PROP()), (Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_PROTOCOL_DEFAULT_WRITER_VERSION()).toString())}));
        Map overrideGlobalConf = (Map)DeltaConfigs$.MODULE$.mergeGlobalConfigs(spark.sessionState().conf(), (Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)ignoreProtocolDefaults))).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Protocol$.$anonfun$forNewTable$3(x0$1)));
        Metadata qual$1 = metadata = (Metadata)metadataOpt.getOrElse((Function0 & Serializable)() -> new Metadata(Metadata$.MODULE$.apply$default$1(), Metadata$.MODULE$.apply$default$2(), Metadata$.MODULE$.apply$default$3(), Metadata$.MODULE$.apply$default$4(), Metadata$.MODULE$.apply$default$5(), Metadata$.MODULE$.apply$default$6(), Metadata$.MODULE$.apply$default$7(), Metadata$.MODULE$.apply$default$8()));
        Map x$1 = (Map)((MapOps)defaultGlobalConf.$plus$plus((IterableOnce)overrideGlobalConf)).$plus$plus(metadata.configuration());
        String x$2 = qual$1.copy$default$1();
        metadata = qual$1.copy(x$2, x$3 = qual$1.copy$default$2(), x$4 = qual$1.copy$default$3(), x$5 = qual$1.copy$default$4(), x$6 = qual$1.copy$default$5(), x$7 = qual$1.copy$default$6(), (Map<String, String>)x$1, x$8 = qual$1.copy$default$8());
        Tuple3<Object, Object, Set<TableFeature>> tuple3 = this.minProtocolComponentsFromMetadata(spark, metadata);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        int readerVersion = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int writerVersion = BoxesRunTime.unboxToInt((Object)tuple3._2());
        Set enabledFeatures = (Set)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)readerVersion), (Object)BoxesRunTime.boxToInteger((int)writerVersion), (Object)enabledFeatures);
        int readerVersion2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
        int writerVersion2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
        Set enabledFeatures2 = (Set)tuple32._3();
        return this.apply(readerVersion2, writerVersion2).withFeatures((Iterable<TableFeature>)enabledFeatures2).denormalizedNormalized();
    }

    private Set<TableFeature> getDependencyClosure(Set<TableFeature> features) {
        while (true) {
            Set requiredFeatures = (Set)features.$plus$plus((IterableOnce)features.flatMap((Function1 & Serializable)x$13 -> x$13.requiredFeatures()));
            Set set = features;
            Set set2 = requiredFeatures;
            if (!(set != null ? !set.equals(set2) : set2 != null)) {
                return features;
            }
            features = requiredFeatures;
        }
    }

    public Set<TableFeature> extractAutomaticallyEnabledFeatures(SparkSession spark, Metadata metadata, Protocol protocol) {
        Set protocolEnabledFeatures = (Set)protocol.writerFeatureNames().flatMap((Function1 & Serializable)featureName -> TableFeature$.MODULE$.featureNameToFeature((String)featureName));
        Set metadataEnabledFeatures = ((IterableOnceOps)TableFeature$.MODULE$.allSupportedFeaturesMap().values().collect((PartialFunction)new Serializable(protocol, metadata, spark){
            private static final long serialVersionUID = 0L;
            private final Protocol protocol$1;
            private final Metadata metadata$1;
            private final SparkSession spark$1;

            public final <A1 extends TableFeature, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                if (A12 instanceof FeatureAutomaticallyEnabledByMetadata && ((FeatureAutomaticallyEnabledByMetadata)((Object)(A1 = A12))).metadataRequiresFeatureToBeEnabled(this.protocol$1, this.metadata$1, this.spark$1)) {
                    return (B1)A1;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(TableFeature x1) {
                TableFeature tableFeature;
                TableFeature tableFeature2 = x1;
                return tableFeature2 instanceof FeatureAutomaticallyEnabledByMetadata && ((FeatureAutomaticallyEnabledByMetadata)((Object)(tableFeature = tableFeature2))).metadataRequiresFeatureToBeEnabled(this.protocol$1, this.metadata$1, this.spark$1);
            }
            {
                this.protocol$1 = protocol$1;
                this.metadata$1 = metadata$1;
                this.spark$1 = spark$1;
            }
        })).toSet();
        return this.getDependencyClosure((Set<TableFeature>)((Set)protocolEnabledFeatures.$plus$plus((IterableOnce)metadataEnabledFeatures)));
    }

    /*
     * Unable to fully structure code
     */
    public Tuple3<Object, Object, Set<TableFeature>> minProtocolComponentsFromMetadata(SparkSession spark, Metadata metadata) {
        tableConf = metadata.configuration();
        tablePropEnabledFeatures = TableFeatureProtocolUtils$.MODULE$.getSupportedFeaturesFromTableConfigs(tableConf);
        metaEnabledFeatures = this.extractAutomaticallyEnabledFeatures(spark, metadata, this.apply(this.apply$default$1(), this.apply$default$2()).withFeatures((Iterable<TableFeature>)tablePropEnabledFeatures));
        allEnabledFeatures = (Set)tablePropEnabledFeatures.$plus$plus(metaEnabledFeatures);
        var10_7 = this.getProtocolVersionsFromTableConf(tableConf);
        if (var10_7 == null) {
            throw new MatchError(var10_7);
        }
        readerVersionFromTableConfOpt = (Option)var10_7._1();
        writerVersionFromTableConfOpt = (Option)var10_7._2();
        var9_10 = new Tuple2((Object)readerVersionFromTableConfOpt, (Object)writerVersionFromTableConfOpt);
        readerVersionFromTableConfOpt = (Option)var9_10._1();
        writerVersionFromTableConfOpt = (Option)var9_10._2();
        var16_13 = new Tuple2((Object)readerVersionFromTableConfOpt, (Object)writerVersionFromTableConfOpt);
        if (var16_13 == null) ** GOTO lbl-1000
        var17_14 = (Option)var16_13._1();
        var18_15 = (Option)var16_13._2();
        if (!(var17_14 instanceof Some)) ** GOTO lbl-1000
        var19_16 = (Some)var17_14;
        readerVersion = BoxesRunTime.unboxToInt((Object)var19_16.value());
        if (var18_15 instanceof Some) {
            var21_18 = (Some)var18_15;
            writerVersion = BoxesRunTime.unboxToInt((Object)var21_18.value());
            sanitizedReaderVersion = TableFeatureProtocolUtils$.MODULE$.supportsWriterFeatures(writerVersion) != false ? readerVersion : Math.min(2, readerVersion);
            v0 = this.apply(sanitizedReaderVersion, writerVersion).implicitlySupportedFeatures();
        } else lbl-1000:
        // 3 sources

        {
            v0 = Predef$.MODULE$.Set().empty();
        }
        implicitFeaturesFromTableConf = v0;
        minProtocol = this.apply(TableFeatureProtocolUtils$.MODULE$.TABLE_FEATURES_MIN_READER_VERSION(), TableFeatureProtocolUtils$.MODULE$.TABLE_FEATURES_MIN_WRITER_VERSION()).withFeatures((Iterable<TableFeature>)((Iterable)allEnabledFeatures.$plus$plus((IterableOnce)implicitFeaturesFromTableConf))).normalized();
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)minProtocol.minReaderVersion()), (Object)BoxesRunTime.boxToInteger((int)minProtocol.minWriterVersion()), minProtocol.implicitlyAndExplicitlySupportedFeatures());
    }

    public Tuple3<Object, Object, Set<TableFeature>> minProtocolComponentsFromAutomaticallyEnabledFeatures(SparkSession spark, Metadata metadata, Protocol current) {
        Set<TableFeature> enabledFeatures = this.extractAutomaticallyEnabledFeatures(spark, metadata, current);
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(0, 0);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int readerVersion = sp2._1$mcI$sp();
        int writerVersion = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(readerVersion, writerVersion);
        IntRef readerVersion2 = IntRef.create((int)sp3._1$mcI$sp());
        IntRef writerVersion2 = IntRef.create((int)sp3._2$mcI$sp());
        enabledFeatures.foreach((Function1 & Serializable)feature -> {
            Protocol$.$anonfun$minProtocolComponentsFromAutomaticallyEnabledFeatures$1(readerVersion2, writerVersion2, feature);
            return BoxedUnit.UNIT;
        });
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)readerVersion2.elem), (Object)BoxesRunTime.boxToInteger((int)writerVersion2.elem), enabledFeatures);
    }

    private int tryCastProtocolVersionToInt(String key, String value) {
        int n;
        try {
            n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(value));
        }
        catch (NumberFormatException numberFormatException) {
            throw DeltaErrors$.MODULE$.protocolPropNotIntException(key, value);
        }
        return n;
    }

    public Option<Object> getReaderVersionFromTableConf(Map<String, String> conf) {
        return conf.get((Object)this.MIN_READER_VERSION_PROP()).map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)Protocol$.MODULE$.tryCastProtocolVersionToInt(Protocol$.MODULE$.MIN_READER_VERSION_PROP(), x$16)));
    }

    public Option<Object> getWriterVersionFromTableConf(Map<String, String> conf) {
        return conf.get((Object)this.MIN_WRITER_VERSION_PROP()).map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)Protocol$.MODULE$.tryCastProtocolVersionToInt(Protocol$.MODULE$.MIN_WRITER_VERSION_PROP(), x$17)));
    }

    public Tuple2<Option<Object>, Option<Object>> getProtocolVersionsFromTableConf(Map<String, String> conf) {
        return new Tuple2(this.getReaderVersionFromTableConf(conf), this.getWriterVersionFromTableConf(conf));
    }

    public Map<String, String> filterProtocolPropsFromTableProps(Map<String, String> properties) {
        return (Map)properties.filterNot((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Protocol$.$anonfun$filterProtocolPropsFromTableProps$1(x0$1)));
    }

    public void assertMetadataContainsNoProtocolProps(Metadata metadata) {
        Predef$.MODULE$.assert(!metadata.configuration().contains((Object)this.MIN_READER_VERSION_PROP()), (Function0 & Serializable)() -> new StringBuilder(67).append("Should not have the ").append("protocol version (").append(MODULE$.MIN_READER_VERSION_PROP()).append(") as part of table properties").toString());
        Predef$.MODULE$.assert(!metadata.configuration().contains((Object)this.MIN_WRITER_VERSION_PROP()), (Function0 & Serializable)() -> new StringBuilder(67).append("Should not have the ").append("protocol version (").append(MODULE$.MIN_WRITER_VERSION_PROP()).append(") as part of table properties").toString());
        Predef$.MODULE$.assert(!metadata.configuration().keys().exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.startsWith(TableFeatureProtocolUtils$.MODULE$.FEATURE_PROP_PREFIX()))), (Function0 & Serializable)() -> new StringBuilder(75).append("Should not have ").append("table features (starts with '").append(TableFeatureProtocolUtils$.MODULE$.FEATURE_PROP_PREFIX()).append("') as part of table properties").toString());
        Predef$.MODULE$.assert(!metadata.configuration().contains((Object)DeltaConfigs$.MODULE$.CREATE_TABLE_IGNORE_PROTOCOL_DEFAULTS().key()), (Function0 & Serializable)() -> new StringBuilder(60).append("Should not have the table property ").append(DeltaConfigs$.MODULE$.CREATE_TABLE_IGNORE_PROTOCOL_DEFAULTS().key()).append(" stored in table metadata").toString());
    }

    public Option<Protocol> upgradeProtocolFromMetadataForExistingTable(SparkSession spark, Metadata metadata, Protocol current) {
        Protocol required = this.apply(TableFeatureProtocolUtils$.MODULE$.TABLE_FEATURES_MIN_READER_VERSION(), TableFeatureProtocolUtils$.MODULE$.TABLE_FEATURES_MIN_WRITER_VERSION()).withFeatures((Iterable<TableFeature>)this.extractAutomaticallyEnabledFeatures(spark, metadata, current)).normalized();
        if (!required.canUpgradeTo(current)) {
            this.assertMetadataTableFeaturesAutomaticallySupported(current.implicitlyAndExplicitlySupportedFeatures(), required.implicitlyAndExplicitlySupportedFeatures());
            return new Some((Object)required.merge((Seq<Protocol>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Protocol[]{current})));
        }
        return None$.MODULE$;
    }

    private void assertMetadataTableFeaturesAutomaticallySupported(Set<TableFeature> currentFeatures, Set<TableFeature> requiredFeatures) {
        Tuple2 tuple2 = ((IterableOps)requiredFeatures.diff(currentFeatures).collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends TableFeature, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof FeatureAutomaticallyEnabledByMetadata) {
                    A1 A12 = A1;
                    return (B1)A12;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(TableFeature x1) {
                TableFeature tableFeature = x1;
                return tableFeature instanceof FeatureAutomaticallyEnabledByMetadata;
            }
        })).partition((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)Protocol$.$anonfun$assertMetadataTableFeaturesAutomaticallySupported$1(x$19)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Set autoUpdateCapableFeatures = (Set)tuple2._1();
        Set nonAutoUpdateCapableFeatures = (Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)autoUpdateCapableFeatures, (Object)nonAutoUpdateCapableFeatures);
        Set autoUpdateCapableFeatures2 = (Set)tuple22._1();
        Set nonAutoUpdateCapableFeatures2 = (Set)tuple22._2();
        if (nonAutoUpdateCapableFeatures2.nonEmpty()) {
            throw DeltaErrors$.MODULE$.tableFeaturesRequireManualEnablementException((Iterable<TableFeature>)nonAutoUpdateCapableFeatures2, (Iterable<TableFeature>)((Iterable)currentFeatures.$plus$plus((IterableOnce)autoUpdateCapableFeatures2)));
        }
    }

    public void assertTablePropertyConstraintsSatisfied(SparkSession spark, Metadata metadata, Snapshot snapshot) {
        String lowerCaseKey;
        String tableName = metadata.name() != null ? metadata.name() : metadata.id();
        Map configs = (Map)metadata.configuration().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k.toLowerCase(Locale.ROOT)), (Object)v);
            }
            throw new MatchError((Object)tuple2);
        });
        boolean dvsEnabled = configs.get((Object)(lowerCaseKey = DeltaConfigs$.MODULE$.ENABLE_DELETION_VECTORS_CREATION().key().toLowerCase(Locale.ROOT))).exists((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$21))));
        if (dvsEnabled) {
            String string = metadata.format().provider();
            String string2 = "parquet";
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new DeltaTablePropertyValidationFailedException(tableName, DeltaTablePropertyValidationFailedSubClass$PersistentDeletionVectorsInNonParquetTable$.MODULE$);
            }
        }
        String lowerCaseKey2 = DeltaConfigs$.MODULE$.SYMLINK_FORMAT_MANIFEST_ENABLED().key().toLowerCase(Locale.ROOT);
        boolean manifestGenerationEnabled = configs.get((Object)lowerCaseKey2).exists((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$22))));
        if (dvsEnabled && manifestGenerationEnabled) {
            throw new DeltaTablePropertyValidationFailedException(tableName, DeltaTablePropertyValidationFailedSubClass$PersistentDeletionVectorsWithIncrementalManifestGeneration$.MODULE$);
        }
        if (manifestGenerationEnabled) {
            if (!DeletionVectorUtils$.MODULE$.isTableDVFree(snapshot)) {
                throw new DeltaTablePropertyValidationFailedException(tableName, DeltaTablePropertyValidationFailedSubClass$ExistingDeletionVectorsWithIncrementalManifestGeneration$.MODULE$);
            }
            return;
        }
    }

    public Protocol apply(int minReaderVersion, int minWriterVersion, Option<Set<String>> readerFeatures, Option<Set<String>> writerFeatures) {
        return new Protocol(minReaderVersion, minWriterVersion, readerFeatures, writerFeatures);
    }

    public Option<Tuple4<Object, Object, Option<Set<String>>, Option<Set<String>>>> unapply(Protocol x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)x$0.minReaderVersion()), (Object)BoxesRunTime.boxToInteger((int)x$0.minWriterVersion()), x$0.readerFeatures(), x$0.writerFeatures()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Protocol$.class);
    }

    public static final /* synthetic */ boolean $anonfun$forTableFeature$1(TableFeature f) {
        return f.isReaderWriterFeature() && !f.isLegacyFeature();
    }

    public static final /* synthetic */ boolean $anonfun$forNewTable$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return TableFeatureProtocolUtils$.MODULE$.isTableProtocolProperty(k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$minProtocolComponentsFromAutomaticallyEnabledFeatures$1(IntRef readerVersion$1, IntRef writerVersion$1, TableFeature feature) {
        readerVersion$1.elem = package$.MODULE$.max(readerVersion$1.elem, feature.minReaderVersion());
        writerVersion$1.elem = package$.MODULE$.max(writerVersion$1.elem, feature.minWriterVersion());
    }

    public static final /* synthetic */ boolean $anonfun$filterProtocolPropsFromTableProps$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return TableFeatureProtocolUtils$.MODULE$.isTableProtocolProperty(k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$assertMetadataTableFeaturesAutomaticallySupported$1(TableFeature x$19) {
        return ((FeatureAutomaticallyEnabledByMetadata)((Object)x$19)).automaticallyUpdateProtocolOfExistingTables();
    }

    private Protocol$() {
    }
}

