/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.catalog;

import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaTableIdentifier;
import org.apache.spark.sql.delta.DeltaTableIdentifier$;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.catalog.DeltaTableV2$;
import org.apache.spark.sql.delta.sources.DeltaSourceUtils$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;

public final class CatalogResolver$ {
    public static final CatalogResolver$ MODULE$ = new CatalogResolver$();

    private DeltaTableV2 asDeltaTable(SparkSession spark, Table table) {
        V1Table v1Table;
        Table table2 = table;
        if (table2 instanceof DeltaTableV2) {
            DeltaTableV2 deltaTableV2 = (DeltaTableV2)table2;
            return deltaTableV2;
        }
        if (table2 instanceof V1Table && DeltaSourceUtils$.MODULE$.isDeltaTable((Option<String>)(v1Table = (V1Table)table2).v1Table().provider())) {
            return DeltaTableV2$.MODULE$.apply(spark, new Path(v1Table.v1Table().location()), (Option<CatalogTable>)new Some((Object)v1Table.v1Table()), DeltaTableV2$.MODULE$.apply$default$4(), DeltaTableV2$.MODULE$.apply$default$5(), DeltaTableV2$.MODULE$.apply$default$6());
        }
        Some x$1 = new Some((Object)TableIdentifier$.MODULE$.apply(table.name()));
        Option<String> x$2 = DeltaTableIdentifier$.MODULE$.apply$default$1();
        throw DeltaErrors$.MODULE$.notADeltaTableException(new DeltaTableIdentifier(x$2, (Option<TableIdentifier>)x$1));
    }

    public Tuple2<CatalogPlugin, Identifier> getCatalogPluginAndIdentifier(SparkSession spark, String catalog, Seq<String> ident) {
        return new Tuple2((Object)spark.sessionState().catalogManager().catalog(catalog), (Object)CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(ident).asIdentifier());
    }

    public DeltaTableV2 getDeltaTableFromCatalog(SparkSession spark, CatalogPlugin catalog, Identifier ident) {
        TableCatalog tblCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog();
        if (tblCatalog.tableExists(ident)) {
            return this.asDeltaTable(spark, tblCatalog.loadTable(ident));
        }
        Some x$1 = new Some((Object)TableIdentifier$.MODULE$.apply(ident.name()));
        Option<String> x$2 = DeltaTableIdentifier$.MODULE$.apply$default$1();
        throw DeltaErrors$.MODULE$.nonExistentDeltaTable(new DeltaTableIdentifier(x$2, (Option<TableIdentifier>)x$1));
    }

    private CatalogResolver$() {
    }
}

