/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.IgnoreCachedData;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.delta.CheckpointProtectionTableFeature$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.NumRecordsStats;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.RemovableFeature;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.TableFeature;
import org.apache.spark.sql.delta.TableFeature$;
import org.apache.spark.sql.delta.TruncationGranularity$;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DropTableFeatureUtils$;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.commands.AlterDeltaTableCommand;
import org.apache.spark.sql.delta.commands.AlterTableDropFeatureDeltaCommand$;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.DeltaCommandInvariants;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u001db\u0001\u0002\u0012$\u0001BB\u0001\u0002\u0018\u0001\u0003\u0016\u0004%\t!\u0018\u0005\tI\u0002\u0011\t\u0012)A\u0005=\"AQ\r\u0001BK\u0002\u0013\u0005a\r\u0003\u0005p\u0001\tE\t\u0015!\u0003h\u0011!\u0001\bA!f\u0001\n\u0003\t\b\u0002C;\u0001\u0005#\u0005\u000b\u0011\u0002:\t\u000bY\u0004A\u0011A<\t\u000fq\u0004!\u0019!C\u0005{\"9\u00111\u0001\u0001!\u0002\u0013q\bbBA\u0003\u0001\u0011\u0005\u0013q\u0001\u0005\b\u0003C\u0001A\u0011BA\u0012\u0011\u001d\ty\u0004\u0001C\u0005\u0003\u0003Bq!a\u0013\u0001\t\u0013\ti\u0005C\u0005\u0002h\u0001\t\t\u0011\"\u0001\u0002j!I\u0011\u0011\u000f\u0001\u0012\u0002\u0013\u0005\u00111\u000f\u0005\n\u0003\u0013\u0003\u0011\u0013!C\u0001\u0003\u0017C\u0011\"a$\u0001#\u0003%\t!!%\t\u0013\u0005U\u0005!!A\u0005B\u0005]\u0005\u0002CAT\u0001\u0005\u0005I\u0011A?\t\u0013\u0005%\u0006!!A\u0005\u0002\u0005-\u0006\"CA\\\u0001\u0005\u0005I\u0011IA]\u0011%\t9\rAA\u0001\n\u0003\tI\rC\u0005\u0002N\u0002\t\t\u0011\"\u0011\u0002P\"I\u00111\u001b\u0001\u0002\u0002\u0013\u0005\u0013Q[\u0004\n\u00033\u001c\u0013\u0011!E\u0001\u000374\u0001BI\u0012\u0002\u0002#\u0005\u0011Q\u001c\u0005\u0007mj!\t!!>\t\u0013\u0005]($!A\u0005F\u0005e\b\"CA~5\u0005\u0005I\u0011QA\u007f\u0011%\u0011)AGI\u0001\n\u0003\t\t\nC\u0005\u0003\bi\t\t\u0011\"!\u0003\n!I!1\u0004\u000e\u0012\u0002\u0013\u0005\u0011\u0011\u0013\u0005\n\u0005;Q\u0012\u0011!C\u0005\u0005?\u0011\u0011%\u00117uKJ$\u0016M\u00197f\tJ|\u0007OR3biV\u0014X\rR3mi\u0006\u001cu.\\7b]\u0012T!\u0001J\u0013\u0002\u0011\r|W.\\1oINT!AJ\u0014\u0002\u000b\u0011,G\u000e^1\u000b\u0005!J\u0013aA:rY*\u0011!fK\u0001\u0006gB\f'o\u001b\u0006\u0003Y5\na!\u00199bG\",'\"\u0001\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001\t4hQ$K!B\u0011!'O\u0007\u0002g)\u0011A'N\u0001\bY><\u0017nY1m\u0015\t1t'A\u0003qY\u0006t7O\u0003\u00029O\u0005A1-\u0019;bYf\u001cH/\u0003\u0002;g\tYAj\\4jG\u0006d\u0007\u000b\\1o!\ta\u0014)D\u0001>\u0015\tqt(A\u0004d_6l\u0017M\u001c3\u000b\u0005\u0001;\u0013!C3yK\u000e,H/[8o\u0013\t\u0011UHA\nMK\u00064'+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002E\u000b6\t1%\u0003\u0002GG\t1\u0012\t\u001c;fe\u0012+G\u000e^1UC\ndWmQ8n[\u0006tG\r\u0005\u00023\u0011&\u0011\u0011j\r\u0002\u0011\u0013\u001etwN]3DC\u000eDW\r\u001a#bi\u0006\u0004\"a\u0013(\u000e\u00031S\u0011!T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f2\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002R3:\u0011!k\u0016\b\u0003'Zk\u0011\u0001\u0016\u0006\u0003+>\na\u0001\u0010:p_Rt\u0014\"A'\n\u0005ac\u0015a\u00029bG.\fw-Z\u0005\u00035n\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0017'\u0002\u000bQ\f'\r\\3\u0016\u0003y\u0003\"a\u00182\u000e\u0003\u0001T!!Y\u0013\u0002\u000f\r\fG/\u00197pO&\u00111\r\u0019\u0002\r\t\u0016dG/\u0019+bE2,gKM\u0001\u0007i\u0006\u0014G.\u001a\u0011\u0002\u0017\u0019,\u0017\r^;sK:\u000bW.Z\u000b\u0002OB\u0011\u0001\u000e\u001c\b\u0003S*\u0004\"a\u0015'\n\u0005-d\u0015A\u0002)sK\u0012,g-\u0003\u0002n]\n11\u000b\u001e:j]\u001eT!a\u001b'\u0002\u0019\u0019,\u0017\r^;sK:\u000bW.\u001a\u0011\u0002\u001fQ\u0014XO\\2bi\u0016D\u0015n\u001d;pef,\u0012A\u001d\t\u0003\u0017NL!\u0001\u001e'\u0003\u000f\t{w\u000e\\3b]\u0006\u0001BO];oG\u0006$X\rS5ti>\u0014\u0018\u0010I\u0001\u0007y%t\u0017\u000e\u001e \u0015\taL(p\u001f\t\u0003\t\u0002AQ\u0001X\u0004A\u0002yCQ!Z\u0004A\u0002\u001dDq\u0001]\u0004\u0011\u0002\u0003\u0007!/A\u000fO+6\u0013UIU0P\r~\u0013\u0015I\u0015*J\u000bJ{6\tS#D\u0017B{\u0015J\u0014+T+\u0005q\bCA&\u0000\u0013\r\t\t\u0001\u0014\u0002\u0004\u0013:$\u0018A\b(V\u001b\n+%kX(G?\n\u000b%KU%F%~\u001b\u0005*R\"L!>Ke\nV*!\u0003\r\u0011XO\u001c\u000b\u0005\u0003\u0013\t9\u0002E\u0003R\u0003\u0017\ty!C\u0002\u0002\u000em\u00131aU3r!\u0011\t\t\"a\u0005\u000e\u0003\u001dJ1!!\u0006(\u0005\r\u0011vn\u001e\u0005\b\u00033Q\u0001\u0019AA\u000e\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\u0011\t\t\"!\b\n\u0007\u0005}qE\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0014fq\u0016\u001cW\u000f^3Ee>\u0004h)Z1ukJ,w+\u001b;i\u0011&\u001cHo\u001c:z)J,hnY1uS>tGCBA\u0005\u0003K\t9\u0003C\u0004\u0002\u001a-\u0001\r!a\u0007\t\u000f\u0005%2\u00021\u0001\u0002,\u0005\u0001\"/Z7pm\u0006\u0014G.\u001a$fCR,(/\u001a\n\u0007\u0003[\t\t$!\u000f\u0007\r\u0005=\u0002\u0001AA\u0016\u00051a$/\u001a4j]\u0016lWM\u001c;?!\u0011\t\u0019$!\u000e\u000e\u0003\u0015J1!a\u000e&\u00051!\u0016M\u00197f\r\u0016\fG/\u001e:f!\u0011\t\u0019$a\u000f\n\u0007\u0005uRE\u0001\tSK6|g/\u00192mK\u001a+\u0017\r^;sK\u0006QS\r_3dkR,GI]8q\r\u0016\fG/\u001e:f/&$\bn\u00115fG.\u0004x.\u001b8u!J|G/Z2uS>tGCBA\u0005\u0003\u0007\n)\u0005C\u0004\u0002\u001a1\u0001\r!a\u0007\t\u000f\u0005%B\u00021\u0001\u0002HI1\u0011\u0011JA\u0019\u0003s1a!a\f\u0001\u0001\u0005\u001d\u0013!\u00063fa\u0016tG-\u001a8u\r\u0016\fG/\u001e:f\u0007\",7m\u001b\u000b\u0007\u0003\u001f\n)&a\u0016\u0011\u0007-\u000b\t&C\u0002\u0002T1\u0013A!\u00168ji\"9\u0011\u0011F\u0007A\u0002\u0005E\u0002bBA-\u001b\u0001\u0007\u00111L\u0001\taJ|Go\\2pYB!\u0011QLA2\u001b\t\tyFC\u0002\u0002b\u0015\nq!Y2uS>t7/\u0003\u0003\u0002f\u0005}#\u0001\u0003)s_R|7m\u001c7\u0002\t\r|\u0007/\u001f\u000b\bq\u0006-\u0014QNA8\u0011\u001daf\u0002%AA\u0002yCq!\u001a\b\u0011\u0002\u0003\u0007q\rC\u0004q\u001dA\u0005\t\u0019\u0001:\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u000f\u0016\u0004=\u0006]4FAA=!\u0011\tY(!\"\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\rE*\u0001\u0006b]:|G/\u0019;j_:LA!a\"\u0002~\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0012\u0016\u0004O\u0006]\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003'S3A]A<\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u0014\t\u0005\u00037\u000b)+\u0004\u0002\u0002\u001e*!\u0011qTAQ\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0016\u0001\u00026bm\u0006L1!\\AO\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!,\u00024B\u00191*a,\n\u0007\u0005EFJA\u0002B]fD\u0001\"!.\u0015\u0003\u0003\u0005\rA`\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005m\u0006CBA_\u0003\u0007\fi+\u0004\u0002\u0002@*\u0019\u0011\u0011\u0019'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002F\u0006}&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2A]Af\u0011%\t)LFA\u0001\u0002\u0004\ti+\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAM\u0003#D\u0001\"!.\u0018\u0003\u0003\u0005\rA`\u0001\u0007KF,\u0018\r\\:\u0015\u0007I\f9\u000eC\u0005\u00026b\t\t\u00111\u0001\u0002.\u0006\t\u0013\t\u001c;feR\u000b'\r\\3Ee>\u0004h)Z1ukJ,G)\u001a7uC\u000e{W.\\1oIB\u0011AIG\n\u00065\u0005}\u00171\u001e\t\t\u0003C\f9OX4sq6\u0011\u00111\u001d\u0006\u0004\u0003Kd\u0015a\u0002:v]RLW.Z\u0005\u0005\u0003S\f\u0019OA\tBEN$(/Y2u\rVt7\r^5p]N\u0002B!!<\u0002t6\u0011\u0011q\u001e\u0006\u0005\u0003c\f\t+\u0001\u0002j_&\u0019!,a<\u0015\u0005\u0005m\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005e\u0015!B1qa2LHc\u0002=\u0002\u0000\n\u0005!1\u0001\u0005\u00069v\u0001\rA\u0018\u0005\u0006Kv\u0001\ra\u001a\u0005\bav\u0001\n\u00111\u0001s\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0017\u00119\u0002E\u0003L\u0005\u001b\u0011\t\"C\u0002\u0003\u00101\u0013aa\u00149uS>t\u0007CB&\u0003\u0014y;'/C\u0002\u0003\u00161\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B\r?\u0005\u0005\t\u0019\u0001=\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005C\u0001B!a'\u0003$%!!QEAO\u0005\u0019y%M[3di\u0002")
public class AlterTableDropFeatureDeltaCommand
extends LogicalPlan
implements LeafRunnableCommand,
AlterDeltaTableCommand,
IgnoreCachedData,
Serializable {
    private final DeltaTableV2 table;
    private final String featureName;
    private final boolean truncateHistory;
    private final int NUMBER_OF_BARRIER_CHECKPOINTS;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return AlterTableDropFeatureDeltaCommand$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<DeltaTableV2, String, Object>> unapply(AlterTableDropFeatureDeltaCommand x$0) {
        return AlterTableDropFeatureDeltaCommand$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$3() {
        return AlterTableDropFeatureDeltaCommand$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<DeltaTableV2, String, Object>, AlterTableDropFeatureDeltaCommand> tupled() {
        return AlterTableDropFeatureDeltaCommand$.MODULE$.tupled();
    }

    public static Function1<DeltaTableV2, Function1<String, Function1<Object, AlterTableDropFeatureDeltaCommand>>> curried() {
        return AlterTableDropFeatureDeltaCommand$.MODULE$.curried();
    }

    @Override
    public OptimisticTransaction startTransaction() {
        return AlterDeltaTableCommand.startTransaction$(this);
    }

    @Override
    public void checkDependentExpressions(SparkSession sparkSession, Seq<String> columnParts, Metadata oldMetadata, Protocol protocol) {
        AlterDeltaTableCommand.checkDependentExpressions$(this, sparkSession, columnParts, oldMetadata, protocol);
    }

    @Override
    public Seq<Expression> parsePredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String escapedFilePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, escapedFilePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$(this, analyzer, tableIdent);
    }

    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$(this, tableIdent);
    }

    @Override
    public DeltaLog getDeltaLog(SparkSession spark, Option<String> path, Option<TableIdentifier> tableIdentifier, String operationName, Map<String, String> hadoopConf) {
        return DeltaCommand.getDeltaLog$(this, spark, path, tableIdentifier, operationName, hadoopConf);
    }

    @Override
    public Map<String, String> getDeltaLog$default$5() {
        return DeltaCommand.getDeltaLog$default$5$(this);
    }

    @Override
    public void sendDriverMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        DeltaCommand.sendDriverMetrics$(this, spark, metrics);
    }

    @Override
    public DeltaTableV2 getDeltaTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTable$(this, target, cmd);
    }

    @Override
    public Option<CatalogTable> getTableCatalogTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getTableCatalogTable$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getDeltaTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public boolean hasBeenExecuted(OptimisticTransaction txn, SparkSession sparkSession, Option<DeltaOptions> options) {
        return DeltaCommand.hasBeenExecuted$(this, txn, sparkSession, options);
    }

    @Override
    public Option<DeltaOptions> hasBeenExecuted$default$3() {
        return DeltaCommand.hasBeenExecuted$default$3$(this);
    }

    @Override
    public Option<SetTransaction> createSetTransaction(SparkSession sparkSession, DeltaLog deltaLog, Option<DeltaOptions> options) {
        return DeltaCommand.createSetTransaction$(this, sparkSession, deltaLog, options);
    }

    @Override
    public Option<DeltaOptions> createSetTransaction$default$3() {
        return DeltaCommand.createSetTransaction$default$3$(this);
    }

    @Override
    public void logNumRecordsMismatch(DeltaLog deltaLog, Seq<Action> actions, NumRecordsStats stats, DeltaOperations.Operation op) {
        DeltaCommand.logNumRecordsMismatch$(this, deltaLog, actions, stats, op);
    }

    @Override
    public void checkCommandInvariant(Function0<Object> invariant, String label, DeltaOperations.Operation op, DeltaLog deltaLog, Function0<Map<String, Object>> parameters, Function0<Map<String, String>> additionalInfo) {
        DeltaCommandInvariants.checkCommandInvariant$(this, invariant, label, op, deltaLog, parameters, additionalInfo);
    }

    @Override
    public Map<String, String> checkCommandInvariant$default$6() {
        return DeltaCommandInvariants.checkCommandInvariant$default$6$(this);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableDropFeatureDeltaCommand alterTableDropFeatureDeltaCommand = this;
        synchronized (alterTableDropFeatureDeltaCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        if (!this.bitmap$0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public DeltaTableV2 table() {
        return this.table;
    }

    public String featureName() {
        return this.featureName;
    }

    public boolean truncateHistory() {
        return this.truncateHistory;
    }

    private int NUMBER_OF_BARRIER_CHECKPOINTS() {
        return this.NUMBER_OF_BARRIER_CHECKPOINTS;
    }

    /*
     * Unable to fully structure code
     */
    public Seq<Row> run(SparkSession sparkSession) {
        block12: {
            block11: {
                var4_2 = false;
                var5_3 = null;
                var6_4 = TableFeature$.MODULE$.featureNameToFeature(this.featureName());
                if (!(var6_4 instanceof Some)) break block11;
                var4_2 = true;
                var5_3 = (Some)var6_4;
                feature = (TableFeature)var5_3.value();
                if (feature instanceof RemovableFeature) break block12;
            }
            if (var4_2) {
                throw DeltaErrors$.MODULE$.dropTableFeatureNonRemovableFeature(this.featureName());
            }
            if (None$.MODULE$.equals(var6_4)) {
                throw DeltaErrors$.MODULE$.dropTableFeatureFeatureNotSupportedByClient(this.featureName());
            }
            throw new MatchError(var6_4);
        }
        var8_6 = feature;
        removableFeature = var8_6;
        x$1 = this.table().catalogTable();
        x$2 = this.table().deltaLog().update$default$1();
        x$3 = this.table().deltaLog().update$default$2();
        protocol = this.table().deltaLog().update(x$2, x$3, x$1).protocol();
        protocolContainsFeatureName = ((SetOps)protocol.implicitlyAndExplicitlySupportedFeatures().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$run$7(org.apache.spark.sql.delta.TableFeature ), (Lorg/apache/spark/sql/delta/TableFeature;)Ljava/lang/String;)())).contains((Object)this.featureName());
        if (!protocolContainsFeatureName) {
            throw DeltaErrors$.MODULE$.dropTableFeatureFeatureNotSupportedByProtocol(this.featureName());
        }
        if (((RemovableFeature)removableFeature).requiresHistoryProtection()) ** GOTO lbl-1000
        v0 = removableFeature;
        var15_13 = CheckpointProtectionTableFeature$.MODULE$;
        if (!(v0 != null ? v0.equals(var15_13) == false : var15_13 != null)) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = historyTruncationEligibleFeature = false;
        }
        if (this.truncateHistory() && !historyTruncationEligibleFeature) {
            throw DeltaErrors$.MODULE$.tableFeatureDropHistoryTruncationNotAllowed();
        }
        v2 = removableFeature;
        var16_15 = CheckpointProtectionTableFeature$.MODULE$;
        if (!(v2 != null ? v2.equals(var16_15) == false : var16_15 != null) && !this.truncateHistory()) {
            throw DeltaErrors$.MODULE$.canOnlyDropCheckpointProtectionWithHistoryTruncationException();
        }
        this.dependentFeatureCheck(removableFeature, protocol);
        if (!this.truncateHistory() && BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(DeltaSQLConf$.MODULE$.FAST_DROP_FEATURE_ENABLED()))) {
            return this.executeDropFeatureWithCheckpointProtection(sparkSession, removableFeature);
        }
        return this.executeDropFeatureWithHistoryTruncation(sparkSession, removableFeature);
    }

    private Seq<Row> executeDropFeatureWithHistoryTruncation(SparkSession sparkSession, TableFeature removableFeature) {
        DeltaLog deltaLog = this.table().deltaLog();
        return (Seq)this.recordDeltaOperation(deltaLog, "delta.ddl.alter.dropFeature", this.recordDeltaOperation$default$3(), (Function0 & Serializable)() -> {
            OptimisticTransaction txn;
            Snapshot snapshot;
            boolean requiresHistoryValidation = ((RemovableFeature)((Object)removableFeature)).requiresHistoryProtection();
            long startTimeNs = this.table().deltaLog().clock().nanoTime();
            boolean preDowngradeMadeChanges = ((RemovableFeature)((Object)removableFeature)).preDowngradeCommand(this.table()).removeFeatureTracesIfNeeded(sparkSession);
            if (requiresHistoryValidation) {
                DropTableFeatureUtils$.MODULE$.createEmptyCommitAndCheckpoint(this.table(), startTimeNs, DropTableFeatureUtils$.MODULE$.createEmptyCommitAndCheckpoint$default$3());
                if (preDowngradeMadeChanges) {
                    throw DeltaErrors$.MODULE$.dropTableFeatureWaitForRetentionPeriod(this.featureName(), this.table().initialSnapshot().metadata());
                }
            }
            if (!((RemovableFeature)((Object)removableFeature)).validateRemoval(snapshot = (txn = this.table().startTransaction(this.table().startTransaction$default$1())).snapshot())) {
                throw DeltaErrors$.MODULE$.dropTableFeatureConflictRevalidationFailed(DeltaErrors$.MODULE$.dropTableFeatureConflictRevalidationFailed$default$1());
            }
            if (requiresHistoryValidation) {
                deltaLog.cleanUpExpiredLogs(snapshot, (Option<Object>)(this.truncateHistory() ? new Some((Object)BoxesRunTime.boxToLong((long)DropTableFeatureUtils$.MODULE$.truncateHistoryLogRetentionMillis(txn.metadata()))) : None$.MODULE$), this.truncateHistory() ? TruncationGranularity$.MODULE$.MINUTE() : TruncationGranularity$.MODULE$.DAY());
                boolean historyContainsFeature = ((RemovableFeature)((Object)removableFeature)).historyContainsFeature(sparkSession, snapshot);
                if (historyContainsFeature) {
                    throw DeltaErrors$.MODULE$.dropTableFeatureHistoricalVersionsExist(this.featureName(), snapshot.metadata());
                }
            }
            DeltaOperations.DropTableFeature op = new DeltaOperations.DropTableFeature(this.featureName(), this.truncateHistory());
            txn.updateProtocol(txn.protocol().removeFeature(removableFeature));
            txn.commit((Seq<Action>)Nil$.MODULE$, op);
            DeltaLog x$1 = deltaLog;
            String x$2 = "dropFeatureCompleted.withHistoryTruncation";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"droppedFeature"), (Object)removableFeature.name())}));
            Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
            Option<Path> x$5 = this.recordDeltaEvent$default$5();
            this.recordDeltaEvent(x$1, "dropFeatureCompleted.withHistoryTruncation", x$4, x$3, x$5);
            return Nil$.MODULE$;
        });
    }

    private Seq<Row> executeDropFeatureWithCheckpointProtection(SparkSession sparkSession, TableFeature removableFeature) {
        DeltaLog deltaLog = this.table().deltaLog();
        return (Seq)this.recordDeltaOperation(deltaLog, "delta.ddl.alter.dropFeatureWithCheckpointProtection", this.recordDeltaOperation$default$3(), (Function0 & Serializable)() -> {
            OptimisticTransaction txn;
            Snapshot snapshot;
            LongRef startTimeNs = LongRef.create((long)System.nanoTime());
            ((RemovableFeature)((Object)removableFeature)).preDowngradeCommand(this.table()).removeFeatureTracesIfNeeded(sparkSession);
            boolean historyBarrierIsRequired = ((RemovableFeature)((Object)removableFeature)).requiresHistoryProtection();
            if (historyBarrierIsRequired) {
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.NUMBER_OF_BARRIER_CHECKPOINTS()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
                    if (!DropTableFeatureUtils$.MODULE$.createEmptyCommitAndCheckpoint(this.table(), startTimeNs$1.elem, true)) {
                        throw DeltaErrors$.MODULE$.dropTableFeatureCheckpointFailedException(removableFeature.name());
                    }
                    startTimeNs$1.elem = System.nanoTime();
                });
            }
            if (!((RemovableFeature)((Object)removableFeature)).validateRemoval(snapshot = (txn = this.table().startTransaction(this.table().startTransaction$default$1())).snapshot())) {
                throw DeltaErrors$.MODULE$.dropTableFeatureConflictRevalidationFailed(DeltaErrors$.MODULE$.dropTableFeatureConflictRevalidationFailed$default$1());
            }
            if (historyBarrierIsRequired) {
                Metadata newMetadata = CheckpointProtectionTableFeature$.MODULE$.metadataWithCheckpointProtection(txn.metadata(), txn.readVersion() + 1L);
                txn.updateMetadata(newMetadata, txn.updateMetadata$default$2());
                Protocol newProtocol = txn.protocol().denormalized().withFeature(CheckpointProtectionTableFeature$.MODULE$).removeFeature(removableFeature);
                txn.updateProtocol(newProtocol);
            } else {
                txn.updateProtocol(txn.protocol().removeFeature(removableFeature));
            }
            txn.commit((Seq<Action>)Nil$.MODULE$, new DeltaOperations.DropTableFeature(this.featureName(), false));
            Object object = historyBarrierIsRequired ? BoxesRunTime.boxToBoolean((boolean)DropTableFeatureUtils$.MODULE$.createCheckpointWithRetries(this.table(), System.nanoTime())) : BoxedUnit.UNIT;
            DeltaLog x$1 = deltaLog;
            String x$22 = "dropFeatureCompleted.withCheckpointProtection";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"droppedFeature"), (Object)removableFeature.name())}));
            Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
            Option<Path> x$5 = this.recordDeltaEvent$default$5();
            this.recordDeltaEvent(x$1, "dropFeatureCompleted.withCheckpointProtection", x$4, x$3, x$5);
            return Nil$.MODULE$;
        });
    }

    private void dependentFeatureCheck(TableFeature removableFeature, Protocol protocol) {
        Set<TableFeature> dependentFeatures = TableFeature$.MODULE$.getDependentFeatures(removableFeature);
        if (dependentFeatures.nonEmpty()) {
            Set dependentFeaturesInProtocol = (Set)dependentFeatures.filter((Function1 & Serializable)feature -> BoxesRunTime.boxToBoolean((boolean)protocol.isFeatureSupported(feature)));
            if (dependentFeaturesInProtocol.nonEmpty()) {
                Set dependentFeatureNames = (Set)dependentFeaturesInProtocol.map((Function1 & Serializable)x$3 -> x$3.name());
                throw DeltaErrors$.MODULE$.dropTableFeatureFailedBecauseOfDependentFeatures(removableFeature.name(), (Seq<String>)dependentFeatureNames.toSeq());
            }
            return;
        }
    }

    public AlterTableDropFeatureDeltaCommand copy(DeltaTableV2 table, String featureName, boolean truncateHistory) {
        return new AlterTableDropFeatureDeltaCommand(table, featureName, truncateHistory);
    }

    public DeltaTableV2 copy$default$1() {
        return this.table();
    }

    public String copy$default$2() {
        return this.featureName();
    }

    public boolean copy$default$3() {
        return this.truncateHistory();
    }

    public String productPrefix() {
        return "AlterTableDropFeatureDeltaCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.table();
            }
            case 1: {
                return this.featureName();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.truncateHistory());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableDropFeatureDeltaCommand;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "table";
            }
            case 1: {
                return "featureName";
            }
            case 2: {
                return "truncateHistory";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableDropFeatureDeltaCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableDropFeatureDeltaCommand alterTableDropFeatureDeltaCommand = (AlterTableDropFeatureDeltaCommand)x$1;
        if (this.truncateHistory() != alterTableDropFeatureDeltaCommand.truncateHistory()) return false;
        DeltaTableV2 deltaTableV2 = this.table();
        DeltaTableV2 deltaTableV22 = alterTableDropFeatureDeltaCommand.table();
        if (deltaTableV2 == null) {
            if (deltaTableV22 != null) {
                return false;
            }
        } else if (!deltaTableV2.equals(deltaTableV22)) return false;
        String string = this.featureName();
        String string2 = alterTableDropFeatureDeltaCommand.featureName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!alterTableDropFeatureDeltaCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ String $anonfun$run$7(TableFeature x$1) {
        return x$1.name();
    }

    public AlterTableDropFeatureDeltaCommand(DeltaTableV2 table, String featureName, boolean truncateHistory) {
        this.table = table;
        this.featureName = featureName;
        this.truncateHistory = truncateHistory;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        LeafLike.$init$((LeafLike)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommandInvariants.$init$(this);
        DeltaCommand.$init$(this);
        AlterDeltaTableCommand.$init$(this);
        this.NUMBER_OF_BARRIER_CHECKPOINTS = 3;
        Statics.releaseFence();
    }
}

