/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LeafCommand;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.delta.CatalogOwnedTableFeature$;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaOperations$;
import org.apache.spark.sql.delta.DomainMetadataUtils$;
import org.apache.spark.sql.delta.IdentityColumn$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.TableFeature;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.Protocol$;
import org.apache.spark.sql.delta.commands.CloneSource;
import org.apache.spark.sql.delta.commands.CloneTableBase$;
import org.apache.spark.sql.delta.commands.CloneTableBaseUtils;
import org.apache.spark.sql.delta.commands.SnapshotOverwriteOperationMetrics;
import org.apache.spark.sql.delta.coordinatedcommits.CatalogOwnedTableUtils$;
import org.apache.spark.sql.delta.coordinatedcommits.CoordinatedCommitsUtils$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.StructType;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t}a!\u0002\u0011\"\u0003\u0003q\u0003\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u0011!\u0003!\u0011!Q\u0001\n%C\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\u0006E\u0002!\ta\u0019\u0005\u0006Q\u0002!\t!\u001b\u0005\u0006]\u0002!\ta\u001c\u0005\u0006m\u0002!\tb\u001e\u0005\b\u0003K\u0002A\u0011BA4\u0011\u001d\ti\b\u0001C\u0005\u0003\u007fBq!!$\u0001\t\u0013\ty\tC\u0004\u0002\u001a\u0002!I!a'\t\u000f\u0005}\u0005\u0001\"\u0003\u0002\"\"9\u0011\u0011\u0016\u0001\u0005\n\u0005-vaBA]C!\u0005\u00111\u0018\u0004\u0007A\u0005B\t!!0\t\r\t|A\u0011AAi\u0011%\t\u0019n\u0004b\u0001\n\u0003\t)\u000e\u0003\u0005\u0002f>\u0001\u000b\u0011BAl\u0011%\t9o\u0004b\u0001\n\u0003\t)\u000e\u0003\u0005\u0002j>\u0001\u000b\u0011BAl\u0011%\tYo\u0004b\u0001\n\u0003\t)\u000e\u0003\u0005\u0002n>\u0001\u000b\u0011BAl\u0011%\tyo\u0004b\u0001\n\u0003\t)\u000e\u0003\u0005\u0002r>\u0001\u000b\u0011BAl\u0011%\t\u0019p\u0004b\u0001\n\u0003\t)\u000e\u0003\u0005\u0002v>\u0001\u000b\u0011BAl\u0011%\t9p\u0004b\u0001\n\u0003\t)\u000e\u0003\u0005\u0002z>\u0001\u000b\u0011BAl\u0011%\tYp\u0004b\u0001\n\u0003\t)\u000e\u0003\u0005\u0002~>\u0001\u000b\u0011BAl\u0011\u001d\typ\u0004C\u0005\u0005\u0003\u0011ab\u00117p]\u0016$\u0016M\u00197f\u0005\u0006\u001cXM\u0003\u0002#G\u0005A1m\\7nC:$7O\u0003\u0002%K\u0005)A-\u001a7uC*\u0011aeJ\u0001\u0004gFd'B\u0001\u0015*\u0003\u0015\u0019\b/\u0019:l\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M)\u0001aL\u001d=\u0001B\u0011\u0001gN\u0007\u0002c)\u0011!gM\u0001\bY><\u0017nY1m\u0015\t!T'A\u0003qY\u0006t7O\u0003\u00027K\u0005A1-\u0019;bYf\u001cH/\u0003\u00029c\tYAj\\4jG\u0006d\u0007\u000b\\1o!\t\u0001$(\u0003\u0002<c\tYA*Z1g\u0007>lW.\u00198e!\tid(D\u0001\"\u0013\ty\u0014EA\nDY>tW\rV1cY\u0016\u0014\u0015m]3Vi&d7\u000f\u0005\u0002B\u00056\tQ'\u0003\u0002Dk\ti1+\u0015'D_:4\u0007*\u001a7qKJ\f1b]8ve\u000e,G+\u00192mKB\u0011QHR\u0005\u0003\u000f\u0006\u00121b\u00117p]\u0016\u001cv.\u001e:dK\u00061B/\u00192mKB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000f\u0005\u0003K'Z3fBA&R!\tau*D\u0001N\u0015\tqU&\u0001\u0004=e>|GO\u0010\u0006\u0002!\u0006)1oY1mC&\u0011!kT\u0001\u0007!J,G-\u001a4\n\u0005Q+&aA'ba*\u0011!k\u0014\t\u0003\u0015^K!\u0001W+\u0003\rM#(/\u001b8h\u0003)!\u0018M]4fiB\u000bG\u000f\u001b\t\u00037\u0002l\u0011\u0001\u0018\u0006\u0003;z\u000b!AZ:\u000b\u0005}K\u0013A\u00025bI>|\u0007/\u0003\u0002b9\n!\u0001+\u0019;i\u0003\u0019a\u0014N\\5u}Q!A-\u001a4h!\ti\u0004\u0001C\u0003E\t\u0001\u0007Q\tC\u0003I\t\u0001\u0007\u0011\nC\u0003Z\t\u0001\u0007!,\u0001\feCR\f7\t[1oO\u0016LeNR5mK\u0006\u001bG/[8o+\u0005Q\u0007CA6m\u001b\u0005y\u0015BA7P\u0005\u001d\u0011un\u001c7fC:\f1\u0002^1cY\u0016,\u00050[:ugR\u0011!\u000e\u001d\u0005\u0006c\u001a\u0001\rA]\u0001\tg:\f\u0007o\u001d5piB\u00111\u000f^\u0007\u0002G%\u0011Qo\t\u0002\u0013':\f\u0007o\u001d5pi\u0012+7o\u0019:jaR|'/A\u0006iC:$G.Z\"m_:,G#\u0004=\u0002\f\u0005M\u0011QDA\u0014\u0003o\tI\u0005\u0005\u0003z}\u0006\raB\u0001>}\u001d\ta50C\u0001Q\u0013\tix*A\u0004qC\u000e\\\u0017mZ3\n\u0007}\f\tAA\u0002TKFT!!`(\u0011\t\u0005\u0015\u0011qA\u0007\u0002K%\u0019\u0011\u0011B\u0013\u0003\u0007I{w\u000f\u0003\u0004)\u000f\u0001\u0007\u0011Q\u0002\t\u0005\u0003\u000b\ty!C\u0002\u0002\u0012\u0015\u0012Ab\u00159be.\u001cVm]:j_:Dq!!\u0006\b\u0001\u0004\t9\"A\u0002uq:\u00042a]A\r\u0013\r\tYb\t\u0002\u0016\u001fB$\u0018.\\5ti&\u001cGK]1og\u0006\u001cG/[8o\u0011\u001d\tyb\u0002a\u0001\u0003C\t\u0001\u0003Z3ti&t\u0017\r^5p]R\u000b'\r\\3\u0011\u0007M\f\u0019#C\u0002\u0002&\r\u0012\u0001\u0002R3mi\u0006dun\u001a\u0005\b\u0003S9\u0001\u0019AA\u0016\u0003\u001dAG\r]\"p]\u001a\u0004B!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003cq\u0016\u0001B2p]\u001aLA!!\u000e\u00020\ti1i\u001c8gS\u001e,(/\u0019;j_:Dq!!\u000f\b\u0001\u0004\tY$\u0001\beK2$\u0018m\u00149fe\u0006$\u0018n\u001c8\u0011\t\u0005u\u00121\t\b\u0004g\u0006}\u0012bAA!G\u0005yA)\u001a7uC>\u0003XM]1uS>t7/\u0003\u0003\u0002F\u0005\u001d#!C(qKJ\fG/[8o\u0015\r\t\te\t\u0005\b\u0003\u0017:\u0001\u0019AA'\u00039\u0019w.\\7b]\u0012lU\r\u001e:jGN\u0004Ra[A(\u0003'J1!!\u0015P\u0005\u0019y\u0005\u000f^5p]B)!j\u0015,\u0002VA!\u0011qKA1\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013AB7fiJL7MC\u0002\u0002`\u0015\n\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\u0005\r\u0014\u0011\f\u0002\n'FcU*\u001a;sS\u000e\fQ\u0003\u001d:fa\u0006\u0014XmU8ve\u000e,W*\u001a;bI\u0006$\u0018\r\u0006\u0004\u0002j\u0005U\u0014\u0011\u0010\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011qN\u0012\u0002\u000f\u0005\u001cG/[8og&!\u00111OA7\u0005!iU\r^1eCR\f\u0007BBA<\u0011\u0001\u0007!/\u0001\buCJ<W\r^*oCB\u001c\bn\u001c;\t\r\u0005m\u0004\u00021\u0001W\u0003\u0019y\u0007OT1nK\u0006Ab/\u001a:jMflU\r^1eCR\f\u0017J\u001c<be&\fg\u000e^:\u0015\r\u0005\u0005\u0015qQAE!\rY\u00171Q\u0005\u0004\u0003\u000b{%\u0001B+oSRDa!a\u001e\n\u0001\u0004\u0011\bbBAF\u0013\u0001\u0007\u0011\u0011N\u0001\u001dkB$\u0017\r^3e\u001b\u0016$\u0018\rZ1uC^KG\u000f[(wKJ\u0014\u0018\u000eZ3t\u0003%\"W\r^3s[&tWmQ8pe\u0012Lg.\u0019;fI\u000e{W.\\5ug\u000e{gNZ5hkJ\fG/[8ogR9\u0011*!%\u0002\u0014\u0006U\u0005B\u0002\u0015\u000b\u0001\u0004\ti\u0001\u0003\u0004\u0002x)\u0001\rA\u001d\u0005\u0007\u0003/S\u0001\u0019A%\u0002%Y\fG.\u001b3bi\u0016$wJ^3se&$Wm]\u0001\u001fI\u0016$XM]7j]\u0016\u001c\u0015\r^1m_\u001e|uO\\3e+\u000e#\u0016M\u00197f\u0013\u0012$2!SAO\u0011\u0019\t9h\u0003a\u0001e\u00069B-\u001a;fe6Lg.\u001a+be\u001e,G/T3uC\u0012\fG/\u0019\u000b\t\u0003S\n\u0019+!*\u0002(\"1\u0001\u0006\u0004a\u0001\u0003\u001bAa!a\u001e\r\u0001\u0004\u0011\bBBA>\u0019\u0001\u0007a+A\feKR,'/\\5oKR\u000b'oZ3u!J|Go\\2pYRA\u0011QVAZ\u0003k\u000b9\f\u0005\u0003\u0002l\u0005=\u0016\u0002BAY\u0003[\u0012\u0001\u0002\u0015:pi>\u001cw\u000e\u001c\u0005\u0007Q5\u0001\r!!\u0004\t\u000f\u0005UQ\u00021\u0001\u0002\u0018!1\u00111P\u0007A\u0002Y\u000bab\u00117p]\u0016$\u0016M\u00197f\u0005\u0006\u001cX\r\u0005\u0002>\u001fM)q\"a0\u0002FB\u00191.!1\n\u0007\u0005\rwJ\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003\u000f\fi-\u0004\u0002\u0002J*\u0019\u00111Z\u0014\u0002\u0011%tG/\u001a:oC2LA!a4\u0002J\n9Aj\\4hS:<GCAA^\u0003\u0019\u0019v*\u0016*D\u000bV\u0011\u0011q\u001b\t\u0005\u00033\f\u0019/\u0004\u0002\u0002\\*!\u0011Q\\Ap\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0018\u0001\u00026bm\u0006L1\u0001WAn\u0003\u001d\u0019v*\u0016*D\u000b\u0002\nQbU(V%\u000e+uLR(S\u001b\u0006#\u0016AD*P+J\u001bUi\u0018$P%6\u000bE\u000bI\u0001\f'>+&kQ#`!\u0006#\u0006*\u0001\u0007T\u001fV\u00136)R0Q\u0003RC\u0005%\u0001\bT\u001fV\u00136)R0W\u000bJ\u001b\u0016j\u0014(\u0002\u001fM{UKU\"F?Z+%kU%P\u001d\u0002\na\u0001V!S\u000f\u0016#\u0016a\u0002+B%\u001e+E\u000bI\u0001\u0011\u0013N{&+\u0012)M\u0003\u000e+u\fR#M)\u0006\u000b\u0011#S*`%\u0016\u0003F*Q\"F?\u0012+E\nV!!\u00031\u0001\u0016I\u0015+J)&{ej\u0018\"Z\u00035\u0001\u0016I\u0015+J)&{ej\u0018\"ZA\u0005iAo\u001c;bY\u0012\u000bG/Y*ju\u0016$BAa\u0001\u0003\nA\u00191N!\u0002\n\u0007\t\u001dqJ\u0001\u0003M_:<\u0007b\u0002B\u0006?\u0001\u0007!QB\u0001\tM&dW\rT5tiB1!q\u0002B\u000b\u00053i!A!\u0005\u000b\t\tM\u0011q\\\u0001\u0005kRLG.\u0003\u0003\u0003\u0018\tE!\u0001C%uKJ\fGo\u001c:\u0011\t\u0005-$1D\u0005\u0005\u0005;\tiGA\u0004BI\u00124\u0015\u000e\\3")
public abstract class CloneTableBase
extends LogicalPlan
implements LeafCommand,
CloneTableBaseUtils {
    private final CloneSource sourceTable;
    private final Map<String, String> tablePropertyOverrides;
    private final Path targetPath;
    private Seq<Enumeration.Value> nodePatterns;

    public static String PARTITION_BY() {
        return CloneTableBase$.MODULE$.PARTITION_BY();
    }

    public static String IS_REPLACE_DELTA() {
        return CloneTableBase$.MODULE$.IS_REPLACE_DELTA();
    }

    public static String TARGET() {
        return CloneTableBase$.MODULE$.TARGET();
    }

    public static String SOURCE_VERSION() {
        return CloneTableBase$.MODULE$.SOURCE_VERSION();
    }

    public static String SOURCE_PATH() {
        return CloneTableBase$.MODULE$.SOURCE_PATH();
    }

    public static String SOURCE_FORMAT() {
        return CloneTableBase$.MODULE$.SOURCE_FORMAT();
    }

    public static String SOURCE() {
        return CloneTableBase$.MODULE$.SOURCE();
    }

    @Override
    public Map<String, Object> getOperationMetricsForDeltaLog(SnapshotOverwriteOperationMetrics opMetrics) {
        return CloneTableBaseUtils.getOperationMetricsForDeltaLog$(this, opMetrics);
    }

    @Override
    public Map<String, Object> getOperationMetricsForEventRecord(SnapshotOverwriteOperationMetrics opMetrics) {
        return CloneTableBaseUtils.getOperationMetricsForEventRecord$(this, opMetrics);
    }

    @Override
    public void checkColumnMappingMode(Metadata beforeMetadata, Metadata afterMetadata) {
        CloneTableBaseUtils.checkColumnMappingMode$(this, beforeMetadata, afterMetadata);
    }

    @Override
    public Dataset<AddFile> handleNewDataFiles(String opName, Dataset<AddFile> datasetOfNewFilesToAdd, String qualifiedSourceTableBasePath, DeltaLog destTable) {
        return CloneTableBaseUtils.handleNewDataFiles$(this, opName, datasetOfNewFilesToAdd, qualifiedSourceTableBasePath, destTable);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public boolean dataChangeInFileAction() {
        return true;
    }

    public boolean tableExists(SnapshotDescriptor snapshot) {
        return snapshot.version() >= 0L;
    }

    public Seq<Row> handleClone(SparkSession spark, OptimisticTransaction txn, DeltaLog destinationTable, Configuration hdpConf, DeltaOperations.Operation deltaOperation, Option<Map<String, SQLMetric>> commandMetrics2) {
        Seq seq;
        FileSystem targetFs = this.targetPath.getFileSystem(hdpConf);
        String qualifiedTarget = targetFs.makeQualified(this.targetPath).toString();
        Path sourcePath = this.sourceTable.dataPath();
        FileSystem sourceFs = sourcePath.getFileSystem(hdpConf);
        String qualifiedSource = sourceFs.makeQualified(sourcePath).toString();
        if (txn.readVersion() < 0L) {
            destinationTable.createLogDirectoriesIfNotExists();
        }
        Metadata metadataToUpdate = this.determineTargetMetadata(spark, txn.snapshot(), deltaOperation.name());
        txn.updateMetadata(metadataToUpdate, true);
        if (txn.snapshot().allFiles().count() > 0L) {
            throw DeltaErrors$.MODULE$.cloneReplaceNonEmptyTable();
        }
        Dataset<AddFile> toAdd = this.sourceTable.allFiles();
        List addedFileList = this.handleNewDataFiles(deltaOperation.name(), toAdd, qualifiedSource, destinationTable).collectAsList();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp((long)addedFileList.size(), CloneTableBase$.MODULE$.org$apache$spark$sql$delta$commands$CloneTableBase$$totalDataSize(addedFileList.iterator()));
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        long addedFileCount = sp2._1$mcJ$sp();
        long addedFilesSize = sp2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(addedFileCount, addedFilesSize);
        long addedFileCount2 = sp3._1$mcJ$sp();
        long addedFilesSize2 = sp3._2$mcJ$sp();
        Protocol newProtocol = this.determineTargetProtocol(spark, txn, deltaOperation.name());
        Iterator addFileIter = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(addedFileList.iterator()).asScala();
        try {
            ObjectRef actions = ObjectRef.create((Object)addFileIter.map((Function1 & Serializable)fileToCopy -> {
                boolean x$1 = this.dataChangeInFileAction();
                String x$2 = fileToCopy.copy$default$1();
                Map<String, String> x$3 = fileToCopy.copy$default$2();
                long x$4 = fileToCopy.copy$default$3();
                long x$5 = fileToCopy.copy$default$4();
                String x$6 = fileToCopy.copy$default$6();
                Map<String, String> x$7 = fileToCopy.copy$default$7();
                DeletionVectorDescriptor x$8 = fileToCopy.copy$default$8();
                Option<Object> x$9 = fileToCopy.copy$default$9();
                Option<Object> x$10 = fileToCopy.copy$default$10();
                Option<String> x$11 = fileToCopy.copy$default$11();
                AddFile copiedFile = fileToCopy.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$10, x$11);
                None$ x$12 = None$.MODULE$;
                None$ x$13 = None$.MODULE$;
                String x$14 = copiedFile.copy$default$1();
                Map<String, String> x$15 = copiedFile.copy$default$2();
                long x$16 = copiedFile.copy$default$3();
                long x$17 = copiedFile.copy$default$4();
                boolean x$18 = copiedFile.copy$default$5();
                String x$19 = copiedFile.copy$default$6();
                Map<String, String> x$20 = copiedFile.copy$default$7();
                DeletionVectorDescriptor x$21 = copiedFile.copy$default$8();
                Option<String> x$22 = copiedFile.copy$default$11();
                return copiedFile.copy(x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, (Option<Object>)x$12, (Option<Object>)x$13, x$22);
            }));
            this.sourceTable.snapshot().foreach((Function1 & Serializable)sourceSnapshot -> {
                CloneTableBase.$anonfun$handleClone$2(deltaOperation, actions, sourceSnapshot);
                return BoxedUnit.UNIT;
            });
            String sourceName = this.sourceTable.name();
            Map context = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            boolean isReplaceDelta = txn.readVersion() >= 0L;
            SnapshotOverwriteOperationMetrics opMetrics = new SnapshotOverwriteOperationMetrics(this.sourceTable.sizeInBytes(), this.sourceTable.numOfFiles(), addedFileCount2, addedFilesSize2);
            Map<String, Object> commitOpMetrics = this.getOperationMetricsForDeltaLog(opMetrics);
            commandMetrics2.foreach((Function1 & Serializable)commandMetrics -> {
                commitOpMetrics.foreach((Function1 & Serializable)kv -> {
                    CloneTableBase.$anonfun$handleClone$5(commandMetrics, kv);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            this.recordDeltaOperation(destinationTable, new StringBuilder(13).append("delta.").append(deltaOperation.name().toLowerCase()).append(".commit").toString(), this.recordDeltaOperation$default$3(), (Function0 & Serializable)() -> txn.commitLarge(spark, (Iterator<Action>)((Iterator)actions$1.elem), (Option<Protocol>)new Some((Object)newProtocol), deltaOperation, (Map<String, String>)context, (Map<String, String>)commitOpMetrics.mapValues((Function1 & Serializable)x$2 -> CloneTableBase.$anonfun$handleClone$7(BoxesRunTime.unboxToLong((Object)x$2))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
            Map cloneLogData = (Map)((MapOps)this.getOperationMetricsForEventRecord(opMetrics).$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CloneTableBase$.MODULE$.SOURCE()), (Object)sourceName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CloneTableBase$.MODULE$.SOURCE_FORMAT()), (Object)this.sourceTable.format()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CloneTableBase$.MODULE$.SOURCE_PATH()), (Object)qualifiedSource), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CloneTableBase$.MODULE$.TARGET()), (Object)qualifiedTarget), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CloneTableBase$.MODULE$.PARTITION_BY()), this.sourceTable.metadata().partitionColumns()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CloneTableBase$.MODULE$.IS_REPLACE_DELTA()), (Object)BoxesRunTime.boxToBoolean((boolean)isReplaceDelta))})))).$plus$plus((IterableOnce)this.sourceTable.snapshot().map((Function1 & Serializable)s -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CloneTableBase$.MODULE$.SOURCE_VERSION()), (Object)BoxesRunTime.boxToLong((long)s.version()))));
            DeltaLog x$23 = destinationTable;
            String x$24 = new StringBuilder(6).append("delta.").append(deltaOperation.name().toLowerCase()).toString();
            Map x$25 = cloneLogData;
            Map<TagDefinition, String> x$26 = this.recordDeltaEvent$default$3();
            Option<Path> x$27 = this.recordDeltaEvent$default$5();
            this.recordDeltaEvent(x$23, x$24, x$26, x$25, x$27);
            seq = this.getOutputSeq(commitOpMetrics);
        }
        finally {
            this.sourceTable.close();
        }
        return seq;
    }

    private Metadata prepareSourceMetadata(SnapshotDescriptor targetSnapshot, String opName) {
        Metadata qual$1 = this.sourceTable.metadata();
        String x$1 = UUID.randomUUID().toString();
        String x$2 = targetSnapshot.metadata().name();
        String x$32 = targetSnapshot.metadata().description();
        Format x$42 = qual$1.copy$default$4();
        String x$5 = qual$1.copy$default$5();
        Seq<String> x$6 = qual$1.copy$default$6();
        Map<String, String> x$7 = qual$1.copy$default$7();
        Option<Object> x$8 = qual$1.copy$default$8();
        Metadata clonedMetadata = qual$1.copy(x$1, x$2, x$32, x$42, x$5, x$6, x$7, x$8);
        if (this.tableExists(targetSnapshot)) {
            Metadata qual$2 = clonedMetadata;
            String x$9 = targetSnapshot.metadata().id();
            String x$10 = qual$2.copy$default$2();
            String x$11 = qual$2.copy$default$3();
            Format x$12 = qual$2.copy$default$4();
            String x$13 = qual$2.copy$default$5();
            Seq<String> x$14 = qual$2.copy$default$6();
            Map<String, String> x$15 = qual$2.copy$default$7();
            Option<Object> x$16 = qual$2.copy$default$8();
            clonedMetadata = qual$2.copy(x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        }
        Map filteredConfiguration = clonedMetadata.configuration().filterKeys((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CloneTableBase.$anonfun$prepareSourceMetadata$1(x$3))).filterKeys((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CloneTableBase.$anonfun$prepareSourceMetadata$2(x$4))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        StructType clonedSchema = IdentityColumn$.MODULE$.copySchemaWithMergedHighWaterMarks(targetSnapshot.deltaLog(), clonedMetadata.schema(), targetSnapshot.metadata().schema());
        Metadata qual$3 = clonedMetadata;
        Map x$17 = filteredConfiguration;
        String x$18 = clonedSchema.json();
        String x$19 = qual$3.copy$default$1();
        String x$20 = qual$3.copy$default$2();
        String x$21 = qual$3.copy$default$3();
        Format x$22 = qual$3.copy$default$4();
        Seq<String> x$23 = qual$3.copy$default$6();
        Option<Object> x$24 = qual$3.copy$default$8();
        return qual$3.copy(x$19, x$20, x$21, x$22, x$18, x$23, (Map<String, String>)x$17, x$24);
    }

    private void verifyMetadataInvariants(SnapshotDescriptor targetSnapshot, Metadata updatedMetadataWithOverrides) {
        DeltaConfigs$.MODULE$.validateConfigurations(this.tablePropertyOverrides);
        this.checkColumnMappingMode(this.sourceTable.metadata(), updatedMetadataWithOverrides);
        if (this.tableExists(targetSnapshot)) {
            this.checkColumnMappingMode(targetSnapshot.metadata(), updatedMetadataWithOverrides);
            return;
        }
    }

    private Map<String, String> determineCoordinatedCommitsConfigurations(SparkSession spark, SnapshotDescriptor targetSnapshot, Map<String, String> validatedOverrides) {
        if (this.tableExists(targetSnapshot)) {
            Predef$.MODULE$.assert(validatedOverrides.isEmpty(), (Function0 & Serializable)() -> "Explicit overrides on Coordinated Commits configurations for existing tables are not supported, and should have been caught earlier.");
            return CoordinatedCommitsUtils$.MODULE$.getExplicitCCConfigurations(targetSnapshot.metadata().configuration());
        }
        if (validatedOverrides.nonEmpty()) {
            return validatedOverrides;
        }
        return CoordinatedCommitsUtils$.MODULE$.getDefaultCCConfigurations(spark, CoordinatedCommitsUtils$.MODULE$.getDefaultCCConfigurations$default$2());
    }

    private Map<String, String> determineCatalogOwnedUCTableId(SnapshotDescriptor targetSnapshot) {
        if (this.tableExists(targetSnapshot)) {
            return (Map)targetSnapshot.metadata().configuration().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CloneTableBase.$anonfun$determineCatalogOwnedUCTableId$1(x0$1)));
        }
        return Predef$.MODULE$.Map().empty();
    }

    private Metadata determineTargetMetadata(SparkSession spark, SnapshotDescriptor targetSnapshot, String opName) {
        Metadata metadata = this.prepareSourceMetadata(targetSnapshot, opName);
        Map<String, String> validatedConfigurations = DeltaConfigs$.MODULE$.validateConfigurations(this.tablePropertyOverrides);
        Map<String, String> coordinatedCommitsConfigurationOverrides = CoordinatedCommitsUtils$.MODULE$.getExplicitCCConfigurations(validatedConfigurations);
        Map validatedConfigurationsWithoutCoordinatedCommits = (Map)validatedConfigurations.$minus$minus((IterableOnce)coordinatedCommitsConfigurationOverrides.keys());
        Map<String, String> finalCoordinatedCommitsConfigurations = this.determineCoordinatedCommitsConfigurations(spark, targetSnapshot, coordinatedCommitsConfigurationOverrides);
        Map finalCatalogOwnedMetadata = (Map)finalCoordinatedCommitsConfigurations.$plus$plus(this.determineCatalogOwnedUCTableId(targetSnapshot));
        Metadata qual$1 = metadata;
        Map x$1 = (Map)((MapOps)metadata.configuration().$plus$plus((IterableOnce)validatedConfigurationsWithoutCoordinatedCommits)).$plus$plus((IterableOnce)finalCatalogOwnedMetadata);
        String x$2 = qual$1.copy$default$1();
        String x$3 = qual$1.copy$default$2();
        String x$4 = qual$1.copy$default$3();
        Format x$5 = qual$1.copy$default$4();
        String x$6 = qual$1.copy$default$5();
        Seq<String> x$7 = qual$1.copy$default$6();
        Option<Object> x$8 = qual$1.copy$default$8();
        metadata = qual$1.copy(x$2, x$3, x$4, x$5, x$6, x$7, (Map<String, String>)x$1, x$8);
        this.verifyMetadataInvariants(targetSnapshot, metadata);
        return metadata;
    }

    private Protocol determineTargetProtocol(SparkSession spark, OptimisticTransaction txn, String opName) {
        boolean protocolDowngradeAllowed;
        Option<Object> x$8;
        Seq<String> x$7;
        String x$6;
        Format x$5;
        String x$4;
        String x$3;
        Protocol sourceProtocol = CatalogOwnedTableUtils$.MODULE$.filterOutCatalogOwnedTableFeature(this.sourceTable.protocol());
        Protocol targetProtocol = txn.snapshot().protocol();
        Map<String, String> validatedConfigurations = DeltaConfigs$.MODULE$.validateConfigurations(this.tablePropertyOverrides);
        Map catalogOwnedEnabledByDefaultConf = CatalogOwnedTableUtils$.MODULE$.defaultCatalogOwnedEnabled(spark) && !this.tableExists(txn.snapshot()) ? (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(14).append("delta.feature.").append(CatalogOwnedTableFeature$.MODULE$.name()).toString()), (Object)"supported")})) : Predef$.MODULE$.Map().empty();
        Map configWithOverrides = (Map)((MapOps)txn.metadata().configuration().$plus$plus(validatedConfigurations)).$plus$plus((IterableOnce)catalogOwnedEnabledByDefaultConf);
        Metadata qual$1 = txn.metadata();
        Map x$1 = configWithOverrides;
        String x$2 = qual$1.copy$default$1();
        Metadata metadataWithOverrides = qual$1.copy(x$2, x$3 = qual$1.copy$default$2(), x$4 = qual$1.copy$default$3(), x$5 = qual$1.copy$default$4(), x$6 = qual$1.copy$default$5(), x$7 = qual$1.copy$default$6(), (Map<String, String>)x$1, x$8 = qual$1.copy$default$8());
        Tuple3<Object, Object, Set<TableFeature>> tuple3 = Protocol$.MODULE$.minProtocolComponentsFromMetadata(spark, metadataWithOverrides);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        int minReaderVersion = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int minWriterVersion = BoxesRunTime.unboxToInt((Object)tuple3._2());
        Set enabledFeatures = (Set)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)minReaderVersion), (Object)BoxesRunTime.boxToInteger((int)minWriterVersion), (Object)enabledFeatures);
        int minReaderVersion2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
        int minWriterVersion2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
        Set enabledFeatures2 = (Set)tuple32._3();
        boolean bl = protocolDowngradeAllowed = BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(DeltaSQLConf$.MODULE$.RESTORE_TABLE_PROTOCOL_DOWNGRADE_ALLOWED())) || !this.tableExists(txn.snapshot());
        if (protocolDowngradeAllowed) {
            minReaderVersion2 = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(minReaderVersion2), sourceProtocol.minReaderVersion());
            minWriterVersion2 = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(minWriterVersion2), sourceProtocol.minWriterVersion());
            Protocol minProtocol = Protocol$.MODULE$.apply(minReaderVersion2, minWriterVersion2).withFeatures((Iterable<TableFeature>)enabledFeatures2);
            return sourceProtocol.merge((Seq<Protocol>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Protocol[]{minProtocol}));
        }
        minReaderVersion2 = BoxesRunTime.unboxToInt((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{targetProtocol.minReaderVersion(), sourceProtocol.minReaderVersion(), minReaderVersion2})).max((Ordering)Ordering.Int$.MODULE$));
        minWriterVersion2 = BoxesRunTime.unboxToInt((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{targetProtocol.minWriterVersion(), sourceProtocol.minWriterVersion(), minWriterVersion2})).max((Ordering)Ordering.Int$.MODULE$));
        Protocol minProtocol = Protocol$.MODULE$.apply(minReaderVersion2, minWriterVersion2).withFeatures((Iterable<TableFeature>)enabledFeatures2);
        return targetProtocol.merge((Seq<Protocol>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Protocol[]{sourceProtocol, minProtocol}));
    }

    public static final /* synthetic */ void $anonfun$handleClone$2(DeltaOperations.Operation deltaOperation$1, ObjectRef actions$1, Snapshot sourceSnapshot) {
        String string = deltaOperation$1.name();
        String string2 = DeltaOperations$.MODULE$.OP_CLONE();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            actions$1.elem = ((Iterator)actions$1.elem).$plus$plus((Function0 & Serializable)() -> DomainMetadataUtils$.MODULE$.handleDomainMetadataForCloneTable(sourceSnapshot.domainMetadata()));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleClone$5(Map commandMetrics$1, Tuple2 kv) {
        ((SQLMetric)commandMetrics$1.apply(kv._1())).set(kv._2$mcJ$sp());
    }

    public static final /* synthetic */ String $anonfun$handleClone$7(long x$2) {
        return Long.toString(x$2);
    }

    public static final /* synthetic */ boolean $anonfun$prepareSourceMetadata$1(String x$3) {
        return !CoordinatedCommitsUtils$.MODULE$.TABLE_PROPERTY_KEYS().contains((Object)x$3);
    }

    public static final /* synthetic */ boolean $anonfun$prepareSourceMetadata$2(String x$4) {
        String string = x$4;
        String string2 = "ucTableId";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$determineCatalogOwnedUCTableId$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k;
            String string = k = (String)tuple2._1();
            String string2 = "ucTableId";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }
        throw new MatchError((Object)tuple2);
    }

    public CloneTableBase(CloneSource sourceTable, Map<String, String> tablePropertyOverrides, Path targetPath) {
        this.sourceTable = sourceTable;
        this.tablePropertyOverrides = tablePropertyOverrides;
        this.targetPath = targetPath;
        Command.$init$((Command)this);
        LeafLike.$init$((LeafLike)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        CloneTableBaseUtils.$init$(this);
        Statics.releaseFence();
    }
}

