/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands.backfill;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.FileMetadataMaterializationTracker;
import org.apache.spark.sql.delta.FileMetadataMaterializationTracker$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.backfill.BackfillBatch;
import org.apache.spark.sql.delta.commands.backfill.BackfillBatchIterator;
import org.apache.spark.sql.delta.commands.backfill.BackfillCommandStats;
import org.apache.spark.sql.delta.commands.backfill.BackfillCommandStats$;
import org.apache.spark.sql.delta.commands.backfill.BackfillExecutor;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Uba\u0002\u0006\f!\u0003\r\tA\u0007\u0005\u0006c\u0001!\tA\r\u0005\u0006s\u00011\tA\u000f\u0005\u0006\u007f\u00011\t\u0001\u0011\u0005\u0006\u0019\u00021\t!\u0014\u0005\u0006/\u00021\t\u0001\u0017\u0005\u0006m\u00021\ta\u001e\u0005\u0007\u0003\u000b\u0001a\u0011\u0001!\t\u000f\u0005\u001d\u0001A\"\u0001\u0002\n!9\u0011q\u0005\u0001\u0005B\u0005%\"a\u0004\"bG.4\u0017\u000e\u001c7D_6l\u0017M\u001c3\u000b\u00051i\u0011\u0001\u00032bG.4\u0017\u000e\u001c7\u000b\u00059y\u0011\u0001C2p[6\fg\u000eZ:\u000b\u0005A\t\u0012!\u00023fYR\f'B\u0001\n\u0014\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003)U\tQa\u001d9be.T!AF\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u001cK5\u0002\"\u0001H\u0012\u000e\u0003uQ!AH\u0010\u0002\u000f1|w-[2bY*\u0011\u0001%I\u0001\u0006a2\fgn\u001d\u0006\u0003EE\t\u0001bY1uC2L8\u000f^\u0005\u0003Iu\u00111\u0002T8hS\u000e\fG\u000e\u00157b]B\u0011aeK\u0007\u0002O)\u0011\u0001&K\u0001\bG>lW.\u00198e\u0015\tQ\u0013#A\u0005fq\u0016\u001cW\u000f^5p]&\u0011Af\n\u0002\u0014\u0019\u0016\fgMU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003]=j\u0011!D\u0005\u0003a5\u0011A\u0002R3mi\u0006\u001cu.\\7b]\u0012\fa\u0001J5oSR$C#A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\tUs\u0017\u000e^\u0001\tI\u0016dG/\u0019'pOV\t1\b\u0005\u0002={5\tq\"\u0003\u0002?\u001f\tAA)\u001a7uC2{w-A\roC6,wJ\u001a+sS\u001e<WM]5oO>\u0003XM]1uS>tW#A!\u0011\u0005\tKeBA\"H!\t!U'D\u0001F\u0015\t1\u0015$\u0001\u0004=e>|GOP\u0005\u0003\u0011V\na\u0001\u0015:fI\u00164\u0017B\u0001&L\u0005\u0019\u0019FO]5oO*\u0011\u0001*N\u0001\rG\u0006$\u0018\r\\8h)\u0006\u0014G.Z\u000b\u0002\u001dB\u0019AgT)\n\u0005A+$AB(qi&|g\u000e\u0005\u0002S+6\t1K\u0003\u0002UC\u000591-\u0019;bY><\u0017B\u0001,T\u00051\u0019\u0015\r^1m_\u001e$\u0016M\u00197f\u0003M9W\r\u001e\"bG.4\u0017\u000e\u001c7Fq\u0016\u001cW\u000f^8s)\u0019IVLY4mcB\u0011!lW\u0007\u0002\u0017%\u0011Al\u0003\u0002\u0011\u0005\u0006\u001c7NZ5mY\u0016CXmY;u_JDQ\u0001F\u0003A\u0002y\u0003\"a\u00181\u000e\u0003EI!!Y\t\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000b\r,\u0001\u0019\u00013\u0002\u0007QDh\u000e\u0005\u0002=K&\u0011am\u0004\u0002\u0016\u001fB$\u0018.\\5ti&\u001cGK]1og\u0006\u001cG/[8o\u0011\u0015AW\u00011\u0001j\u0003i1\u0017\u000e\\3NCR,'/[1mSj\fG/[8o)J\f7m[3s!\ta$.\u0003\u0002l\u001f\t\u0011c)\u001b7f\u001b\u0016$\u0018\rZ1uC6\u000bG/\u001a:jC2L'0\u0019;j_:$&/Y2lKJDQ!\\\u0003A\u00029\fq#\\1y\u001dVl')\u0019;dQ\u0016\u001c\u0018J\u001c)be\u0006dG.\u001a7\u0011\u0005Qz\u0017B\u000196\u0005\rIe\u000e\u001e\u0005\u0006e\u0016\u0001\ra]\u0001\u000eE\u0006\u001c7NZ5mYN#\u0018\r^:\u0011\u0005i#\u0018BA;\f\u0005Q\u0011\u0015mY6gS2d7i\\7nC:$7\u000b^1ug\u0006ya-\u001b7fgR{')Y2lM&dG\u000eF\u0002y\u0003\u0007\u00012aX=|\u0013\tQ\u0018CA\u0004ECR\f7/\u001a;\u0011\u0005q|X\"A?\u000b\u0005y|\u0011aB1di&|gn]\u0005\u0004\u0003\u0003i(aB!eI\u001aKG.\u001a\u0005\u0006G\u001a\u0001\r\u0001Z\u0001\u0007_B$\u0016\u0010]3\u0002\u001d\r|gn\u001d;sk\u000e$()\u0019;dQR!\u00111BA\t!\rQ\u0016QB\u0005\u0004\u0003\u001fY!!\u0004\"bG.4\u0017\u000e\u001c7CCR\u001c\u0007\u000eC\u0004\u0002\u0014!\u0001\r!!\u0006\u0002\u000b\u0019LG.Z:\u0011\u000b\u0005]\u0011\u0011E>\u000f\t\u0005e\u0011Q\u0004\b\u0004\t\u0006m\u0011\"\u0001\u001c\n\u0007\u0005}Q'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0012Q\u0005\u0002\u0004'\u0016\f(bAA\u0010k\u0005\u0019!/\u001e8\u0015\t\u0005-\u00121\u0007\t\u0007\u0003/\t\t#!\f\u0011\u0007}\u000by#C\u0002\u00022E\u00111AU8x\u0011\u0015!\u0012\u00021\u0001_\u0001")
public interface BackfillCommand
extends LeafRunnableCommand,
DeltaCommand {
    public DeltaLog deltaLog();

    public String nameOfTriggeringOperation();

    public Option<CatalogTable> catalogTable();

    public BackfillExecutor getBackfillExecutor(SparkSession var1, OptimisticTransaction var2, FileMetadataMaterializationTracker var3, int var4, BackfillCommandStats var5);

    public Dataset<AddFile> filesToBackfill(OptimisticTransaction var1);

    public String opType();

    public BackfillBatch constructBatch(Seq<AddFile> var1);

    public static /* synthetic */ Seq run$(BackfillCommand $this, SparkSession spark) {
        return $this.run(spark);
    }

    default public Seq<Row> run(SparkSession spark) {
        int maxNumBatchesInParallel = BoxesRunTime.unboxToInt((Object)spark.conf().get(DeltaSQLConf$.MODULE$.DELTA_BACKFILL_MAX_NUM_BATCHES_IN_PARALLEL()));
        this.recordDeltaOperation(this.deltaLog(), this.opType(), this.recordDeltaOperation$default$3(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            DeltaLog qual$1 = this.deltaLog();
            Option<CatalogTable> x$1 = this.catalogTable();
            Option<Snapshot> x$2 = qual$1.startTransaction$default$2();
            OptimisticTransaction txn = qual$1.startTransaction(x$1, x$2);
            txn.executionObserver().preparingCommit((JFunction0.mcV.sp & Serializable)() -> {});
            txn.executionObserver().beginDoCommit();
            txn.executionObserver().beginBackfill();
            txn.executionObserver().beginPostCommit();
            int maxNumFilesPerCommit = BoxesRunTime.unboxToInt((Object)spark.conf().get(DeltaSQLConf$.MODULE$.DELTA_BACKFILL_MAX_NUM_FILES_PER_COMMIT()));
            String metricsOpType = "delta.backfill.materialization.trackerMetrics";
            FileMetadataMaterializationTracker$.MODULE$.withTracker(txn, spark, metricsOpType, (Function1<FileMetadataMaterializationTracker, BoxedUnit>)(Function1 & Serializable)fileMaterializationTracker -> {
                BackfillCommand.$anonfun$run$3(this, txn, maxNumBatchesInParallel, spark, maxNumFilesPerCommit, fileMaterializationTracker);
                return BoxedUnit.UNIT;
            });
        });
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static /* synthetic */ void $anonfun$run$3(BackfillCommand $this, OptimisticTransaction txn$1, int maxNumBatchesInParallel$1, SparkSession spark$1, int maxNumFilesPerCommit$1, FileMetadataMaterializationTracker fileMaterializationTracker) {
        long startTimeNs = System.nanoTime();
        BackfillCommandStats backfillStats = new BackfillCommandStats(txn$1.txnId(), $this.nameOfTriggeringOperation(), maxNumBatchesInParallel$1, BackfillCommandStats$.MODULE$.apply$default$4(), BackfillCommandStats$.MODULE$.apply$default$5(), BackfillCommandStats$.MODULE$.apply$default$6(), BackfillCommandStats$.MODULE$.apply$default$7());
        try {
            BackfillExecutor backfillExecutor = $this.getBackfillExecutor(spark$1, txn$1, fileMaterializationTracker, maxNumBatchesInParallel$1, backfillStats);
            try (BackfillBatchIterator<BackfillBatch> batches = new BackfillBatchIterator<BackfillBatch>($this.filesToBackfill(txn$1), fileMaterializationTracker, maxNumFilesPerCommit$1, (Function1 & Serializable)files -> $this.constructBatch((Seq<AddFile>)files));){
                backfillExecutor.run(batches);
            }
            backfillStats.wasSuccessful_$eq(true);
        }
        finally {
            long totalExecutionTimeMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs);
            backfillStats.totalExecutionTimeMs_$eq(totalExecutionTimeMs);
            DeltaLog x$3 = txn$1.deltaLog();
            String x$4 = new StringBuilder(6).append($this.opType()).append(".stats").toString();
            BackfillCommandStats x$5 = backfillStats;
            Map x$6 = $this.recordDeltaEvent$default$3();
            Option x$7 = $this.recordDeltaEvent$default$5();
            $this.recordDeltaEvent(x$3, x$4, x$6, x$5, x$7);
            txn$1.executionObserver().transactionCommitted();
        }
    }

    public static void $init$(BackfillCommand $this) {
    }
}

