/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands.backfill;

import java.io.Serializable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.delta.FileMetadataMaterializationTracker;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.commands.backfill.BackfillBatch;
import org.apache.spark.sql.delta.commands.backfill.BackfillCommandStats;
import org.apache.spark.sql.delta.commands.backfill.BackfillExecutor$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005]aaB\t\u0013!\u0003\r\t!\t\u0005\u0006]\u0001!\ta\f\u0005\u00067\u00011\ta\r\u0005\u0006q\u00011\t!\u000f\u0005\u0006}\u00011\ta\u0010\u0005\u0006\u0007\u00021\t\u0001\u0012\u0005\u0006\u0011\u00021\t!\u0013\u0005\u0006\u001d\u00021\ta\u0014\u0005\u00067\u0002!\t\u0001\u0018\u0005\u0006W\u0002!I\u0001\\\u0004\u0007uJA\tAF>\u0007\rE\u0011\u0002\u0012\u0001\f}\u0011\u0015i8\u0002\"\u0001\u007f\u0011)y8\u00021AA\u0002\u0013%\u0011\u0011\u0001\u0005\f\u0003\u0013Y\u0001\u0019!a\u0001\n\u0013\tY\u0001C\u0006\u0002\u0012-\u0001\r\u0011!Q!\n\u0005\r\u0001\u0002CA\n\u0017\u0011\u0005!#!\u0006\u0003!\t\u000b7m\u001b4jY2,\u00050Z2vi>\u0014(BA\n\u0015\u0003!\u0011\u0017mY6gS2d'BA\u000b\u0017\u0003!\u0019w.\\7b]\u0012\u001c(BA\f\u0019\u0003\u0015!W\r\u001c;b\u0015\tI\"$A\u0002tc2T!a\u0007\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0005uq\u0012AB1qC\u000eDWMC\u0001 \u0003\ry'oZ\u0002\u0001'\r\u0001!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-2\u0012\u0001C7fi\u0016\u0014\u0018N\\4\n\u00055R#\u0001\u0004#fYR\fGj\\4hS:<\u0017A\u0002\u0013j]&$H\u0005F\u00011!\t\u0019\u0013'\u0003\u00023I\t!QK\\5u+\u0005!\u0004CA\u001b7\u001b\u0005A\u0012BA\u001c\u0019\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u001dy'/[4Uq:,\u0012A\u000f\t\u0003wqj\u0011AF\u0005\u0003{Y\u0011Qc\u00149uS6L7\u000f^5d)J\fgn]1di&|g.A\u0004ue\u0006\u001c7.\u001a:\u0016\u0003\u0001\u0003\"aO!\n\u0005\t3\"A\t$jY\u0016lU\r^1eCR\fW*\u0019;fe&\fG.\u001b>bi&|g\u000e\u0016:bG.,'/\u0001\u000bnCb\u0014\u0015\r^2iKNLe\u000eU1sC2dW\r\\\u000b\u0002\u000bB\u00111ER\u0005\u0003\u000f\u0012\u00121!\u00138u\u00035\u0011\u0017mY6gS2d7\u000b^1ugV\t!\n\u0005\u0002L\u00196\t!#\u0003\u0002N%\t!\")Y2lM&dGnQ8n[\u0006tGm\u0015;biN\f1CY1dW\u001aKG\u000e\u001c\"bi\u000eDw\n\u001d+za\u0016,\u0012\u0001\u0015\t\u0003#bs!A\u0015,\u0011\u0005M#S\"\u0001+\u000b\u0005U\u0003\u0013A\u0002\u001fs_>$h(\u0003\u0002XI\u00051\u0001K]3eK\u001aL!!\u0017.\u0003\rM#(/\u001b8h\u0015\t9F%A\u0002sk:$\"\u0001M/\t\u000byC\u0001\u0019A0\u0002\u000f\t\fGo\u00195fgB\u0019\u0001-\u001a5\u000f\u0005\u0005\u001cgBA*c\u0013\u0005)\u0013B\u00013%\u0003\u001d\u0001\u0018mY6bO\u0016L!AZ4\u0003\u0011%#XM]1u_JT!\u0001\u001a\u0013\u0011\u0005-K\u0017B\u00016\u0013\u00055\u0011\u0015mY6gS2d')\u0019;dQ\u00061R\r_3dkR,')Y2lM&dGNQ1uG\",7\u000fF\u00021[:DQAX\u0005A\u0002}CQa\\\u0005A\u0002A\fQ#Y2uSZ,G\u000b\u001b:fC\u0012\u001cV-\\1qQ>\u0014X\r\u0005\u0002rq6\t!O\u0003\u0002ti\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005U4\u0018\u0001B;uS2T\u0011a^\u0001\u0005U\u00064\u0018-\u0003\u0002ze\nI1+Z7ba\"|'/Z\u0001\u0011\u0005\u0006\u001c7NZ5mY\u0016CXmY;u_J\u0004\"aS\u0006\u0014\u0007-\u0011\u0003&\u0001\u0004=S:LGO\u0010\u000b\u0002w\u0006QA\u000f\u001b:fC\u0012\u0004vn\u001c7\u0016\u0005\u0005\r\u0001cA9\u0002\u0006%\u0019\u0011q\u0001:\u0003%QC'/Z1e!>|G.\u0012=fGV$xN]\u0001\u000fi\"\u0014X-\u00193Q_>dw\fJ3r)\r\u0001\u0014Q\u0002\u0005\n\u0003\u001fq\u0011\u0011!a\u0001\u0003\u0007\t1\u0001\u001f\u00132\u0003-!\bN]3bIB{w\u000e\u001c\u0011\u0002+\u001d,Go\u0014:De\u0016\fG/\u001a+ie\u0016\fG\rU8pYR\u0011\u00111\u0001")
public interface BackfillExecutor
extends DeltaLogging {
    public SparkSession spark();

    public OptimisticTransaction origTxn();

    public FileMetadataMaterializationTracker tracker();

    public int maxBatchesInParallel();

    public BackfillCommandStats backfillStats();

    public String backFillBatchOpType();

    public static /* synthetic */ void run$(BackfillExecutor $this, Iterator batches) {
        $this.run((Iterator<BackfillBatch>)batches);
    }

    default public void run(Iterator<BackfillBatch> batches) {
        if (batches.isEmpty()) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Backfill command did not need to update any files"}))).log((Seq)Nil$.MODULE$)));
            return;
        }
        this.executeBackfillBatches(batches, new Semaphore(this.maxBatchesInParallel()));
    }

    private void executeBackfillBatches(Iterator<BackfillBatch> batches, Semaphore activeThreadSemaphore) {
        ThreadPoolExecutor globalThreadPool = BackfillExecutor$.MODULE$.getOrCreateThreadPool();
        ArrayBuffer futures = new ArrayBuffer();
        AtomicInteger numSuccessfulBatch = new AtomicInteger(0);
        AtomicInteger numFailedBatch = new AtomicInteger(0);
        try {
            try {
                batches.zipWithIndex().foreach((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        BackfillBatch batch = (BackfillBatch)tuple2._1();
                        int batchId = tuple2._2$mcI$sp();
                        activeThreadSemaphore.acquire();
                        return (ArrayBuffer)futures.$plus$eq(globalThreadPool.submit(() -> {
                            BackfillExecutor.$anonfun$executeBackfillBatches$2(this, batch, batchId, numSuccessfulBatch, numFailedBatch, activeThreadSemaphore);
                            return BoxedUnit.UNIT;
                        }));
                    }
                    throw new MatchError((Object)tuple2);
                });
                futures.foreach((Function1 & Serializable)x$1 -> {
                    x$1.get();
                    return BoxedUnit.UNIT;
                });
            }
            catch (Throwable t) {
                boolean mayInterruptIfRunning = false;
                futures.foreach((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.cancel(mayInterruptIfRunning)));
                throw t;
            }
        }
        finally {
            this.backfillStats().numSuccessfulBatches_$eq(numSuccessfulBatch.get());
            this.backfillStats().numFailedBatches_$eq(numFailedBatch.get());
        }
    }

    public static /* synthetic */ void $anonfun$executeBackfillBatches$2(BackfillExecutor $this, BackfillBatch batch$1, int batchId$1, AtomicInteger numSuccessfulBatch$1, AtomicInteger numFailedBatch$1, Semaphore activeThreadSemaphore$1) {
        try {
            SparkSession$.MODULE$.setActiveSession($this.spark());
            $this.recordDeltaOperation($this.origTxn().deltaLog(), $this.backFillBatchOpType(), $this.recordDeltaOperation$default$3(), (JFunction0.mcV.sp & Serializable)() -> batch$1.execute($this.origTxn(), batchId$1, numSuccessfulBatch$1, numFailedBatch$1));
        }
        finally {
            activeThreadSemaphore$1.release();
            if ($this.tracker() != null) {
                $this.tracker().releasePermits(batch$1.filesInBatch().length());
            }
        }
    }

    public static void $init$(BackfillExecutor $this) {
    }
}

